/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.internal.text;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.phpeclipse.ui.editor.I18NDocumentProvider;
import net.sourceforge.phpeclipse.xml.ui.internal.text.WhitespaceDetector;
import org.eclipse.jface.text.rules.IWhitespaceDetector;

public abstract class AbstractDocumentProvider
extends I18NDocumentProvider {
    protected IWhitespaceDetector detector = new WhitespaceDetector();

    public String getDefaultEncoding() {
        return "UTF-8";
    }

    public String getDeclaredEncoding(InputStream in) throws IOException {
        int ch;
        if (!in.markSupported()) {
            in = new BufferedInputStream(in, 512);
        }
        in.mark(512);
        String encoding = super.getDeclaredEncoding(in);
        if (encoding != null) {
            return encoding;
        }
        in.reset();
        if (!this.skipXMLDecl(in)) {
            return null;
        }
        this.skipEncoding(in);
        do {
            if ((ch = in.read()) >= 0) continue;
            return null;
        } while (this.detector.isWhitespace((char)ch));
        if (ch != 34 && ch != 39) {
            return null;
        }
        int delimiter = ch;
        StringBuffer buf = new StringBuffer();
        while (true) {
            int ch2;
            if ((ch2 = in.read()) < 0) {
                return null;
            }
            if (ch2 == delimiter) break;
            buf.append((char)ch2);
        }
        return buf.toString();
    }

    private boolean skipXMLDecl(InputStream in) throws IOException {
        int ch = in.read();
        if (ch != 60) {
            return false;
        }
        ch = in.read();
        if (ch != 63) {
            return false;
        }
        ch = in.read();
        if (ch != 120) {
            return false;
        }
        ch = in.read();
        if (ch != 109) {
            return false;
        }
        ch = in.read();
        return ch == 108;
    }

    private boolean skipEncoding(InputStream in) throws IOException {
        int ch = in.read();
        boolean whitespace = false;
        while (true) {
            if (ch < 0) {
                return false;
            }
            if (this.detector.isWhitespace((char)ch)) {
                ch = in.read();
                whitespace = true;
                continue;
            }
            if (ch == 63 || ch == 60) {
                return false;
            }
            if (ch != 101) {
                ch = in.read();
                whitespace = false;
                continue;
            }
            if (!whitespace) {
                ch = in.read();
                continue;
            }
            ch = in.read();
            if (ch == 110 && (ch = in.read()) == 99 && (ch = in.read()) == 111 && (ch = in.read()) == 100 && (ch = in.read()) == 105 && (ch = in.read()) == 110 && (ch = in.read()) == 103) break;
            whitespace = false;
        }
        do {
            if ((ch = in.read()) >= 0) continue;
            return false;
        } while (this.detector.isWhitespace((char)ch));
        return ch == 61;
        {
        }
    }
}

