/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.internal.text;

import net.sourceforge.phpeclipse.ui.text.TextDoubleClickStrategy;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;

public class TagDoubleClickStrategy
extends TextDoubleClickStrategy {
    public void doubleClicked(ITextViewer viewer) {
        int offset = viewer.getSelectedRange().x;
        if (offset < 0) {
            return;
        }
        try {
            IDocument document = viewer.getDocument();
            ITypedRegion region = document.getPartition(offset);
            int start = region.getOffset();
            if (offset == start && document.getChar(offset) == '<') {
                region = document.getPartition(offset);
                if (document.getChar((offset = region.getOffset() + region.getLength()) - 1) != '>') {
                    while (offset < document.getLength()) {
                        region = document.getPartition(offset);
                        offset = region.getOffset() + region.getLength();
                        if ("__xml_attribute".equals(region.getType())) continue;
                        if ("__xml_tag".equals(region.getType())) {
                            if (document.getChar(region.getOffset()) != '<' && document.getChar(offset - 1) != '>') continue;
                            break;
                        }
                        offset = region.getOffset();
                        break;
                    }
                }
                viewer.setSelectedRange(start, offset - start);
                return;
            }
            int end = start + region.getLength();
            if (offset == end - 1 && document.getChar(offset) == '>') {
                region = document.getPartition(offset);
                if (document.getChar(offset = region.getOffset()) != '<') {
                    while (offset > 0) {
                        region = document.getPartition(offset - 1);
                        offset = region.getOffset();
                        if ("__xml_attribute".equals(region.getType())) continue;
                        if ("__xml_tag".equals(region.getType())) {
                            if (document.getChar(offset) != '<') continue;
                            break;
                        }
                        offset += region.getLength();
                        break;
                    }
                }
                viewer.setSelectedRange(offset, end - offset);
                return;
            }
            super.doubleClicked(viewer);
        }
        catch (BadLocationException badLocationException) {}
    }
}

