/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.internal.text;

import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;

public class XMLCDATAScanner
implements ITokenScanner {
    private Map tokens;
    private IDocument document;
    private int begin;
    private int end;
    private int offset;
    private int length;
    private int position;

    public XMLCDATAScanner(Map tokens) {
        this.tokens = tokens;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.document = document;
        this.begin = offset;
        this.end = offset + length;
        this.offset = offset;
        this.position = offset;
        this.length = 0;
    }

    public IToken nextToken() {
        this.offset += this.length;
        if (this.position == this.begin) {
            try {
                if (this.document.get(this.position, 9).equals("<![CDATA[")) {
                    this.position += 9;
                    return this.getToken("xml_cdata");
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        if (this.position == this.end) {
            return this.getToken(null);
        }
        try {
            int p = this.end - 3;
            if (this.document.get(p, 3).equals("]]>")) {
                if (this.position == p) {
                    this.position = this.end;
                    return this.getToken("xml_cdata");
                }
                this.position = p;
            } else {
                this.position = this.end;
            }
        }
        catch (BadLocationException badLocationException) {}
        return this.getToken("xml_text");
    }

    private IToken getToken(String type) {
        this.length = this.position - this.offset;
        if (this.length == 0) {
            return Token.EOF;
        }
        if (type == null) {
            return Token.UNDEFINED;
        }
        IToken token = (IToken)this.tokens.get(type);
        if (token == null) {
            return Token.UNDEFINED;
        }
        return token;
    }

    public int getTokenOffset() {
        return this.offset;
    }

    public int getTokenLength() {
        return this.length;
    }
}

