/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.internal.text;

import net.sourceforge.phpeclipse.ui.templates.template.BasicCompletionProcessor;
import net.sourceforge.phpeclipse.ui.text.TextDoubleClickStrategy;
import net.sourceforge.phpeclipse.xml.ui.internal.text.AttValueDoubleClickStrategy;
import net.sourceforge.phpeclipse.xml.ui.internal.text.SimpleDoubleClickStrategy;
import net.sourceforge.phpeclipse.xml.ui.internal.text.TagDoubleClickStrategy;
import net.sourceforge.phpeclipse.xml.ui.internal.text.XMLAnnotationHover;
import net.sourceforge.phpeclipse.xml.ui.internal.text.XMLReconcilingStrategy;
import net.sourceforge.phpeclipse.xml.ui.internal.text.XMLTextHover;
import net.sourceforge.phpeclipse.xml.ui.text.XMLTextTools;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class XMLConfiguration
extends TextSourceViewerConfiguration {
    protected XMLTextTools xmlTextTools;
    private ITextDoubleClickStrategy dcsDefault;
    private ITextDoubleClickStrategy dcsSimple;
    private ITextDoubleClickStrategy dcsTag;
    private ITextDoubleClickStrategy dcsAttValue;
    private ITextEditor editor;

    public XMLConfiguration(XMLTextTools tools) {
        this(tools, null);
    }

    public XMLConfiguration(XMLTextTools tools, ITextEditor editor) {
        this.xmlTextTools = tools;
        this.editor = editor;
        this.dcsDefault = new TextDoubleClickStrategy();
        this.dcsSimple = new SimpleDoubleClickStrategy();
        this.dcsTag = new TagDoubleClickStrategy();
        this.dcsAttValue = new AttValueDoubleClickStrategy();
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new XMLAnnotationHover();
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.editor != null) {
            IDocumentProvider provider = this.editor.getDocumentProvider();
            IEditorInput input = this.editor.getEditorInput();
            IAnnotationModel model = provider.getAnnotationModel((Object)input);
            return new XMLTextHover(model);
        }
        return super.getTextHover(sourceViewer, contentType);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if ("__xml_comment".equals(contentType)) {
            return this.dcsSimple;
        }
        if ("__xml_processing_instruction".equals(contentType)) {
            return this.dcsSimple;
        }
        if ("__xml_tag".equals(contentType)) {
            return this.dcsTag;
        }
        if ("__xml_attribute".equals(contentType)) {
            return this.dcsAttValue;
        }
        if ("__xml_cdata".equals(contentType)) {
            return this.dcsSimple;
        }
        if (contentType.startsWith("__dtd_internal")) {
            return this.dcsSimple;
        }
        return this.dcsDefault;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_processing_instruction", "__xml_comment", "__xml_declaration", "__xml_tag", "__xml_attribute", "__xml_cdata", "__dtd_internal", "__dtd_internal_pi", "__dtd_internal_comment", "__dtd_internal_declaration"};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.xmlTextTools.getXMLTextScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.xmlTextTools.getDTDTextScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dtd_internal");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dtd_internal");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.xmlTextTools.getXMLPIScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_processing_instruction");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_processing_instruction");
        reconciler.setDamager((IPresentationDamager)dr, "__dtd_internal_pi");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dtd_internal_pi");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.xmlTextTools.getXMLCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_comment");
        reconciler.setDamager((IPresentationDamager)dr, "__dtd_internal_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dtd_internal_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.xmlTextTools.getXMLDeclScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_declaration");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_declaration");
        reconciler.setDamager((IPresentationDamager)dr, "__dtd_internal_declaration");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dtd_internal_declaration");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.xmlTextTools.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.xmlTextTools.getXMLAttributeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_attribute");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_attribute");
        dr = new DefaultDamagerRepairer(this.xmlTextTools.getXMLCDATAScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_cdata");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_cdata");
        return reconciler;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.editor != null && this.editor.isEditable()) {
            MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)new XMLReconcilingStrategy(this.editor), false);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            reconciler.setDelay(500);
            return reconciler;
        }
        return null;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        BasicCompletionProcessor processor = new BasicCompletionProcessor();
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__xml_tag");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__xml_processing_instruction");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__xml_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__xml_declaration");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__xml_tag");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__xml_attribute");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__xml_cdata");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dtd_internal");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dtd_internal_pi");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dtd_internal_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dtd_internal_declaration");
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }
}

