/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.ui.actions;

import net.sourceforge.phpeclipse.xdebug.ui.XDebugUIPlugin;
import net.sourceforge.phpeclipse.xdebug.ui.php.model.PHPLineBreakpointAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointRulerAction
extends Action {
    private IVerticalRulerInfo fRuler;
    private IWorkbenchPart fTargetPart;
    private PHPLineBreakpointAdapter fBreakpointAdapter;
    private static final ISelection EMPTY_SELECTION = new EmptySelection();

    public ToggleBreakpointRulerAction(IWorkbenchPart part, IVerticalRulerInfo ruler) {
        super("Toggle Breakpoint");
        this.fRuler = ruler;
        this.fRuler = ruler;
        this.setTargetPart(part);
        this.fBreakpointAdapter = new PHPLineBreakpointAdapter();
    }

    public void run() {
        try {
            this.fBreakpointAdapter.toggleLineBreakpoints(this.getTargetPart(), this.getTargetSelection());
        }
        catch (CoreException e) {
            XDebugUIPlugin.errorDialog(this.getTargetPart().getSite().getShell(), "Error", "Operation failed", e.getStatus());
        }
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    private IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    private void setTargetPart(IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    private ISelection getTargetSelection() {
        IDocument doc = this.getDocument();
        if (doc != null) {
            int line = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity();
            try {
                IRegion region = doc.getLineInformation(line);
                return new TextSelection(doc, region.getOffset(), region.getLength());
            }
            catch (BadLocationException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
        return EMPTY_SELECTION;
    }

    private IDocument getDocument() {
        ITextEditor textEditor;
        IDocumentProvider provider;
        IWorkbenchPart targetPart = this.getTargetPart();
        if (targetPart instanceof ITextEditor && (provider = (textEditor = (ITextEditor)targetPart).getDocumentProvider()) != null) {
            return provider.getDocument((Object)textEditor.getEditorInput());
        }
        return null;
    }

    static class EmptySelection
    implements ISelection {
        EmptySelection() {
        }

        public boolean isEmpty() {
            return true;
        }
    }
}

