/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.ui.php.launching;

import net.sourceforge.phpdt.internal.ui.PHPUiImages;
import net.sourceforge.phpdt.internal.ui.util.PHPProjectSelector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class PHPRemoteDebug
extends AbstractLaunchConfigurationTab {
    private PHPProjectSelector projectSelector;
    private Text fIdeIDText;
    static /* synthetic */ Class class$0;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.createIdeIDEditor(comp);
    }

    private void createProjectEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText("Project:");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.projectSelector = new PHPProjectSelector((Composite)group);
        this.projectSelector.setBrowseDialogMessage("Choose the project containing the application entry point:");
        this.projectSelector.setLayoutData((Object)new GridData(768));
        this.projectSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PHPRemoteDebug.this.updateLaunchConfigurationDialog();
            }
        });
        gd = new GridData(768);
    }

    private void createIdeIDEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText("Ide Identification String :");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.fIdeIDText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.fIdeIDText.setLayoutData((Object)gd);
        this.fIdeIDText.setFont(font);
        this.fIdeIDText.setTextLimit(48);
        this.fIdeIDText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PHPRemoteDebug.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected IProject getContext() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            Object obj;
            IStructuredSelection ss;
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty() && (obj = ss.getFirstElement()) instanceof IResource) {
                return ((IResource)obj).getProject();
            }
            IEditorPart part = page.getActiveEditor();
            if (part != null) {
                IResource file;
                IEditorInput input = part.getEditorInput();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((file = (IResource)input.getAdapter((Class)clazz)) != null) {
                    return file.getProject();
                }
            }
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IProject project = this.getContext();
        if (project != null) {
            configuration.setAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PDA_PROFECT", project.getName());
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String project = configuration.getAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PDA_PROFECT", null);
            if (project != null) {
                this.projectSelector.setSelectionText(project);
            }
            String ideID = configuration.getAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PHP_IDE_ID", "testID");
            this.fIdeIDText.setText(ideID);
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String project = this.projectSelector.getSelectionText().trim();
        configuration.setAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PDA_PROFECT", project);
        String ideID = this.fIdeIDText.getText().trim();
        configuration.setAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PHP_IDE_ID", ideID);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        String projectName = this.projectSelector.getSelectionText().trim();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            this.setErrorMessage("Project does not exist");
            return false;
        }
        String ideID = this.fIdeIDText.getText();
        if (ideID.indexOf(32) > 0) {
            this.setErrorMessage("No spaces in Identification String allowed");
            return false;
        }
        return true;
    }

    public Image getImage() {
        return PHPUiImages.get((String)"net.sourceforge.phpdt.internal.ui.php_page.gif");
    }

    public String getName() {
        return "Main";
    }
}

