/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.ui.views.logview;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import net.sourceforge.phpeclipse.xdebug.ui.XDebugUIPlugin;
import net.sourceforge.phpeclipse.xdebug.ui.XDebugUIPluginImages;
import net.sourceforge.phpeclipse.xdebug.ui.views.logview.EventDetailsDialogAction;
import net.sourceforge.phpeclipse.xdebug.ui.views.logview.FilterDialog;
import net.sourceforge.phpeclipse.xdebug.ui.views.logview.LogEntry;
import net.sourceforge.phpeclipse.xdebug.ui.views.logview.LogReader;
import net.sourceforge.phpeclipse.xdebug.ui.views.logview.LogViewContentProvider;
import net.sourceforge.phpeclipse.xdebug.ui.views.logview.LogViewLabelProvider;
import net.sourceforge.phpeclipse.xdebug.ui.views.logview.OpenLogDialog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class LogView
extends ViewPart
implements ILogListener {
    public static final String ID_LOGVIEW = "net.sourceforge.phpdt.internal.debug.core.logview.LogView";
    private TreeViewer tableTreeViewer;
    private ArrayList logs = new ArrayList();
    public static final String P_LOG_WARNING = "warning";
    public static final String P_LOG_ERROR = "error";
    public static final String P_LOG_INFO = "info";
    public static final String P_LOG_LIMIT = "limit";
    public static final String P_USE_LIMIT = "useLimit";
    public static final String P_SHOW_ALL_SESSIONS = "allSessions";
    private static final String P_COLUMN_1 = "column1";
    private static final String P_COLUMN_2 = "column2";
    private static final String P_COLUMN_3 = "column3";
    private static final String P_COLUMN_4 = "column4";
    public static final String P_ACTIVATE = "activate";
    private int MESSAGE_ORDER = -1;
    private int PLUGIN_ORDER = -1;
    private int DATE_ORDER = -1;
    public static byte MESSAGE = 0;
    public static byte PLUGIN = 1;
    public static byte DATE = (byte)2;
    private static int ASCENDING = 1;
    private static int DESCENDING = -1;
    private Action clearAction;
    private Action copyAction;
    private Action readLogAction;
    private Action deleteLogAction;
    private Action exportAction;
    private Action importAction;
    private Action activateViewAction;
    private Action propertiesAction;
    private Action viewLogAction;
    private Action filterAction;
    private Clipboard clipboard;
    private IMemento memento;
    private File inputFile = Platform.getLogFileLocation().toFile();
    private String directory;
    private TreeColumn column0;
    private TreeColumn column1;
    private TreeColumn column2;
    private TreeColumn column3;
    private TreeColumn column4;
    private static Font boldFont;
    private Comparator comparator;
    private Collator collator;
    private boolean canOpenTextShell;
    private Text textLabel;
    private Shell textShell;
    private boolean firstEvent = true;
    static /* synthetic */ Class class$0;

    public void createPartControl(Composite parent) {
        this.readLogFile();
        Tree tableTree = new Tree(parent, 65536);
        tableTree.setLayoutData((Object)new GridData(1808));
        this.createColumns(tableTree);
        this.createViewer(tableTree);
        this.createPopupMenuManager(tableTree);
        this.makeActions(tableTree);
        this.fillToolBar();
        Platform.addLogListener((ILogListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableTreeViewer);
        this.clipboard = new Clipboard(tableTree.getDisplay());
        this.tableTreeViewer.getTree().setToolTipText("");
        this.initializeFonts();
        this.applyFonts();
    }

    private void initializeFonts() {
        Font tableFont = this.tableTreeViewer.getTree().getFont();
        FontData[] fontDataList = tableFont.getFontData();
        FontData fontData = fontDataList.length > 0 ? fontDataList[0] : new FontData();
        fontData.setStyle(1);
        boldFont = new Font((Device)this.tableTreeViewer.getTree().getDisplay(), fontData);
    }

    private void applyFonts() {
        if (this.tableTreeViewer == null || this.tableTreeViewer.getTree().isDisposed()) {
            return;
        }
        int max = this.tableTreeViewer.getTree().getItemCount();
        int index = 0;
        int tableIndex = 0;
        while (index < max) {
            LogEntry entry = null;
            if (entry == null) {
                return;
            }
            if (entry.hasChildren()) {
                this.tableTreeViewer.getTree().getItems()[index].setFont(boldFont);
                tableIndex = this.applyChildFonts(entry, tableIndex);
            } else {
                this.tableTreeViewer.getTree().getItems()[index].setFont(this.tableTreeViewer.getTree().getFont());
            }
            ++index;
            ++tableIndex;
        }
    }

    private int applyChildFonts(LogEntry parent, int index) {
        if (!this.tableTreeViewer.getExpandedState((Object)parent) || !parent.hasChildren()) {
            return index;
        }
        LogEntry[] children = this.getEntryChildren(parent);
        int i = 0;
        while (i < children.length) {
            TreeItem tableItem;
            ++index;
            if (children[i].hasChildren()) {
                tableItem = this.getTableItem(index);
                if (tableItem != null) {
                    tableItem.setFont(boldFont);
                }
                index = this.applyChildFonts(children[i], index);
            } else {
                tableItem = this.getTableItem(index);
                if (tableItem != null) {
                    tableItem.setFont(this.tableTreeViewer.getTree().getFont());
                }
            }
            ++i;
        }
        return index;
    }

    private LogEntry[] getEntryChildren(LogEntry parent) {
        Object[] entryChildren = parent.getChildren((Object)parent);
        if (this.comparator != null) {
            Arrays.sort(entryChildren, this.comparator);
        }
        LogEntry[] children = new LogEntry[entryChildren.length];
        System.arraycopy(entryChildren, 0, children, 0, entryChildren.length);
        return children;
    }

    private TreeItem getTableItem(int index) {
        TreeItem[] tableItems = this.tableTreeViewer.getTree().getItems();
        if (index > tableItems.length - 1) {
            return null;
        }
        return tableItems[index];
    }

    private void fillToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        IToolBarManager toolBarManager = bars.getToolBarManager();
        toolBarManager.add((IAction)this.exportAction);
        toolBarManager.add((IAction)this.importAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.clearAction);
        toolBarManager.add((IAction)this.deleteLogAction);
        toolBarManager.add((IAction)this.viewLogAction);
        toolBarManager.add((IAction)this.readLogAction);
        toolBarManager.add((IContributionItem)new Separator());
        IMenuManager mgr = bars.getMenuManager();
        mgr.add((IAction)this.filterAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.activateViewAction);
    }

    private void createViewer(Tree tableTree) {
        this.tableTreeViewer = new TreeViewer(tableTree);
        this.tableTreeViewer.setContentProvider((IContentProvider)new LogViewContentProvider(this));
        this.tableTreeViewer.setLabelProvider((IBaseLabelProvider)new LogViewLabelProvider());
        this.tableTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                LogView.this.handleSelectionChanged(e.getSelection());
                if (LogView.this.propertiesAction.isEnabled()) {
                    ((EventDetailsDialogAction)LogView.this.propertiesAction).resetSelection();
                }
            }
        });
        this.tableTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ((EventDetailsDialogAction)LogView.this.propertiesAction).setComparator(LogView.this.comparator);
                LogView.this.propertiesAction.run();
            }
        });
        this.tableTreeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                LogView.this.applyFonts();
            }

            public void treeExpanded(TreeExpansionEvent event) {
                LogView.this.applyFonts();
            }
        });
        this.addMouseListeners();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.Platform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.tableTreeViewer.setInput((Object)clazz);
    }

    private void createPopupMenuManager(Tree tableTree) {
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                LogView.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Menu menu = popupMenuManager.createContextMenu((Control)tableTree);
        tableTree.setMenu(menu);
    }

    private void createColumns(Tree table) {
        this.column0 = new TreeColumn(table, 0);
        this.column0.setText("");
        this.column1 = new TreeColumn(table, 0);
        this.column1.setText(XDebugUIPlugin.getString("LogView.column.severity"));
        this.column2 = new TreeColumn(table, 0);
        this.column2.setText(XDebugUIPlugin.getString("LogView.column.message"));
        this.column2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogView logView = LogView.this;
                logView.MESSAGE_ORDER = logView.MESSAGE_ORDER * -1;
                ViewerSorter sorter = LogView.this.getViewerSorter(MESSAGE);
                LogView.this.tableTreeViewer.setSorter(sorter);
                LogView.this.collator = sorter.getCollator();
                boolean isComparatorSet = ((EventDetailsDialogAction)LogView.this.propertiesAction).resetSelection(MESSAGE, LogView.this.MESSAGE_ORDER);
                LogView.this.setComparator(MESSAGE);
                if (!isComparatorSet) {
                    ((EventDetailsDialogAction)LogView.this.propertiesAction).setComparator(LogView.this.comparator);
                }
                LogView.this.applyFonts();
            }
        });
        this.column3 = new TreeColumn(table, 0);
        this.column3.setText(XDebugUIPlugin.getString("LogView.column.plugin"));
        this.column3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogView logView = LogView.this;
                logView.PLUGIN_ORDER = logView.PLUGIN_ORDER * -1;
                ViewerSorter sorter = LogView.this.getViewerSorter(PLUGIN);
                LogView.this.tableTreeViewer.setSorter(sorter);
                LogView.this.collator = sorter.getCollator();
                boolean isComparatorSet = ((EventDetailsDialogAction)LogView.this.propertiesAction).resetSelection(PLUGIN, LogView.this.PLUGIN_ORDER);
                LogView.this.setComparator(PLUGIN);
                if (!isComparatorSet) {
                    ((EventDetailsDialogAction)LogView.this.propertiesAction).setComparator(LogView.this.comparator);
                }
                LogView.this.applyFonts();
            }
        });
        this.column4 = new TreeColumn(table, 0);
        this.column4.setText(XDebugUIPlugin.getString("LogView.column.date"));
        this.column4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LogView.this.DATE_ORDER == ASCENDING) {
                    LogView.this.DATE_ORDER = DESCENDING;
                } else {
                    LogView.this.DATE_ORDER = ASCENDING;
                }
                ViewerSorter sorter = LogView.this.getViewerSorter(DATE);
                LogView.this.tableTreeViewer.setSorter(sorter);
                LogView.this.collator = sorter.getCollator();
                boolean isComparatorSet = ((EventDetailsDialogAction)LogView.this.propertiesAction).resetSelection(DATE, LogView.this.DATE_ORDER);
                LogView.this.setComparator(DATE);
                if (!isComparatorSet) {
                    ((EventDetailsDialogAction)LogView.this.propertiesAction).setComparator(LogView.this.comparator);
                }
                LogView.this.applyFonts();
            }
        });
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnPixelData(21));
        tlayout.addColumnData((ColumnLayoutData)new ColumnPixelData(this.memento.getInteger(P_COLUMN_1).intValue()));
        tlayout.addColumnData((ColumnLayoutData)new ColumnPixelData(this.memento.getInteger(P_COLUMN_2).intValue()));
        tlayout.addColumnData((ColumnLayoutData)new ColumnPixelData(this.memento.getInteger(P_COLUMN_3).intValue()));
        tlayout.addColumnData((ColumnLayoutData)new ColumnPixelData(this.memento.getInteger(P_COLUMN_4).intValue()));
        table.setLayout((Layout)tlayout);
        table.setHeaderVisible(true);
    }

    private void makeActions(Tree table) {
        this.propertiesAction = new EventDetailsDialogAction(table.getShell(), (ISelectionProvider)this.tableTreeViewer);
        this.propertiesAction.setImageDescriptor(XDebugUIPluginImages.getImageDescriptor("IMG_PROPERTIES"));
        this.propertiesAction.setDisabledImageDescriptor(XDebugUIPluginImages.getImageDescriptor("IMG_PROPERTIES"));
        this.propertiesAction.setToolTipText(XDebugUIPlugin.getString("LogView.properties.tooltip"));
        this.propertiesAction.setEnabled(false);
        this.clearAction = new Action(XDebugUIPlugin.getString("LogView.clear")){

            public void run() {
                LogView.this.handleClear();
            }
        };
        this.clearAction.setImageDescriptor(XDebugUIPluginImages.getImageDescriptor("IMG_CLEAR"));
        this.clearAction.setDisabledImageDescriptor(XDebugUIPluginImages.getImageDescriptor("IMG_CLEAR"));
        this.clearAction.setToolTipText(XDebugUIPlugin.getString("LogView.clear.tooltip"));
        this.clearAction.setText(XDebugUIPlugin.getString("LogView.clear"));
        this.readLogAction = new Action(XDebugUIPlugin.getString("LogView.readLog.restore")){

            public void run() {
                LogView.this.inputFile = Platform.getLogFileLocation().toFile();
                LogView.this.reloadLog();
            }
        };
        this.readLogAction.setToolTipText(XDebugUIPlugin.getString("LogView.readLog.restore.tooltip"));
        this.readLogAction.setImageDescriptor(XDebugUIPluginImages.getImageDescriptor("IMG_READ_LOG"));
        this.readLogAction.setDisabledImageDescriptor(XDebugUIPluginImages.getImageDescriptor("IMG_READ_LOG"));
        this.deleteLogAction = new Action(XDebugUIPlugin.getString("LogView.delete")){

            public void run() {
                LogView.this.doDeleteLog();
            }
        };
        this.deleteLogAction.setToolTipText(XDebugUIPlugin.getString("LogView.delete.tooltip"));
        this.deleteLogAction.setImageDescriptor(XDebugUIPluginImages.getImageDescriptor("IMG_REMOVE_LOG"));
        this.deleteLogAction.setDisabledImageDescriptor(XDebugUIPluginImages.getImageDescriptor("IMG_REMOVE_LOG"));
        this.deleteLogAction.setEnabled(this.inputFile.exists() && this.inputFile.equals(Platform.getLogFileLocation().toFile()));
        this.copyAction = new Action(XDebugUIPlugin.getString("LogView.copy")){

            public void run() {
                LogView.this.copyToClipboard(LogView.this.tableTreeViewer.getSelection());
            }
        };
        this.copyAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.filterAction = new Action(XDebugUIPlugin.getString("LogView.filter")){

            public void run() {
                LogView.this.handleFilter();
            }
        };
        this.filterAction.setToolTipText(XDebugUIPlugin.getString("LogView.filter"));
        this.filterAction.setImageDescriptor(XDebugUIPluginImages.getImageDescriptor("IMG_FILTER"));
        this.filterAction.setDisabledImageDescriptor(XDebugUIPluginImages.getImageDescriptor("IMG_FILTER"));
        this.exportAction = new Action(XDebugUIPlugin.getString("LogView.export")){

            public void run() {
                LogView.this.handleExport();
            }
        };
        this.exportAction.setToolTipText(XDebugUIPlugin.getString("LogView.export.tooltip"));
        this.exportAction.setImageDescriptor(XDebugUIPluginImages.getImageDescriptor("IMG_EXPORT"));
        this.exportAction.setDisabledImageDescriptor(XDebugUIPluginImages.getImageDescriptor("IMG_EXPORT"));
        this.importAction = new Action(XDebugUIPlugin.getString("LogView.import")){

            public void run() {
                LogView.this.handleImport();
            }
        };
        this.importAction.setToolTipText(XDebugUIPlugin.getString("LogView.import.tooltip"));
        this.importAction.setImageDescriptor(XDebugUIPluginImages.getImageDescriptor("IMG_IMPORT"));
        this.importAction.setDisabledImageDescriptor(XDebugUIPluginImages.getImageDescriptor("IMG_IMPORT"));
        this.activateViewAction = new Action(XDebugUIPlugin.getString("LogView.activate")){

            public void run() {
            }
        };
        this.activateViewAction.setChecked(this.memento.getString(P_ACTIVATE).equals("true"));
        this.viewLogAction = new Action(XDebugUIPlugin.getString("LogView.view.currentLog")){

            public void run() {
                if (LogView.this.inputFile.exists()) {
                    if (LogView.this.inputFile.length() > 0x100000L) {
                        OpenLogDialog openDialog = new OpenLogDialog(LogView.this.getViewSite().getShell(), LogView.this.inputFile);
                        openDialog.create();
                        openDialog.open();
                    } else {
                        boolean canLaunch = Program.launch((String)LogView.this.inputFile.getAbsolutePath());
                        if (!canLaunch) {
                            Program p = Program.findProgram((String)".txt");
                            if (p != null) {
                                p.execute(LogView.this.inputFile.getAbsolutePath());
                            } else {
                                OpenLogDialog openDialog = new OpenLogDialog(LogView.this.getViewSite().getShell(), LogView.this.inputFile);
                                openDialog.create();
                                openDialog.open();
                            }
                        }
                    }
                }
            }
        };
        this.viewLogAction.setImageDescriptor(XDebugUIPluginImages.getImageDescriptor("IMG_OPEN_LOG"));
        this.viewLogAction.setDisabledImageDescriptor(XDebugUIPluginImages.getImageDescriptor("IMG_OPEN_LOG"));
        this.viewLogAction.setEnabled(this.inputFile.exists());
        this.viewLogAction.setToolTipText(XDebugUIPlugin.getString("LogView.view.currentLog.tooltip"));
    }

    public void dispose() {
        Platform.removeLogListener((ILogListener)this);
        this.clipboard.dispose();
        LogReader.reset();
        boldFont.dispose();
        super.dispose();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleImport() {
        String path;
        FileDialog dialog = new FileDialog(this.getViewSite().getShell());
        dialog.setFilterExtensions(new String[]{"*.log"});
        if (this.directory != null) {
            dialog.setFilterPath(this.directory);
        }
        if ((path = dialog.open()) == null) return;
        if (!new Path(path).toFile().exists()) return;
        this.inputFile = new Path(path).toFile();
        this.directory = this.inputFile.getParent();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(XDebugUIPlugin.getString("LogView.operation.importing"), -1);
                LogView.this.readLogFile();
            }
        };
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getViewSite().getShell());
        try {
            try {
                pmd.run(true, true, op);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.readLogAction.setText(XDebugUIPlugin.getString("LogView.readLog.reload"));
            this.readLogAction.setToolTipText(XDebugUIPlugin.getString("LogView.readLog.reload"));
            this.asyncRefresh(false);
            this.resetDialogButtons();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.readLogAction.setText(XDebugUIPlugin.getString("LogView.readLog.reload"));
        this.readLogAction.setToolTipText(XDebugUIPlugin.getString("LogView.readLog.reload"));
        this.asyncRefresh(false);
        this.resetDialogButtons();
    }

    private void handleExport() {
        String path;
        FileDialog dialog = new FileDialog(this.getViewSite().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.log"});
        if (this.directory != null) {
            dialog.setFilterPath(this.directory);
        }
        if ((path = dialog.open()) != null) {
            if (!path.endsWith(".log")) {
                path = String.valueOf(path) + ".log";
            }
            File outputFile = new Path(path).toFile();
            this.directory = outputFile.getParent();
            if (outputFile.exists()) {
                String message = "LogView.confirmOverwrite.message";
                if (!MessageDialog.openQuestion((Shell)this.getViewSite().getShell(), (String)this.exportAction.getText(), (String)message)) {
                    return;
                }
            }
            this.copy(this.inputFile, outputFile);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copy(File inputFile, File outputFile) {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), "UTF-8"));
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
                while (reader.ready()) {
                    writer.write(reader.readLine());
                    writer.write(System.getProperty("line.separator"));
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (reader != null) {
            reader.close();
        }
        if (writer == null) return;
        writer.close();
    }

    private void handleFilter() {
        FilterDialog dialog = new FilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.memento);
        dialog.create();
        dialog.getShell().setText(XDebugUIPlugin.getString("LogView.FilterDialog.title"));
        if (dialog.open() == 0) {
            this.reloadLog();
        }
    }

    private void doDeleteLog() {
        String title = XDebugUIPlugin.getString("LogView.confirmDelete.title");
        String message = XDebugUIPlugin.getString("LogView.confirmDelete.message");
        if (!MessageDialog.openConfirm((Shell)this.tableTreeViewer.getControl().getShell(), (String)title, (String)message)) {
            return;
        }
        if (this.inputFile.delete()) {
            this.logs.clear();
            this.asyncRefresh(false);
            this.resetDialogButtons();
        }
    }

    public void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.copyAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.clearAction);
        manager.add((IAction)this.deleteLogAction);
        manager.add((IAction)this.viewLogAction);
        manager.add((IAction)this.readLogAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.exportAction);
        manager.add((IAction)this.importAction);
        manager.add((IContributionItem)new Separator());
        ((EventDetailsDialogAction)this.propertiesAction).setComparator(this.comparator);
        manager.add((IAction)this.propertiesAction);
    }

    public LogEntry[] getLogs() {
        return this.logs.toArray(new LogEntry[this.logs.size()]);
    }

    protected void handleClear() {
        BusyIndicator.showWhile((Display)this.tableTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                LogView.this.logs.clear();
                LogView.this.asyncRefresh(false);
                LogView.this.resetDialogButtons();
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void reloadLog() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(XDebugUIPlugin.getString("LogView.operation.reloading"), -1);
                LogView.this.readLogFile();
            }
        };
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getViewSite().getShell());
        try {
            try {
                pmd.run(true, true, op);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.readLogAction.setText(XDebugUIPlugin.getString("LogView.readLog.restore"));
            this.readLogAction.setToolTipText(XDebugUIPlugin.getString("LogView.readLog.restore"));
            this.asyncRefresh(false);
            this.resetDialogButtons();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.readLogAction.setText(XDebugUIPlugin.getString("LogView.readLog.restore"));
        this.readLogAction.setToolTipText(XDebugUIPlugin.getString("LogView.readLog.restore"));
        this.asyncRefresh(false);
        this.resetDialogButtons();
    }

    private void readLogFile() {
        this.logs.clear();
        if (!this.inputFile.exists()) {
            return;
        }
        if (this.inputFile.length() > 0x100000L) {
            LogReader.parseLargeFile(this.inputFile, this.logs, this.memento);
        } else {
            LogReader.parseLogFile(this.inputFile, this.logs, this.memento);
        }
    }

    public void logging(IStatus status, String plugin) {
        if (!this.inputFile.equals(Platform.getLogFileLocation().toFile())) {
            return;
        }
        if (this.firstEvent) {
            this.readLogFile();
            this.asyncRefresh();
            this.firstEvent = false;
        } else {
            this.pushStatus(status);
        }
    }

    private void pushStatus(IStatus status) {
        LogEntry entry = new LogEntry(status);
        LogReader.addEntry(entry, this.logs, this.memento, true);
        this.asyncRefresh();
    }

    private void asyncRefresh() {
        this.asyncRefresh(true);
    }

    private void asyncRefresh(final boolean activate) {
        final Control control = this.tableTreeViewer.getControl();
        if (control.isDisposed()) {
            return;
        }
        Display display = control.getDisplay();
        final LogView view = this;
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!control.isDisposed()) {
                        IWorkbenchPage page;
                        LogView.this.tableTreeViewer.refresh();
                        LogView.this.deleteLogAction.setEnabled(LogView.this.inputFile.exists() && LogView.this.inputFile.equals(Platform.getLogFileLocation().toFile()));
                        LogView.this.viewLogAction.setEnabled(LogView.this.inputFile.exists());
                        if (activate && LogView.this.activateViewAction.isChecked() && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
                            page.bringToTop((IWorkbenchPart)view);
                        }
                    }
                    LogView.this.applyFonts();
                }
            });
        }
    }

    public void setFocus() {
        if (this.tableTreeViewer != null && !this.tableTreeViewer.getTree().isDisposed()) {
            this.tableTreeViewer.getTree().setFocus();
        }
    }

    private void handleSelectionChanged(ISelection selection) {
        this.updateStatus(selection);
        this.copyAction.setEnabled(!selection.isEmpty());
        this.propertiesAction.setEnabled(!selection.isEmpty());
    }

    private void updateStatus(ISelection selection) {
        IStatusLineManager status = this.getViewSite().getActionBars().getStatusLineManager();
        if (selection.isEmpty()) {
            status.setMessage(null);
        } else {
            LogEntry entry = (LogEntry)((Object)((IStructuredSelection)selection).getFirstElement());
            status.setMessage(((LogViewLabelProvider)this.tableTreeViewer.getLabelProvider()).getColumnText((Object)entry, 2));
        }
    }

    private void copyToClipboard(ISelection selection) {
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        if (selection.isEmpty()) {
            return;
        }
        LogEntry entry = (LogEntry)((Object)((IStructuredSelection)selection).getFirstElement());
        entry.write(pwriter);
        pwriter.flush();
        String textVersion = writer.toString();
        try {
            pwriter.close();
            writer.close();
        }
        catch (IOException iOException) {}
        if (textVersion.trim().length() > 0) {
            this.clipboard.setContents(new Object[]{textVersion}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento == null ? XMLMemento.createWriteRoot((String)"LOGVIEW") : memento;
        this.initializeMemento();
    }

    private void initializeMemento() {
        Integer width;
        if (this.memento.getString(P_USE_LIMIT) == null) {
            this.memento.putString(P_USE_LIMIT, "true");
        }
        if (this.memento.getInteger(P_LOG_LIMIT) == null) {
            this.memento.putInteger(P_LOG_LIMIT, 50);
        }
        if (this.memento.getString(P_LOG_INFO) == null) {
            this.memento.putString(P_LOG_INFO, "true");
        }
        if (this.memento.getString(P_LOG_WARNING) == null) {
            this.memento.putString(P_LOG_WARNING, "true");
        }
        if (this.memento.getString(P_LOG_ERROR) == null) {
            this.memento.putString(P_LOG_ERROR, "true");
        }
        if (this.memento.getString(P_SHOW_ALL_SESSIONS) == null) {
            this.memento.putString(P_SHOW_ALL_SESSIONS, "true");
        }
        if ((width = this.memento.getInteger(P_COLUMN_1)) == null || width == 0) {
            this.memento.putInteger(P_COLUMN_1, 20);
        }
        if ((width = this.memento.getInteger(P_COLUMN_2)) == null || width == 0) {
            this.memento.putInteger(P_COLUMN_2, 300);
        }
        if ((width = this.memento.getInteger(P_COLUMN_3)) == null || width == 0) {
            this.memento.putInteger(P_COLUMN_3, 150);
        }
        if ((width = this.memento.getInteger(P_COLUMN_4)) == null || width == 0) {
            this.memento.putInteger(P_COLUMN_4, 150);
        }
        if (this.memento.getString(P_ACTIVATE) == null) {
            this.memento.putString(P_ACTIVATE, "true");
        }
    }

    public void saveState(IMemento memento) {
        if (this.memento == null || memento == null) {
            return;
        }
        this.memento.putInteger(P_COLUMN_1, this.column1.getWidth());
        this.memento.putInteger(P_COLUMN_2, this.column2.getWidth());
        this.memento.putInteger(P_COLUMN_3, this.column3.getWidth());
        this.memento.putInteger(P_COLUMN_4, this.column4.getWidth());
        this.memento.putString(P_ACTIVATE, this.activateViewAction.isChecked() ? "true" : "false");
        memento.putMemento(this.memento);
    }

    private void addMouseListeners() {
        Listener tableListener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 5: {
                        LogView.this.onMouseMove(e);
                        break;
                    }
                    case 32: {
                        LogView.this.onMouseHover(e);
                        break;
                    }
                    case 3: {
                        LogView.this.onMouseDown(e);
                    }
                }
            }
        };
        int[] tableEvents = new int[]{3, 5, 32};
        int i = 0;
        while (i < tableEvents.length) {
            this.tableTreeViewer.getTree().addListener(tableEvents[i], tableListener);
            ++i;
        }
    }

    private void makeHoverShell() {
        int border;
        Control control = this.tableTreeViewer.getControl();
        this.textShell = new Shell(control.getShell(), 540672);
        Display display = this.textShell.getDisplay();
        this.textShell.setBackground(display.getSystemColor(29));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = border = (control.getShell().getStyle() & 8) == 0 ? 0 : 1;
        layout.marginWidth = border;
        this.textShell.setLayout((Layout)layout);
        this.textShell.setLayoutData((Object)new GridData(768));
        Composite shellComposite = new Composite((Composite)this.textShell, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        shellComposite.setLayout((Layout)layout);
        shellComposite.setLayoutData((Object)new GridData(1810));
        this.textLabel = new Text(shellComposite, 66);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        gd.grabExcessHorizontalSpace = true;
        this.textLabel.setLayoutData((Object)gd);
        Color c = control.getDisplay().getSystemColor(29);
        this.textLabel.setBackground(c);
        c = control.getDisplay().getSystemColor(28);
        this.textLabel.setForeground(c);
        this.textLabel.setEditable(false);
        this.textShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LogView.this.onTextShellDispose(e);
            }
        });
    }

    void onTextShellDispose(DisposeEvent e) {
        this.canOpenTextShell = true;
        this.setFocus();
    }

    void onMouseDown(Event e) {
        if (this.textShell != null && !this.textShell.isDisposed() && !this.textShell.isFocusControl()) {
            this.textShell.close();
            this.canOpenTextShell = true;
        }
    }

    void onMouseHover(Event e) {
        if (!this.canOpenTextShell) {
            return;
        }
        this.canOpenTextShell = false;
        Point point = new Point(e.x, e.y);
        Tree table = this.tableTreeViewer.getTree();
        TreeItem item = table.getItem(point);
        if (item == null) {
            return;
        }
        String message = ((LogEntry)((Object)item.getData())).getStack();
        if (message == null) {
            return;
        }
        this.makeHoverShell();
        this.textLabel.setText(message);
        int x = point.x + 5;
        int y = point.y - table.getItemHeight() * 2 - 20;
        this.textShell.setLocation(table.toDisplay(x, y));
        this.textShell.setSize(this.tableTreeViewer.getTree().getSize().x - x, 125);
        this.textShell.open();
        this.setFocus();
    }

    void onMouseMove(Event e) {
        if (this.textShell != null && !this.textShell.isDisposed()) {
            this.textShell.close();
            this.canOpenTextShell = this.textShell.isDisposed() && e.x > this.column0.getWidth() && e.x < this.column0.getWidth() + this.column1.getWidth();
        } else {
            this.canOpenTextShell = e.x > this.column0.getWidth() && e.x < this.column0.getWidth() + this.column1.getWidth();
        }
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    private void setComparator(byte sortType) {
        this.comparator = sortType == DATE ? new Comparator(){

            public int compare(Object e1, Object e2) {
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.SS");
                    Date date1 = formatter.parse(((LogEntry)((Object)e1)).getDate());
                    Date date2 = formatter.parse(((LogEntry)((Object)e2)).getDate());
                    if (LogView.this.DATE_ORDER == ASCENDING) {
                        return date1.before(date2) ? -1 : 1;
                    }
                    return date1.after(date2) ? -1 : 1;
                }
                catch (ParseException parseException) {
                    return 0;
                }
            }
        } : (sortType == PLUGIN ? new Comparator(){

            public int compare(Object e1, Object e2) {
                LogEntry entry1 = (LogEntry)((Object)e1);
                LogEntry entry2 = (LogEntry)((Object)e2);
                return LogView.this.collator.compare(entry1.getPluginId(), entry2.getPluginId()) * LogView.this.PLUGIN_ORDER;
            }
        } : new Comparator(){

            public int compare(Object e1, Object e2) {
                LogEntry entry1 = (LogEntry)((Object)e1);
                LogEntry entry2 = (LogEntry)((Object)e2);
                return LogView.this.collator.compare(entry1.getMessage(), entry2.getMessage()) * LogView.this.MESSAGE_ORDER;
            }
        });
    }

    private ViewerSorter getViewerSorter(byte sortType) {
        if (sortType == PLUGIN) {
            return new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    LogEntry entry1 = (LogEntry)((Object)e1);
                    LogEntry entry2 = (LogEntry)((Object)e2);
                    return super.compare(viewer, (Object)entry1.getPluginId(), (Object)entry2.getPluginId()) * LogView.this.PLUGIN_ORDER;
                }
            };
        }
        if (sortType == MESSAGE) {
            return new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    LogEntry entry1 = (LogEntry)((Object)e1);
                    LogEntry entry2 = (LogEntry)((Object)e2);
                    return super.compare(viewer, (Object)entry1.getMessage(), (Object)entry2.getMessage()) * LogView.this.MESSAGE_ORDER;
                }
            };
        }
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.SS");
                    Date date1 = formatter.parse(((LogEntry)((Object)e1)).getDate());
                    Date date2 = formatter.parse(((LogEntry)((Object)e2)).getDate());
                    if (LogView.this.DATE_ORDER == ASCENDING) {
                        return date1.before(date2) ? -1 : 1;
                    }
                    return date1.after(date2) ? -1 : 1;
                }
                catch (ParseException parseException) {
                    return 0;
                }
            }
        };
    }

    private void resetDialogButtons() {
        ((EventDetailsDialogAction)this.propertiesAction).resetDialogButtons();
    }
}

