/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.ui.views.logview;

import net.sourceforge.phpeclipse.xdebug.ui.XDebugUIPluginImages;
import net.sourceforge.phpeclipse.xdebug.ui.views.logview.LogEntry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class LogViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Image infoImage;
    private Image errorImage = XDebugUIPluginImages.get("IMG_ERROR_ST_OBJ");
    private Image warningImage = XDebugUIPluginImages.get("IMG_WARNING_ST_OBJ");
    private Image errorWithStackImage;

    public LogViewLabelProvider() {
        this.infoImage = XDebugUIPluginImages.get("IMG_INFO_ST_OBJ");
        this.errorWithStackImage = XDebugUIPluginImages.get("IMG_ERROR_STACK_OBJ");
    }

    public void dispose() {
        this.errorImage.dispose();
        this.infoImage.dispose();
        this.warningImage.dispose();
        this.errorWithStackImage.dispose();
        super.dispose();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        LogEntry entry = (LogEntry)((Object)element);
        if (columnIndex == 1) {
            switch (entry.getSeverity()) {
                case 1: {
                    return this.infoImage;
                }
                case 2: {
                    return this.warningImage;
                }
                case 4: {
                    return entry.getStack() == null ? this.errorImage : this.errorWithStackImage;
                }
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        LogEntry entry = (LogEntry)((Object)element);
        switch (columnIndex) {
            case 2: {
                return entry.getMessage();
            }
            case 3: {
                return entry.getPluginId();
            }
            case 4: {
                return entry.getDate();
            }
        }
        return "";
    }
}

