/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.views.outline;

import java.util.List;
import net.sourceforge.phpeclipse.core.model.ISourceModel;
import net.sourceforge.phpeclipse.core.model.ISourceReference;
import net.sourceforge.phpeclipse.ui.editor.StructuredTextEditor;
import net.sourceforge.phpeclipse.ui.internal.WebUIMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class ModelBasedOutlinePage
extends ContentOutlinePage
implements IUpdate {
    private StructuredTextEditor editor;
    private ISourceModel model;
    private IPreferenceStore preferenceStore;
    private String linkWithEditorPreferenceKey;

    public ModelBasedOutlinePage(StructuredTextEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new ContentProvider());
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.outlinePageClosed();
            this.editor = null;
        }
        super.dispose();
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        if (toolBarManager != null) {
            toolBarManager.add((IAction)new ToggleLinkingAction());
        }
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
    }

    public void update() {
        Control control;
        TreeViewer viewer;
        ISourceModel model = this.editor.getSourceModel();
        if (model != null && (viewer = this.getTreeViewer()) != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput((Object)model);
            viewer.expandAll();
            control.setRedraw(true);
        }
    }

    public void select(ISourceReference element) {
        IStructuredSelection structuredSelection;
        List elements;
        ISelection selection;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection && !(elements = (structuredSelection = (IStructuredSelection)selection).toList()).contains(element)) {
            selection = element == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)element);
            viewer.setSelection(selection, true);
        }
    }

    protected final StructuredTextEditor getEditor() {
        return this.editor;
    }

    protected final void setPreferenceStore(IPreferenceStore store) {
        this.preferenceStore = store;
    }

    protected final void setLinkWithEditorPreferenceKey(String key) {
        this.linkWithEditorPreferenceKey = key;
    }

    static /* synthetic */ StructuredTextEditor access$5(ModelBasedOutlinePage modelBasedOutlinePage) {
        return modelBasedOutlinePage.editor;
    }

    public class ContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ISourceReference) {
                return ModelBasedOutlinePage.this.model.getChildren((ISourceReference)parentElement);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ISourceReference) {
                return ModelBasedOutlinePage.this.model.getParent((ISourceReference)element);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return ModelBasedOutlinePage.this.model.getElements();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != newInput && newInput instanceof ISourceModel) {
                ModelBasedOutlinePage.this.model = (ISourceModel)newInput;
            }
        }
    }

    private class ToggleLinkingAction
    extends ResourceAction {
        public ToggleLinkingAction() {
            super(WebUIMessages.getResourceBundle(), "OutlinePage.linkWithEditor.");
            if (ModelBasedOutlinePage.this.preferenceStore != null && ModelBasedOutlinePage.this.linkWithEditorPreferenceKey != null) {
                boolean checked = ModelBasedOutlinePage.this.preferenceStore.getBoolean(ModelBasedOutlinePage.this.linkWithEditorPreferenceKey);
                this.valueChanged(checked, false);
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (ModelBasedOutlinePage.this.preferenceStore != null && ModelBasedOutlinePage.this.linkWithEditorPreferenceKey != null) {
                this.valueChanged(this.isChecked(), true);
            }
        }

        private void valueChanged(boolean checked, boolean store) {
            this.setChecked(checked);
            BusyIndicator.showWhile((Display)ModelBasedOutlinePage.this.getTreeViewer().getControl().getDisplay(), (Runnable)new Runnable(this){
                final /* synthetic */ ToggleLinkingAction this$1;
                {
                    this.this$1 = toggleLinkingAction;
                }

                public void run() {
                    ModelBasedOutlinePage.access$5(ToggleLinkingAction.access$0(this.this$1)).synchronizeOutlinePage();
                }
            });
            if (store) {
                ModelBasedOutlinePage.this.preferenceStore.setValue(ModelBasedOutlinePage.this.linkWithEditorPreferenceKey, checked);
            }
        }

        static /* synthetic */ ModelBasedOutlinePage access$0(ToggleLinkingAction toggleLinkingAction) {
            return toggleLinkingAction.ModelBasedOutlinePage.this;
        }
    }
}

