/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.externaltools.model;

import java.util.ArrayList;
import net.sourceforge.phpdt.externaltools.internal.model.ExternalToolsModelMessages;
import net.sourceforge.phpdt.externaltools.internal.registry.ArgumentVariable;
import net.sourceforge.phpdt.externaltools.internal.registry.ArgumentVariableRegistry;
import net.sourceforge.phpdt.externaltools.internal.registry.PathLocationVariable;
import net.sourceforge.phpdt.externaltools.internal.registry.PathLocationVariableRegistry;
import net.sourceforge.phpdt.externaltools.variable.ExpandVariableContext;
import net.sourceforge.phpeclipse.externaltools.ExternalToolsPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.MultiStatus;

public final class ToolUtil {
    private static final char ARG_DELIMITER = ' ';
    private static final char ARG_DBL_QUOTE = '\"';
    private static final char VAR_TAG_START_CHAR1 = '$';
    private static final char VAR_TAG_START_CHAR2 = '{';
    private static final char VAR_TAG_END_CHAR1 = '}';
    private static final String VAR_TAG_START = "${";
    private static final String VAR_TAG_END = "}";
    private static final String VAR_TAG_SEP = ":";

    private ToolUtil() {
    }

    public static String buildVariableTag(String varName, String varArgument) {
        StringBuffer buf = new StringBuffer();
        ToolUtil.buildVariableTag(varName, varArgument, buf);
        return buf.toString();
    }

    public static void buildVariableTag(String varName, String varArgument, StringBuffer buffer) {
        buffer.append(VAR_TAG_START);
        buffer.append(varName);
        if (varArgument != null && varArgument.length() > 0) {
            buffer.append(VAR_TAG_SEP);
            buffer.append(varArgument);
        }
        buffer.append(VAR_TAG_END);
    }

    public static String expandArgument(String argument, ExpandVariableContext context, MultiStatus status) {
        StringBuffer buffer = new StringBuffer();
        int start = 0;
        while (true) {
            VariableDefinition varDef = ToolUtil.extractVariableTag(argument, start);
            if (varDef.start == -1) {
                if (start == 0) {
                    buffer.append(argument);
                    break;
                }
                buffer.append(argument.substring(start));
                break;
            }
            if (varDef.end == -1 || varDef.name == null || varDef.name.length() == 0) {
                String msg = ExternalToolsModelMessages.getString("ToolUtil.argumentVarFormatWrong");
                status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
                return null;
            }
            if (varDef.start > start) {
                buffer.append(argument.substring(start, varDef.start));
            }
            start = varDef.end;
            ArgumentVariableRegistry registry = ExternalToolsPlugin.getDefault().getArgumentVariableRegistry();
            ArgumentVariable variable = registry.getArgumentVariable(varDef.name);
            if (variable == null) {
                String msg = ExternalToolsModelMessages.format("ToolUtil.argumentVarMissing", new Object[]{varDef.name});
                status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
                return null;
            }
            String text = variable.getExpander().getText(varDef.name, varDef.argument, context);
            if (text == null) {
                String msg = ExternalToolsModelMessages.format("ToolUtil.argumentVarExpandFailed", new Object[]{varDef.name});
                status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
                return null;
            }
            buffer.append(text);
        }
        return buffer.toString();
    }

    public static String[] expandArguments(String arguments, ExpandVariableContext context, MultiStatus status) {
        if (arguments == null || arguments.length() == 0) {
            return new String[0];
        }
        String[] argList = ToolUtil.parseArgumentsIntoList(arguments);
        int i = 0;
        while (i < argList.length) {
            argList[i] = ToolUtil.expandArgument(argList[i], context, status);
            ++i;
        }
        return argList;
    }

    public static String expandDirectoryLocation(String dirLocation, ExpandVariableContext context, MultiStatus status) {
        if (dirLocation == null || dirLocation.length() == 0) {
            return "";
        }
        VariableDefinition varDef = ToolUtil.extractVariableTag(dirLocation, 0);
        if (varDef.start < 0) {
            return dirLocation;
        }
        if (varDef.start != 0 || varDef.end < dirLocation.length() && varDef.end != -1) {
            String msg = ExternalToolsModelMessages.getString("ToolUtil.dirLocVarBetweenText");
            status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
            return null;
        }
        if (varDef.name == null || varDef.name.length() == 0 || varDef.end == -1) {
            String msg = ExternalToolsModelMessages.getString("ToolUtil.dirLocVarFormatWrong");
            status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
            return null;
        }
        PathLocationVariableRegistry registry = ExternalToolsPlugin.getDefault().getDirectoryLocationVariableRegistry();
        PathLocationVariable variable = registry.getPathLocationVariable(varDef.name);
        if (variable == null) {
            String msg = ExternalToolsModelMessages.format("ToolUtil.dirLocVarMissing", new Object[]{varDef.name});
            status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
            return null;
        }
        IPath path = variable.getExpander().getPath(varDef.name, varDef.argument, context);
        if (path == null) {
            String msg = ExternalToolsModelMessages.format("ToolUtil.dirLocVarExpandFailed", new Object[]{varDef.name});
            status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
            return null;
        }
        return path.toOSString();
    }

    public static String expandFileLocation(String fileLocation, ExpandVariableContext context, MultiStatus status) {
        if (fileLocation == null || fileLocation.length() == 0) {
            return "";
        }
        VariableDefinition varDef = ToolUtil.extractVariableTag(fileLocation, 0);
        if (varDef.start < 0) {
            return fileLocation;
        }
        if (varDef.start != 0 || varDef.end < fileLocation.length() && varDef.end != -1) {
            String msg = ExternalToolsModelMessages.getString("ToolUtil.fileLocVarBetweenText");
            status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
            return null;
        }
        if (varDef.name == null || varDef.name.length() == 0 || varDef.end == -1) {
            String msg = ExternalToolsModelMessages.getString("ToolUtil.fileLocVarFormatWrong");
            status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
            return null;
        }
        PathLocationVariableRegistry registry = ExternalToolsPlugin.getDefault().getFileLocationVariableRegistry();
        PathLocationVariable variable = registry.getPathLocationVariable(varDef.name);
        if (variable == null) {
            String msg = ExternalToolsModelMessages.format("ToolUtil.fileLocVarMissing", new Object[]{varDef.name});
            status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
            return null;
        }
        IPath path = variable.getExpander().getPath(varDef.name, varDef.argument, context);
        if (path == null) {
            String msg = ExternalToolsModelMessages.format("The variable {0} with argument {1} could not be expanded to a valid path.", new Object[]{varDef.name, varDef.argument});
            status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
            return null;
        }
        return path.toString();
    }

    public static VariableDefinition extractVariableTag(String text, int start) {
        VariableDefinition varDef = new VariableDefinition();
        varDef.start = text.indexOf(VAR_TAG_START, start);
        if (varDef.start < 0) {
            return varDef;
        }
        start = varDef.start + VAR_TAG_START.length();
        int end = text.indexOf(VAR_TAG_END, start);
        if (end < 0) {
            return varDef;
        }
        varDef.end = end + VAR_TAG_END.length();
        if (end == start) {
            return varDef;
        }
        int mid = text.indexOf(VAR_TAG_SEP, start);
        if (mid < 0 || mid > end) {
            varDef.name = text.substring(start, end);
        } else {
            if (mid > start) {
                varDef.name = text.substring(start, mid);
            }
            if ((mid += VAR_TAG_SEP.length()) < end) {
                varDef.argument = text.substring(mid, end);
            }
        }
        return varDef;
    }

    public static String[] parseArgumentsIntoList(String arguments) {
        if (arguments == null || arguments.length() == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>(10);
        boolean inQuotes = false;
        boolean inVar = false;
        int start = 0;
        int end = arguments.length();
        StringBuffer buffer = new StringBuffer(end);
        block6: while (start < end) {
            char ch = arguments.charAt(start);
            ++start;
            switch (ch) {
                case ' ': {
                    if (inQuotes || inVar) {
                        buffer.append(ch);
                        break;
                    }
                    if (buffer.length() <= 0) continue block6;
                    list.add(buffer.toString());
                    buffer.setLength(0);
                    break;
                }
                case '\"': {
                    if (inVar) {
                        buffer.append(ch);
                        break;
                    }
                    if (start < end) {
                        if (arguments.charAt(start) == '\"') {
                            buffer.append(ch);
                            ++start;
                            break;
                        }
                        inQuotes = !inQuotes;
                        break;
                    }
                    inQuotes = false;
                    break;
                }
                case '$': {
                    buffer.append(ch);
                    if (inVar || start >= end || arguments.charAt(start) != '{') continue block6;
                    buffer.append('{');
                    inVar = true;
                    ++start;
                    break;
                }
                case '}': {
                    buffer.append(ch);
                    inVar = false;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
        if (buffer.length() > 0) {
            list.add(buffer.toString());
        }
        String[] results = new String[list.size()];
        list.toArray(results);
        return results;
    }

    public static final class VariableDefinition {
        public int start = -1;
        public int end = -1;
        public String name = null;
        public String argument = null;

        private VariableDefinition() {
        }

        private VariableDefinition(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

