/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Block;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.codegen.Label;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.flow.LoopingFlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.UnconditionalFlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class DoStatement
extends Statement {
    public Expression condition;
    public Statement action;
    private Label breakLabel;
    private Label continueLabel;
    int mergedInitStateIndex = -1;

    public DoStatement(Expression condition, Statement action, int s, int e) {
        this.sourceStart = s;
        this.sourceEnd = e;
        this.condition = condition;
        this.action = action;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        UnconditionalFlowInfo mergedInfo;
        this.breakLabel = new Label();
        this.continueLabel = new Label();
        LoopingFlowContext loopingContext = new LoopingFlowContext(flowContext, this, this.breakLabel, this.continueLabel, currentScope);
        Constant cst = this.condition.constant;
        boolean isConditionTrue = cst != NotAConstant && cst.booleanValue();
        cst = this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst != NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != NotAConstant && !cst.booleanValue();
        int previousMode = flowInfo.reachMode();
        if (!(this.action == null || this.action.isEmptyBlock() || (flowInfo = this.action.analyseCode(currentScope, loopingContext, flowInfo)).isReachable() || loopingContext.initsOnContinue.isReachable())) {
            this.continueLabel = null;
        }
        flowInfo.setReachMode(previousMode);
        flowInfo = this.condition.analyseCode(currentScope, loopingContext, this.action == null ? flowInfo : flowInfo.mergedWith(loopingContext.initsOnContinue));
        if (!isConditionOptimizedFalse && this.continueLabel != null) {
            loopingContext.complainOnFinalAssignmentsInLoop(currentScope, flowInfo);
        }
        if (isConditionTrue) {
            mergedInfo = loopingContext.initsOnBreak;
            if (!((FlowInfo)mergedInfo).isReachable()) {
                ((FlowInfo)mergedInfo).addPotentialInitializationsFrom(flowInfo.initsWhenFalse());
            }
        } else {
            mergedInfo = flowInfo.initsWhenFalse().unconditionalInits().mergedWith(loopingContext.initsOnBreak);
            if (isConditionOptimizedTrue && !loopingContext.initsOnBreak.isReachable()) {
                ((FlowInfo)mergedInfo).setReachMode(1);
            }
        }
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public void resetStateForCodeGeneration() {
        if (this.breakLabel != null) {
            this.breakLabel.resetStateForCodeGeneration();
        }
        if (this.continueLabel != null) {
            this.continueLabel.resetStateForCodeGeneration();
        }
    }

    public void resolve(BlockScope scope) {
        TypeBinding type = this.condition.resolveTypeExpecting(scope, BooleanBinding);
        this.condition.implicitWidening(type, type);
        if (this.action != null) {
            this.action.resolve(scope);
        }
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        DoStatement.printIndent(indent, output).append("do");
        if (this.action == null) {
            output.append(" ;\n");
        } else {
            output.append('\n');
            this.action.printStatement(indent + 1, output).append('\n');
        }
        output.append("while (");
        return this.condition.printExpression(0, output).append(");");
    }

    public String toString(int tab) {
        String s;
        String inFront = s = DoStatement.tabString(tab);
        s = String.valueOf(s) + "do";
        s = this.action == null ? String.valueOf(s) + " {}\n" : (this.action instanceof Block ? String.valueOf(s) + "\n" + this.action.toString(tab + 1) + "\n" : String.valueOf(s) + " {\n" + this.action.toString(tab + 1) + ";}\n");
        s = String.valueOf(s) + inFront + "while (" + this.condition.toStringExpression() + ")";
        return s;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.action != null) {
                this.action.traverse(visitor, scope);
            }
            this.condition.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

