/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Assignment;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.FieldDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.NameReference;
import net.sourceforge.phpdt.internal.compiler.ast.QualifiedNameReference;
import net.sourceforge.phpdt.internal.compiler.ast.QualifiedSuperReference;
import net.sourceforge.phpdt.internal.compiler.ast.QualifiedThisReference;
import net.sourceforge.phpdt.internal.compiler.ast.Reference;
import net.sourceforge.phpdt.internal.compiler.ast.TypeDeclaration;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.FieldBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.InvocationSite;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.ReferenceBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.Scope;
import net.sourceforge.phpdt.internal.compiler.lookup.SourceTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class FieldReference
extends Reference
implements InvocationSite {
    public Expression receiver;
    public char[] token;
    public FieldBinding binding;
    public FieldBinding codegenBinding;
    public long nameSourcePosition;
    MethodBinding syntheticReadAccessor;
    MethodBinding syntheticWriteAccessor;
    public TypeBinding receiverType;

    public FieldReference(char[] source, long pos) {
        this.token = source;
        this.nameSourcePosition = pos;
        this.sourceStart = (int)pos;
        this.sourceEnd = this.sourceStart + source.length;
        this.bits |= 1;
    }

    public FlowInfo analyseAssignment(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean isCompound) {
        if (isCompound) {
            if (this.binding.isBlankFinal() && this.receiver.isThis() && currentScope.allowBlankFinalFieldAssignment(this.binding) && !flowInfo.isDefinitelyAssigned(this.binding)) {
                currentScope.problemReporter().uninitializedBlankFinalField(this.binding, this);
            }
            this.manageSyntheticReadAccessIfNecessary(currentScope);
        }
        flowInfo = this.receiver.analyseCode(currentScope, flowContext, flowInfo, !this.binding.isStatic()).unconditionalInits();
        if (assignment.expression != null) {
            flowInfo = assignment.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        }
        this.manageSyntheticWriteAccessIfNecessary(currentScope);
        if (this.binding.isFinal()) {
            if (this.binding.isBlankFinal() && !isCompound && this.receiver.isThis() && !(this.receiver instanceof QualifiedThisReference) && (this.receiver.bits & 0x1FE00000) == 0 && currentScope.allowBlankFinalFieldAssignment(this.binding)) {
                if (flowInfo.isPotentiallyAssigned(this.binding)) {
                    currentScope.problemReporter().duplicateInitializationOfBlankFinalField(this.binding, this);
                } else {
                    flowContext.recordSettingFinal(this.binding, this);
                }
                flowInfo.markAsDefinitelyAssigned(this.binding);
            } else {
                currentScope.problemReporter().cannotAssignToFinalField(this.binding, this);
            }
        }
        return flowInfo;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.analyseCode(currentScope, flowContext, flowInfo, true);
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, boolean valueRequired) {
        this.receiver.analyseCode(currentScope, flowContext, flowInfo, !this.binding.isStatic());
        if (valueRequired) {
            this.manageSyntheticReadAccessIfNecessary(currentScope);
        }
        return flowInfo;
    }

    public FieldBinding fieldBinding() {
        return this.binding;
    }

    public static final Constant getConstantFor(FieldBinding binding, Reference reference, boolean isImplicit, Scope referenceScope) {
        if (binding.declaringClass == null) {
            return NotAConstant;
        }
        if (!binding.isFinal()) {
            binding.constant = NotAConstant;
            return binding.constant;
        }
        if (binding.constant != null) {
            if (isImplicit || reference instanceof QualifiedNameReference && binding == ((QualifiedNameReference)reference).binding) {
                return binding.constant;
            }
            return NotAConstant;
        }
        SourceTypeBinding typeBinding = (SourceTypeBinding)binding.declaringClass;
        TypeDeclaration typeDecl = typeBinding.scope.referenceContext;
        FieldDeclaration fieldDecl = typeDecl.declarationOf(binding);
        fieldDecl.resolve(binding.isStatic() ? typeDecl.staticInitializerScope : typeDecl.initializerScope);
        if (isImplicit || reference instanceof QualifiedNameReference && binding == ((QualifiedNameReference)reference).binding) {
            return binding.constant;
        }
        return NotAConstant;
    }

    public boolean isSuperAccess() {
        return this.receiver.isSuper();
    }

    public boolean isTypeAccess() {
        return this.receiver != null && this.receiver.isTypeReference();
    }

    public void manageSyntheticReadAccessIfNecessary(BlockScope currentScope) {
        if (this.binding.isPrivate()) {
            if (currentScope.enclosingSourceType() != this.binding.declaringClass && this.binding.constant == NotAConstant) {
                this.syntheticReadAccessor = ((SourceTypeBinding)this.binding.declaringClass).addSyntheticMethod(this.binding, true);
                currentScope.problemReporter().needToEmulateFieldReadAccess(this.binding, this);
                return;
            }
        } else {
            if (this.receiver instanceof QualifiedSuperReference) {
                SourceTypeBinding destinationType = (SourceTypeBinding)((QualifiedSuperReference)this.receiver).currentCompatibleType;
                this.syntheticReadAccessor = destinationType.addSyntheticMethod(this.binding, true);
                currentScope.problemReporter().needToEmulateFieldReadAccess(this.binding, this);
                return;
            }
            if (this.binding.isProtected() && (this.bits & 0x1FE0) != 0) {
                SourceTypeBinding enclosingSourceType = currentScope.enclosingSourceType();
                if (this.binding.declaringClass.getPackage() != enclosingSourceType.getPackage()) {
                    SourceTypeBinding currentCompatibleType = (SourceTypeBinding)enclosingSourceType.enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                    this.syntheticReadAccessor = currentCompatibleType.addSyntheticMethod(this.binding, true);
                    currentScope.problemReporter().needToEmulateFieldReadAccess(this.binding, this);
                    return;
                }
            }
        }
    }

    public void manageSyntheticWriteAccessIfNecessary(BlockScope currentScope) {
        if (this.binding.isPrivate()) {
            if (currentScope.enclosingSourceType() != this.binding.declaringClass) {
                this.syntheticWriteAccessor = ((SourceTypeBinding)this.binding.declaringClass).addSyntheticMethod(this.binding, false);
                currentScope.problemReporter().needToEmulateFieldWriteAccess(this.binding, this);
                return;
            }
        } else {
            if (this.receiver instanceof QualifiedSuperReference) {
                SourceTypeBinding destinationType = (SourceTypeBinding)((QualifiedSuperReference)this.receiver).currentCompatibleType;
                this.syntheticWriteAccessor = destinationType.addSyntheticMethod(this.binding, false);
                currentScope.problemReporter().needToEmulateFieldWriteAccess(this.binding, this);
                return;
            }
            if (this.binding.isProtected() && (this.bits & 0x1FE0) != 0) {
                SourceTypeBinding enclosingSourceType = currentScope.enclosingSourceType();
                if (this.binding.declaringClass.getPackage() != enclosingSourceType.getPackage()) {
                    SourceTypeBinding currentCompatibleType = (SourceTypeBinding)enclosingSourceType.enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                    this.syntheticWriteAccessor = currentCompatibleType.addSyntheticMethod(this.binding, false);
                    currentScope.problemReporter().needToEmulateFieldWriteAccess(this.binding, this);
                    return;
                }
            }
        }
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.receiverType = this.receiver.resolveType(scope);
        if (this.receiverType == null) {
            this.constant = NotAConstant;
            return null;
        }
        this.codegenBinding = this.binding = scope.getField(this.receiverType, this.token, this);
        if (!this.binding.isValidBinding()) {
            this.constant = NotAConstant;
            scope.problemReporter().invalidField(this, this.receiverType);
            return null;
        }
        if (this.isFieldUseDeprecated(this.binding, scope)) {
            scope.problemReporter().deprecatedField(this.binding, this);
        }
        boolean isImplicitThisRcv = this.receiver.isImplicitThis();
        this.constant = FieldReference.getConstantFor(this.binding, this, isImplicitThisRcv, scope);
        if (!isImplicitThisRcv) {
            this.constant = NotAConstant;
        }
        if (!(!this.binding.isStatic() || isImplicitThisRcv || this.receiver.isSuper() || this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0)) {
            scope.problemReporter().unnecessaryReceiverForStaticField(this, this.binding);
        }
        this.resolvedType = this.binding.type;
        return this.resolvedType;
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    public void setDepth(int depth) {
        this.bits &= 0xFFFFE01F;
        if (depth > 0) {
            this.bits |= (depth & 0xFF) << 5;
        }
    }

    public void setFieldIndex(int index) {
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        return this.receiver.printExpression(0, output).append('.').append(this.token);
    }

    public String toStringExpression() {
        return String.valueOf(this.receiver.toString()) + "." + new String(this.token);
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.receiver.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

