/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Assignment;
import net.sourceforge.phpdt.internal.compiler.ast.FieldReference;
import net.sourceforge.phpdt.internal.compiler.ast.NameReference;
import net.sourceforge.phpdt.internal.compiler.ast.OperatorIds;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.FieldBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.InvocationSite;
import net.sourceforge.phpdt.internal.compiler.lookup.LocalVariableBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodScope;
import net.sourceforge.phpdt.internal.compiler.lookup.ProblemFieldBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.ProblemReferenceBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.SourceTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.VariableBinding;

public class SingleNameReference
extends NameReference
implements OperatorIds {
    public char[] token;
    public MethodBinding[] syntheticAccessors;
    public static final int READ = 0;
    public static final int WRITE = 1;

    public SingleNameReference(char[] source, long pos) {
        this.token = source;
        this.sourceStart = (int)(pos >>> 32);
        this.sourceEnd = (int)pos;
    }

    public FlowInfo analyseAssignment(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean isCompound) {
        FieldBinding fieldBinding;
        if (isCompound) {
            switch (this.bits & 7) {
                case 1: {
                    fieldBinding = (FieldBinding)this.binding;
                    if (fieldBinding.isBlankFinal() && currentScope.allowBlankFinalFieldAssignment(fieldBinding) && !flowInfo.isDefinitelyAssigned(fieldBinding)) {
                        currentScope.problemReporter().uninitializedBlankFinalField(fieldBinding, this);
                    }
                    this.manageSyntheticReadAccessIfNecessary(currentScope);
                }
            }
        }
        if (assignment.expression != null) {
            flowInfo = assignment.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        }
        switch (this.bits & 7) {
            case 1: {
                this.manageSyntheticWriteAccessIfNecessary(currentScope);
                fieldBinding = (FieldBinding)this.binding;
                if (!fieldBinding.isFinal()) break;
                if (!isCompound && fieldBinding.isBlankFinal() && currentScope.allowBlankFinalFieldAssignment(fieldBinding)) {
                    if (flowInfo.isPotentiallyAssigned(fieldBinding)) {
                        currentScope.problemReporter().duplicateInitializationOfBlankFinalField(fieldBinding, this);
                    } else {
                        flowContext.recordSettingFinal(fieldBinding, this);
                    }
                    flowInfo.markAsDefinitelyAssigned(fieldBinding);
                    break;
                }
                currentScope.problemReporter().cannotAssignToFinalField(fieldBinding, this);
                break;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.binding;
                this.bits = !flowInfo.isDefinitelyAssigned(localBinding) ? (this.bits |= 8) : (this.bits &= 0xFFFFFFF7);
                if (localBinding.isFinal()) {
                    if ((this.bits & 0x1FE0) == 0) {
                        if (isCompound || !localBinding.isBlankFinal()) {
                            currentScope.problemReporter().cannotAssignToFinalLocal(localBinding, this);
                        } else if (flowInfo.isPotentiallyAssigned(localBinding)) {
                            currentScope.problemReporter().duplicateInitializationOfFinalLocal(localBinding, this);
                        } else {
                            flowContext.recordSettingFinal(localBinding, this);
                        }
                    } else {
                        currentScope.problemReporter().cannotAssignToFinalOuterLocal(localBinding, this);
                    }
                }
                flowInfo.markAsDefinitelyAssigned(localBinding);
            }
        }
        this.manageEnclosingInstanceAccessIfNecessary(currentScope);
        return flowInfo;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.analyseCode(currentScope, flowContext, flowInfo, true);
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, boolean valueRequired) {
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding;
                if (valueRequired) {
                    this.manageSyntheticReadAccessIfNecessary(currentScope);
                }
                if (!(fieldBinding = (FieldBinding)this.binding).isBlankFinal() || !currentScope.allowBlankFinalFieldAssignment(fieldBinding) || flowInfo.isDefinitelyAssigned(fieldBinding)) break;
                currentScope.problemReporter().uninitializedBlankFinalField(fieldBinding, this);
            }
        }
        if (valueRequired) {
            this.manageEnclosingInstanceAccessIfNecessary(currentScope);
        }
        return flowInfo;
    }

    public TypeBinding checkFieldAccess(BlockScope scope) {
        FieldBinding fieldBinding = (FieldBinding)this.binding;
        this.bits &= 0xFFFFFFF8;
        this.bits |= 1;
        if (!((FieldBinding)this.binding).isStatic() && scope.methodScope().isStatic) {
            scope.problemReporter().staticFieldAccessToNonStaticVariable(this, fieldBinding);
            this.constant = NotAConstant;
            return fieldBinding.type;
        }
        this.constant = FieldReference.getConstantFor(fieldBinding, this, true, scope);
        if (this.isFieldUseDeprecated(fieldBinding, scope)) {
            scope.problemReporter().deprecatedField(fieldBinding, this);
        }
        MethodScope ms = scope.methodScope();
        if ((this.bits & 0x2000) == 0 && ms.enclosingSourceType() == fieldBinding.declaringClass && ms.fieldDeclarationIndex != -1 && fieldBinding.id >= ms.fieldDeclarationIndex && (!fieldBinding.isStatic() || ms.isStatic)) {
            scope.problemReporter().forwardReference(this, 0, scope.enclosingSourceType());
        }
        return fieldBinding.type;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope) {
        if ((this.bits & 0x1FE0) == 0 || this.constant != NotAConstant) {
            return;
        }
        if ((this.bits & 7) == 2) {
            currentScope.emulateOuterAccess((LocalVariableBinding)this.binding);
        }
    }

    public void manageSyntheticReadAccessIfNecessary(BlockScope currentScope) {
        if (this.constant != NotAConstant) {
            return;
        }
        if ((this.bits & 1) != 0) {
            FieldBinding fieldBinding = (FieldBinding)this.binding;
            if ((this.bits & 0x1FE0) != 0 && (fieldBinding.isPrivate() || fieldBinding.isProtected() && fieldBinding.declaringClass.getPackage() != currentScope.enclosingSourceType().getPackage())) {
                if (this.syntheticAccessors == null) {
                    this.syntheticAccessors = new MethodBinding[2];
                }
                this.syntheticAccessors[0] = ((SourceTypeBinding)currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5)).addSyntheticMethod(fieldBinding, true);
                currentScope.problemReporter().needToEmulateFieldReadAccess(fieldBinding, this);
                return;
            }
        }
    }

    public void manageSyntheticWriteAccessIfNecessary(BlockScope currentScope) {
        if ((this.bits & 1) != 0) {
            FieldBinding fieldBinding = (FieldBinding)this.binding;
            if ((this.bits & 0x1FE0) != 0 && (fieldBinding.isPrivate() || fieldBinding.isProtected() && fieldBinding.declaringClass.getPackage() != currentScope.enclosingSourceType().getPackage())) {
                if (this.syntheticAccessors == null) {
                    this.syntheticAccessors = new MethodBinding[2];
                }
                this.syntheticAccessors[1] = ((SourceTypeBinding)currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5)).addSyntheticMethod(fieldBinding, false);
                currentScope.problemReporter().needToEmulateFieldWriteAccess(fieldBinding, this);
                return;
            }
        }
    }

    public TypeBinding reportError(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        if (this.binding instanceof ProblemFieldBinding) {
            scope.problemReporter().invalidField(this, (FieldBinding)this.binding);
        } else if (this.binding instanceof ProblemReferenceBinding) {
            scope.problemReporter().invalidType(this, (TypeBinding)this.binding);
        } else {
            scope.problemReporter().unresolvableReference(this, this.binding);
        }
        return null;
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.actualReceiverType = this.receiverType = scope.enclosingSourceType();
        this.codegenBinding = this.binding = scope.getBinding(this.token, this.bits & 7, (InvocationSite)this);
        if (this.binding.isValidBinding()) {
            switch (this.bits & 7) {
                case 3: 
                case 7: {
                    if (this.binding instanceof VariableBinding) {
                        VariableBinding variable = (VariableBinding)this.binding;
                        if (this.binding instanceof LocalVariableBinding) {
                            this.bits &= 0xFFFFFFF8;
                            this.bits |= 2;
                            this.constant = (this.bits & 0x2000) == 0 ? variable.constant : NotAConstant;
                            if (!variable.isFinal() && (this.bits & 0x1FE0) != 0) {
                                scope.problemReporter().cannotReferToNonFinalOuterLocal((LocalVariableBinding)variable, this);
                            }
                            this.resolvedType = variable.type;
                            return this.resolvedType;
                        }
                        this.resolvedType = this.checkFieldAccess(scope);
                        return this.resolvedType;
                    }
                    this.bits &= 0xFFFFFFF8;
                    this.bits |= 4;
                }
                case 4: {
                    this.constant = Constant.NotAConstant;
                    if (this.isTypeUseDeprecated((TypeBinding)this.binding, scope)) {
                        scope.problemReporter().deprecatedType((TypeBinding)this.binding, this);
                    }
                    this.resolvedType = (TypeBinding)this.binding;
                    return this.resolvedType;
                }
            }
        }
        this.resolvedType = this.reportError(scope);
        return this.resolvedType;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        return output.append(this.token);
    }

    public String toStringExpression() {
        return new String(this.token);
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    public String unboundReferenceErrorName() {
        return new String(this.token);
    }
}

