/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import net.sourceforge.phpdt.core.IBuffer;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaModelStatus;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.jdom.DOMFactory;
import net.sourceforge.phpdt.core.jdom.IDOMCompilationUnit;
import net.sourceforge.phpdt.core.jdom.IDOMNode;
import net.sourceforge.phpdt.internal.core.JavaElement;
import net.sourceforge.phpdt.internal.core.JavaElementDelta;
import net.sourceforge.phpdt.internal.core.JavaModelOperation;
import net.sourceforge.phpdt.internal.core.JavaModelStatus;
import net.sourceforge.phpdt.internal.core.jdom.DOMNode;
import net.sourceforge.phpdt.internal.core.util.Util;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class CreateElementInCUOperation
extends JavaModelOperation {
    protected IDOMCompilationUnit fCUDOM;
    protected static final int INSERT_LAST = 1;
    protected static final int INSERT_AFTER = 2;
    protected static final int INSERT_BEFORE = 3;
    protected int fInsertionPolicy = 1;
    protected IJavaElement fAnchorElement = null;
    protected boolean fCreationOccurred = true;
    protected DOMNode fCreatedElement;
    protected int fInsertionPosition = -1;
    protected int fReplacementLength = -1;

    public CreateElementInCUOperation(IJavaElement parentElement) {
        super(null, new IJavaElement[]{parentElement});
        this.initializeDefaultPosition();
    }

    protected void checkCanceled() {
        if (!this.isNested) {
            super.checkCanceled();
        }
    }

    public void createAfter(IJavaElement sibling) {
        this.setRelativePosition(sibling, 2);
    }

    public void createBefore(IJavaElement sibling) {
        this.setRelativePosition(sibling, 3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws JavaModelException {
        try {
            block13: {
                char[] bufferContents;
                IBuffer buffer;
                ICompilationUnit unit;
                JavaElementDelta delta;
                block16: {
                    block15: {
                        block14: {
                            this.beginTask(this.getMainTaskName(), this.getMainAmountOfWork());
                            delta = this.newJavaElementDelta();
                            unit = this.getCompilationUnit();
                            this.generateNewCompilationUnitDOM(unit);
                            if (!this.fCreationOccurred) break block13;
                            buffer = unit.getBuffer();
                            if (buffer != null) break block14;
                            break block15;
                        }
                        bufferContents = buffer.getCharacters();
                        if (bufferContents != null) break block16;
                    }
                    Object var8_4 = null;
                    this.done();
                    return;
                }
                char[] elementContents = Util.normalizeCRs(this.fCreatedElement.getCharacters(), bufferContents);
                switch (this.fReplacementLength) {
                    case -1: {
                        buffer.append(elementContents);
                        break;
                    }
                    case 0: {
                        buffer.replace(this.fInsertionPosition, 0, elementContents);
                        break;
                    }
                    default: {
                        buffer.replace(this.fInsertionPosition, this.fReplacementLength, elementContents);
                    }
                }
                unit.save(null, false);
                boolean isWorkingCopy = unit.isWorkingCopy();
                if (!isWorkingCopy) {
                    this.setAttribute("hasModifiedResource", "true");
                }
                this.worked(1);
                this.resultElements = this.generateResultHandles();
                if (!isWorkingCopy && !Util.isExcluded(unit) && unit.getParent().exists()) {
                    int i = 0;
                    while (i < this.resultElements.length) {
                        delta.added(this.resultElements[i]);
                        ++i;
                    }
                    this.addDelta(delta);
                }
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            this.done();
            throw throwable;
        }
        this.done();
    }

    protected abstract IDOMNode generateElementDOM() throws JavaModelException;

    protected void generateNewCompilationUnitDOM(ICompilationUnit cu) throws JavaModelException {
        IBuffer buffer = cu.getBuffer();
        if (buffer == null) {
            return;
        }
        char[] prevSource = buffer.getCharacters();
        if (prevSource == null) {
            return;
        }
        this.fCUDOM = new DOMFactory().createCompilationUnit(prevSource, cu.getElementName());
        IDOMNode child = this.generateElementDOM();
        if (child != null) {
            this.insertDOMNode(this.fCUDOM, child);
        }
        this.worked(1);
    }

    protected abstract IJavaElement generateResultHandle();

    protected IJavaElement[] generateResultHandles() throws JavaModelException {
        return new IJavaElement[]{this.generateResultHandle()};
    }

    protected ICompilationUnit getCompilationUnit() {
        return this.getCompilationUnitFor(this.getParentElement());
    }

    protected int getMainAmountOfWork() {
        return 2;
    }

    public abstract String getMainTaskName();

    protected ISchedulingRule getSchedulingRule() {
        IResource resource = this.getCompilationUnit().getResource();
        IWorkspace workspace = resource.getWorkspace();
        return workspace.getRuleFactory().modifyRule(resource);
    }

    public IJavaElement[] getResultElements() {
        return this.resultElements;
    }

    protected void initializeDefaultPosition() {
    }

    protected void insertDOMNode(IDOMNode parent, IDOMNode child) {
        if (this.fInsertionPolicy != 1) {
            IDOMNode sibling = ((JavaElement)this.fAnchorElement).findNode(this.fCUDOM);
            if (sibling != null && this.fInsertionPolicy == 2) {
                sibling = sibling.getNextNode();
            }
            if (sibling != null) {
                sibling.insertSibling(child);
                this.fCreatedElement = (DOMNode)child;
                this.fInsertionPosition = ((DOMNode)sibling).getStartPosition();
                this.fReplacementLength = 0;
                return;
            }
        }
        parent.addChild(child);
        this.fCreatedElement = (DOMNode)child;
        this.fInsertionPosition = ((DOMNode)parent).getInsertionPosition();
        this.fReplacementLength = parent.getParent() == null ? -1 : 0;
    }

    protected void setAlteredName(String newName) {
    }

    protected void setRelativePosition(IJavaElement sibling, int policy) throws IllegalArgumentException {
        if (sibling == null) {
            this.fAnchorElement = null;
            this.fInsertionPolicy = 1;
        } else {
            this.fAnchorElement = sibling;
            this.fInsertionPolicy = policy;
        }
    }

    public IJavaModelStatus verify() {
        if (this.getParentElement() == null) {
            return new JavaModelStatus(968);
        }
        if (this.fAnchorElement != null) {
            IJavaElement domPresentParent = this.fAnchorElement.getParent();
            if (domPresentParent.getElementType() == 12) {
                domPresentParent = domPresentParent.getParent();
            }
            if (!domPresentParent.equals(this.getParentElement())) {
                return new JavaModelStatus(993, this.fAnchorElement);
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

