/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaModelStatus;
import net.sourceforge.phpdt.core.IPackageFragment;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.core.JavaModelOperation;
import net.sourceforge.phpdt.internal.core.JavaModelStatus;

public abstract class MultiOperation
extends JavaModelOperation {
    protected String[] fRenamingsList = null;
    protected Map fParentElements;
    protected Map fInsertBeforeElements = new HashMap(1);
    protected Map fRenamings;

    protected MultiOperation(IJavaElement[] elementsToProcess, IJavaElement[] parentElements, boolean force) {
        super(elementsToProcess, parentElements, force);
        this.fParentElements = new HashMap(elementsToProcess.length);
        if (elementsToProcess.length == parentElements.length) {
            int i = 0;
            while (i < elementsToProcess.length) {
                this.fParentElements.put(elementsToProcess[i], parentElements[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < elementsToProcess.length) {
                this.fParentElements.put(elementsToProcess[i], parentElements[0]);
                ++i;
            }
        }
    }

    protected MultiOperation(IJavaElement[] elementsToProcess, boolean force) {
        super(elementsToProcess, force);
    }

    protected void error(int code, IJavaElement element) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(code, element));
    }

    protected void executeOperation() throws JavaModelException {
        this.processElements();
    }

    protected IJavaElement getDestinationParent(IJavaElement child) {
        return (IJavaElement)this.fParentElements.get(child);
    }

    protected abstract String getMainTaskName();

    protected String getNewNameFor(IJavaElement element) {
        if (this.fRenamings != null) {
            return (String)this.fRenamings.get(element);
        }
        return null;
    }

    private void initializeRenamings() {
        if (this.fRenamingsList != null && this.fRenamingsList.length == this.fElementsToProcess.length) {
            this.fRenamings = new HashMap(this.fRenamingsList.length);
            int i = 0;
            while (i < this.fRenamingsList.length) {
                if (this.fRenamingsList[i] != null) {
                    this.fRenamings.put(this.fElementsToProcess[i], this.fRenamingsList[i]);
                }
                ++i;
            }
        }
    }

    protected boolean isMove() {
        return false;
    }

    protected boolean isRename() {
        return false;
    }

    protected abstract void processElement(IJavaElement var1) throws JavaModelException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processElements() throws JavaModelException {
        this.beginTask(this.getMainTaskName(), this.fElementsToProcess.length);
        IJavaModelStatus[] errors = new IJavaModelStatus[3];
        int errorsCounter = 0;
        int i = 0;
        while (true) {
            Object var5_5;
            if (i >= this.fElementsToProcess.length) {
                this.done();
                if (errorsCounter != true) break;
                throw new JavaModelException(errors[0]);
            }
            try {
                try {
                    this.verify(this.fElementsToProcess[i]);
                    this.processElement(this.fElementsToProcess[i]);
                }
                catch (JavaModelException jme) {
                    if (errorsCounter == errors.length) {
                        IJavaModelStatus[] iJavaModelStatusArray = errors;
                        errors = new IJavaModelStatus[errorsCounter * 2];
                        System.arraycopy(iJavaModelStatusArray, 0, errors, 0, errorsCounter);
                    }
                    errors[errorsCounter++] = jme.getJavaModelStatus();
                }
            }
            catch (Throwable throwable) {
                var5_5 = null;
                this.worked(1);
                throw throwable;
            }
            {
                var5_5 = null;
            }
            this.worked(1);
            ++i;
        }
        if (errorsCounter <= 1) {
            return;
        }
        if (errorsCounter != errors.length) {
            IJavaModelStatus[] iJavaModelStatusArray = errors;
            errors = new IJavaModelStatus[errorsCounter];
            System.arraycopy(iJavaModelStatusArray, 0, errors, 0, errorsCounter);
        }
        throw new JavaModelException(JavaModelStatus.newMultiStatus(errors));
    }

    public void setInsertBefore(IJavaElement modifiedElement, IJavaElement newSibling) {
        this.fInsertBeforeElements.put(modifiedElement, newSibling);
    }

    public void setRenamings(String[] renamings) {
        this.fRenamingsList = renamings;
        this.initializeRenamings();
    }

    protected abstract void verify(IJavaElement var1) throws JavaModelException;

    protected void verifyDestination(IJavaElement element, IJavaElement destination) throws JavaModelException {
        if (destination == null || !destination.exists()) {
            this.error(969, destination);
        }
        int destType = destination.getElementType();
        switch (element.getElementType()) {
            case 11: 
            case 13: {
                if (destType == 5) break;
                this.error(978, element);
                break;
            }
            case 7: {
                if (destType == 5 || destType == 7) break;
                this.error(978, element);
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                if (destType != 4) {
                    this.error(978, element);
                    break;
                }
                if (!this.isMove() || !((ICompilationUnit)element).isWorkingCopy()) break;
                this.error(967, element);
                break;
            }
            case 4: {
                IPackageFragment fragment = (IPackageFragment)element;
                IJavaElement parent = fragment.getParent();
                if (parent.isReadOnly()) {
                    this.error(976, element);
                    break;
                }
                if (destType == 3) break;
                this.error(978, element);
                break;
            }
            default: {
                this.error(967, element);
            }
        }
    }

    protected void verifyRenaming(IJavaElement element) throws JavaModelException {
        String newName = this.getNewNameFor(element);
        boolean isValid = true;
        switch (element.getElementType()) {
            case 4: {
                if (element.getElementName().equals("")) {
                    throw new JavaModelException(new JavaModelStatus(977, element));
                }
                isValid = true;
                break;
            }
            case 5: {
                isValid = true;
                break;
            }
            case 10: {
                isValid = false;
                break;
            }
            default: {
                isValid = true;
            }
        }
        if (!isValid) {
            throw new JavaModelException(new JavaModelStatus(983, element, newName));
        }
    }

    protected void verifySibling(IJavaElement element, IJavaElement destination) throws JavaModelException {
        IJavaElement insertBeforeElement = (IJavaElement)this.fInsertBeforeElements.get(element);
        if (!(insertBeforeElement == null || insertBeforeElement.exists() && insertBeforeElement.getParent().equals(destination))) {
            this.error(993, insertBeforeElement);
        }
    }
}

