/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import net.sourceforge.phpdt.core.IClasspathEntry;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.core.JavaProject;
import net.sourceforge.phpdt.internal.core.OpenableElementInfo;
import net.sourceforge.phpdt.internal.core.PackageFragmentRoot;
import net.sourceforge.phpdt.internal.core.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

class PackageFragmentRootInfo
extends OpenableElementInfo {
    protected int fRootKind = 1;
    protected Object[] fNonJavaResources = null;

    static Object[] computeFolderNonJavaResources(JavaProject project, IContainer folder, char[][] exclusionPatterns) throws JavaModelException {
        Object[] nonJavaResources = new IResource[5];
        int nonJavaResourcesCounter = 0;
        try {
            project.getResolvedClasspath(true);
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource member = members[i];
                switch (member.getType()) {
                    case 1: {
                        String fileName = member.getName();
                        if (Util.isValidCompilationUnitName(fileName) && !Util.isExcluded(member, exclusionPatterns)) break;
                    }
                    default: {
                        if (nonJavaResources.length == nonJavaResourcesCounter) {
                            Object[] objectArray = nonJavaResources;
                            nonJavaResources = new IResource[nonJavaResourcesCounter * 2];
                            System.arraycopy(objectArray, 0, nonJavaResources, 0, nonJavaResourcesCounter);
                        }
                        nonJavaResources[nonJavaResourcesCounter++] = member;
                    }
                }
                ++i;
            }
            if (nonJavaResources.length != nonJavaResourcesCounter) {
                Object[] objectArray = nonJavaResources;
                nonJavaResources = new IResource[nonJavaResourcesCounter];
                System.arraycopy(objectArray, 0, nonJavaResources, 0, nonJavaResourcesCounter);
            }
            return nonJavaResources;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    private Object[] computeNonJavaResources(IJavaProject project, IResource underlyingResource, PackageFragmentRoot handle) {
        Object[] nonJavaResources = NO_NON_JAVA_RESOURCES;
        try {
            if (underlyingResource.getType() == 2 || underlyingResource.getType() == 4) {
                nonJavaResources = PackageFragmentRootInfo.computeFolderNonJavaResources((JavaProject)project, (IContainer)underlyingResource, handle.fullExclusionPatternChars());
            }
        }
        catch (JavaModelException javaModelException) {}
        return nonJavaResources;
    }

    synchronized Object[] getNonJavaResources(IJavaProject project, IResource underlyingResource, PackageFragmentRoot handle) {
        Object[] nonJavaResources = this.fNonJavaResources;
        if (nonJavaResources == null) {
            nonJavaResources = this.computeNonJavaResources(project, underlyingResource, handle);
            this.fNonJavaResources = nonJavaResources;
        }
        return nonJavaResources;
    }

    public int getRootKind() {
        return this.fRootKind;
    }

    private static boolean isClasspathEntry(IPath path, IClasspathEntry[] resolvedClasspath) {
        int i = 0;
        int length = resolvedClasspath.length;
        while (i < length) {
            IClasspathEntry entry = resolvedClasspath[i];
            if (entry.getPath().equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    synchronized void setNonJavaResources(Object[] resources) {
        this.fNonJavaResources = resources;
    }

    protected void setRootKind(int newRootKind) {
        this.fRootKind = newRootKind;
    }
}

