/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core.builder;

import java.util.ArrayList;
import java.util.Locale;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.compiler.IProblem;
import net.sourceforge.phpdt.internal.compiler.CompilationResult;
import net.sourceforge.phpdt.internal.compiler.Compiler;
import net.sourceforge.phpdt.internal.compiler.DefaultErrorHandlingPolicies;
import net.sourceforge.phpdt.internal.compiler.ICompilerRequestor;
import net.sourceforge.phpdt.internal.compiler.problem.AbortCompilation;
import net.sourceforge.phpdt.internal.compiler.problem.ProblemHandler;
import net.sourceforge.phpdt.internal.core.builder.BuildNotifier;
import net.sourceforge.phpdt.internal.core.builder.ClasspathMultiDirectory;
import net.sourceforge.phpdt.internal.core.builder.ImageBuilderInternalException;
import net.sourceforge.phpdt.internal.core.builder.NameEnvironment;
import net.sourceforge.phpdt.internal.core.builder.PHPBuilder;
import net.sourceforge.phpdt.internal.core.builder.ProblemFactory;
import net.sourceforge.phpdt.internal.core.builder.SourceFile;
import net.sourceforge.phpdt.internal.core.builder.State;
import net.sourceforge.phpdt.internal.core.builder.WorkQueue;
import net.sourceforge.phpdt.internal.core.util.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public abstract class AbstractImageBuilder
implements ICompilerRequestor {
    protected PHPBuilder javaBuilder;
    protected State newState;
    protected NameEnvironment nameEnvironment;
    protected ClasspathMultiDirectory[] sourceLocations;
    protected BuildNotifier notifier;
    protected String encoding;
    protected Compiler compiler;
    protected WorkQueue workQueue;
    protected ArrayList problemSourceFiles;
    protected boolean compiledAllAtOnce;
    private boolean inCompiler;
    public static int MAX_AT_ONCE = 1000;

    protected AbstractImageBuilder(PHPBuilder javaBuilder) {
        this.javaBuilder = javaBuilder;
        this.newState = new State(javaBuilder);
        this.nameEnvironment = javaBuilder.nameEnvironment;
        this.sourceLocations = this.nameEnvironment.sourceLocations;
        this.notifier = javaBuilder.notifier;
        this.encoding = javaBuilder.javaProject.getOption("net.sourceforge.phpeclipse.encoding", true);
        this.compiler = this.newCompiler();
        this.workQueue = new WorkQueue();
        this.problemSourceFiles = new ArrayList(3);
    }

    public void acceptResult(CompilationResult result) {
        SourceFile compilationUnit = (SourceFile)result.getCompilationUnit();
        if (!this.workQueue.isCompiled(compilationUnit)) {
            this.workQueue.finished(compilationUnit);
            try {
                this.updateProblemsFor(compilationUnit, result);
                this.updateTasksFor(compilationUnit, result);
            }
            catch (CoreException e) {
                throw this.internalException(e);
            }
            this.notifier.compiled(compilationUnit);
        }
    }

    protected void cleanUp() {
        this.nameEnvironment.cleanup();
        this.javaBuilder = null;
        this.nameEnvironment = null;
        this.sourceLocations = null;
        this.notifier = null;
        this.compiler = null;
        this.workQueue = null;
        this.problemSourceFiles = null;
    }

    protected void compile(SourceFile[] units) {
        int toDo = units.length;
        this.compiledAllAtOnce = toDo <= MAX_AT_ONCE;
        if (this.compiledAllAtOnce) {
            if (PHPBuilder.DEBUG) {
                int i = 0;
                while (i < toDo) {
                    System.out.println("About to compile " + units[i].typeLocator());
                    ++i;
                }
            }
            this.compile(units, null);
        } else {
            int i = 0;
            boolean compilingFirstGroup = true;
            while (i < toDo) {
                int doNow = toDo < MAX_AT_ONCE ? toDo : MAX_AT_ONCE;
                int index = 0;
                SourceFile[] toCompile = new SourceFile[doNow];
                while (i < toDo && index < doNow) {
                    SourceFile unit = units[i++];
                    if (!compilingFirstGroup && !this.workQueue.isWaiting(unit)) continue;
                    if (PHPBuilder.DEBUG) {
                        System.out.println("About to compile " + unit.typeLocator());
                    }
                    toCompile[index++] = unit;
                }
                if (index < doNow) {
                    SourceFile[] sourceFileArray = toCompile;
                    toCompile = new SourceFile[index];
                    System.arraycopy(sourceFileArray, 0, toCompile, 0, index);
                }
                SourceFile[] additionalUnits = new SourceFile[toDo - i];
                System.arraycopy(units, i, additionalUnits, 0, additionalUnits.length);
                compilingFirstGroup = false;
                this.compile(toCompile, additionalUnits);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void compile(SourceFile[] units, SourceFile[] additionalUnits) {
        if (units.length == 0) {
            return;
        }
        this.notifier.aboutToCompile(units[0]);
        if (!this.problemSourceFiles.isEmpty()) {
            int length;
            int toAdd = this.problemSourceFiles.size();
            int n = length = additionalUnits == null ? 0 : additionalUnits.length;
            if (length == 0) {
                additionalUnits = new SourceFile[toAdd];
            } else {
                SourceFile[] sourceFileArray = additionalUnits;
                additionalUnits = new SourceFile[length + toAdd];
                System.arraycopy(sourceFileArray, 0, additionalUnits, 0, length);
            }
            int i = 0;
            while (i < toAdd) {
                additionalUnits[length + i] = (SourceFile)this.problemSourceFiles.get(i);
                ++i;
            }
        }
        String[] initialTypeNames = new String[units.length];
        int i = 0;
        int l = units.length;
        while (i < l) {
            initialTypeNames[i] = units[i].initialTypeName;
            ++i;
        }
        this.nameEnvironment.setNames(initialTypeNames, additionalUnits);
        this.notifier.checkCancel();
        try {
            try {
                this.inCompiler = true;
                this.compiler.compile(units);
            }
            catch (AbortCompilation abortCompilation) {}
            Object var4_7 = null;
            this.inCompiler = false;
            this.notifier.checkCancel();
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.inCompiler = false;
            throw throwable;
        }
    }

    protected void createErrorFor(IResource resource, String message) {
        try {
            IMarker marker = resource.createMarker("net.sourceforge.phpeclipse.problem");
            int severity = 2;
            if (message.equals(Util.bind("build.duplicateResource")) && "warning".equals(this.javaBuilder.javaProject.getOption("net.sourceforge.phpeclipse.builder.duplicateResourceTask", true))) {
                severity = 1;
            }
            marker.setAttributes(new String[]{"message", "severity", "charStart", "charEnd"}, new Object[]{message, new Integer(severity), new Integer(0), new Integer(1)});
        }
        catch (CoreException e) {
            throw this.internalException(e);
        }
    }

    protected RuntimeException internalException(CoreException t) {
        ImageBuilderInternalException imageBuilderException = new ImageBuilderInternalException(t);
        if (this.inCompiler) {
            return new AbortCompilation(true, imageBuilderException);
        }
        return imageBuilderException;
    }

    protected Compiler newCompiler() {
        return new Compiler(this.nameEnvironment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.javaBuilder.javaProject.getOptions(true), this, ProblemFactory.getProblemFactory(Locale.getDefault()));
    }

    protected boolean isExcludedFromProject(IPath childPath) throws JavaModelException {
        if (childPath.segmentCount() > 2) {
            return false;
        }
        int j = 0;
        int k = this.sourceLocations.length;
        while (j < k) {
            if (childPath.equals((Object)this.sourceLocations[j].sourceFolder.getFullPath())) {
                return true;
            }
            ++j;
        }
        return false;
    }

    protected void storeProblemsFor(SourceFile sourceFile, IProblem[] problems) throws CoreException {
        if (sourceFile == null || problems == null || problems.length == 0) {
            return;
        }
        IFile resource = sourceFile.resource;
        int i = 0;
        int l = problems.length;
        while (i < l) {
            IProblem problem = problems[i];
            int id = problem.getID();
            switch (id) {
                case 0x1000144: {
                    break;
                }
                case 16777528: 
                case 16777531: 
                case 16777532: 
                case 16777533: 
                case 16777543: 
                case 16777546: 
                case 16777547: 
                case 16777548: 
                case 16777549: 
                case 16777550: 
                case 16777551: 
                case 0x1000150: 
                case 0x1000151: 
                case 16777554: 
                case 16777555: {
                    if (this.problemSourceFiles.contains(sourceFile)) break;
                    this.problemSourceFiles.add(sourceFile);
                }
            }
            if (id != 536871362) {
                IMarker marker = resource.createMarker("net.sourceforge.phpeclipse.problem");
                marker.setAttributes(new String[]{"message", "severity", "id", "charStart", "charEnd", "lineNumber", "arguments"}, new Object[]{problem.getMessage(), new Integer(problem.isError() ? 2 : 1), new Integer(id), new Integer(problem.getSourceStart()), new Integer(problem.getSourceEnd() + 1), new Integer(problem.getSourceLineNumber()), Util.getProblemArgumentsForMarker(problem.getArguments())});
            }
            ++i;
        }
    }

    protected void storeTasksFor(SourceFile sourceFile, IProblem[] tasks) throws CoreException {
        if (sourceFile == null || tasks == null || tasks.length == 0) {
            return;
        }
        IFile resource = sourceFile.resource;
        int i = 0;
        int l = tasks.length;
        while (i < l) {
            IProblem task = tasks[i];
            if (task.getID() == 536871362) {
                IMarker marker = resource.createMarker("net.sourceforge.phpeclipse.task");
                int priority = 1;
                String compilerPriority = task.getArguments()[2];
                if ("HIGH".equals(compilerPriority)) {
                    priority = 2;
                } else if ("LOW".equals(compilerPriority)) {
                    priority = 0;
                }
                marker.setAttributes(new String[]{"message", "priority", "done", "charStart", "charEnd", "lineNumber", "userEditable"}, new Object[]{task.getMessage(), new Integer(priority), new Boolean(false), new Integer(task.getSourceStart()), new Integer(task.getSourceEnd() + 1), new Integer(task.getSourceLineNumber()), new Boolean(false)});
            }
            ++i;
        }
    }

    protected void updateProblemsFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        IProblem[] problems = result.getProblems();
        if (problems == null || problems.length == 0) {
            return;
        }
        if (problems != null) {
            int i = 0;
            while (i < problems.length) {
                if (problems[i].getSourceLineNumber() == 1) {
                    problems[i].setSourceLineNumber(ProblemHandler.searchLineNumber(result.lineSeparatorPositions, problems[i].getSourceStart()));
                }
                ++i;
            }
        }
        this.notifier.updateProblemCounts(problems);
        this.storeProblemsFor(sourceFile, problems);
    }

    protected void updateTasksFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        IProblem[] tasks = result.getTasks();
        if (tasks == null || tasks.length == 0) {
            return;
        }
        this.storeTasksFor(sourceFile, tasks);
    }
}

