/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.textmanipulation;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.phpdt.internal.corext.textmanipulation.TextBuffer;
import net.sourceforge.phpdt.internal.corext.textmanipulation.TextManipulationMessages;
import net.sourceforge.phpdt.internal.corext.util.IOCloser;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

class TextBufferFactory {
    private IDocumentProvider fDocumentProvider;
    private Map fFileValueMap;
    private Map fBufferValueMap;

    public TextBufferFactory() {
        this(PHPeclipsePlugin.getDefault().getCompilationUnitDocumentProvider());
    }

    public TextBufferFactory(IDocumentProvider provider) {
        this.fDocumentProvider = provider;
        Assert.isNotNull((Object)this.fDocumentProvider);
        this.fFileValueMap = new HashMap(5);
        this.fBufferValueMap = new HashMap(5);
    }

    public TextBuffer acquire(IFile file) throws CoreException {
        FileEditorInput input = new FileEditorInput(file);
        Value value = (Value)this.fFileValueMap.get(input);
        if (value != null) {
            ++value.references;
            return value.buffer;
        }
        this.fDocumentProvider.connect((Object)input);
        IDocument document = this.fDocumentProvider.getDocument((Object)input);
        IAnnotationModel annotationModel = this.fDocumentProvider.getAnnotationModel((Object)input);
        annotationModel.connect(document);
        value = new Value(new TextBuffer(document), input, document, annotationModel);
        this.fFileValueMap.put(input, value);
        this.fBufferValueMap.put(value.buffer, value);
        ++value.references;
        return value.buffer;
    }

    public void release(TextBuffer buffer) {
        Value value = (Value)this.fBufferValueMap.get(buffer);
        if (value == null) {
            return;
        }
        --value.references;
        if (value.references == 0) {
            buffer.release();
            value.annotationModel.disconnect(value.document);
            this.fDocumentProvider.disconnect((Object)value.input);
            this.fFileValueMap.remove(value.input);
            this.fBufferValueMap.remove(buffer);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commitChanges(TextBuffer buffer, boolean force, IProgressMonitor pm) throws CoreException {
        final Value value = (Value)this.fBufferValueMap.get(buffer);
        if (value == null) {
            return;
        }
        boolean save = force || this.fDocumentProvider.mustSaveDocument((Object)value.input);
        if (!save) return;
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                TextBufferFactory.this.fDocumentProvider.aboutToChange((Object)value.input);
                TextBufferFactory.this.fDocumentProvider.saveDocument(pm, (Object)value.input, value.document, true);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(action, pm);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.fDocumentProvider.changed((Object)value.input);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.fDocumentProvider.changed((Object)value.input);
    }

    public TextBuffer create(IFile file) throws CoreException {
        FileEditorInput input = new FileEditorInput(file);
        IDocument document = this.fDocumentProvider.getDocument((Object)input);
        if (document != null) {
            return new TextBuffer((IDocument)new Document(document.get()));
        }
        return this.createFromFile(file);
    }

    private TextBuffer createFromFile(IFile file) throws CoreException {
        TextBuffer textBuffer;
        InputStream stream = file.getContents();
        InputStreamReader in = null;
        try {
            Document document = new Document();
            in = new InputStreamReader((InputStream)new BufferedInputStream(stream), ResourcesPlugin.getEncoding());
            StringBuffer buffer = new StringBuffer();
            char[] readBuffer = new char[2048];
            int n = in.read(readBuffer);
            while (n > 0) {
                buffer.append(readBuffer, 0, n);
                n = in.read(readBuffer);
            }
            document.set(buffer.toString());
            textBuffer = new TextBuffer((IDocument)document);
            Object var8_11 = null;
        }
        catch (IOException x) {
            try {
                Status s = new Status(4, PHPeclipsePlugin.getPluginId(), 1, x.getMessage(), (Throwable)x);
                throw new CoreException((IStatus)s);
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                IOCloser.perform(in, stream);
                throw throwable;
            }
        }
        IOCloser.perform(in, stream);
        return textBuffer;
    }

    public TextBuffer create(String content) {
        return new TextBuffer((IDocument)new Document(content));
    }

    public void save(TextBuffer buffer, IProgressMonitor pm) throws CoreException {
        Value value = (Value)this.fBufferValueMap.get(buffer);
        if (value == null) {
            this.throwNotManaged();
        }
        this.fDocumentProvider.saveDocument(pm, (Object)value.input, value.document, true);
    }

    public void aboutToChange(TextBuffer buffer) throws CoreException {
        Value value = (Value)this.fBufferValueMap.get(buffer);
        if (value == null) {
            this.throwNotManaged();
        }
        this.fDocumentProvider.aboutToChange((Object)value.input);
    }

    public void changed(TextBuffer buffer) throws CoreException {
        Value value = (Value)this.fBufferValueMap.get(buffer);
        if (value == null) {
            this.throwNotManaged();
        }
        this.fDocumentProvider.changed((Object)value.input);
    }

    private void throwNotManaged() throws CoreException {
        Status s = new Status(4, PHPeclipsePlugin.getPluginId(), 1, TextManipulationMessages.getString("TextBufferFactory.bufferNotManaged"), null);
        throw new CoreException((IStatus)s);
    }

    private static class Value {
        TextBuffer buffer;
        FileEditorInput input;
        IDocument document;
        IAnnotationModel annotationModel;
        int references;

        public Value(TextBuffer b, FileEditorInput i, IDocument d, IAnnotationModel m) {
            this.buffer = b;
            this.input = i;
            this.document = d;
            this.annotationModel = m;
        }
    }
}

