/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.util;

import java.util.StringTokenizer;
import net.sourceforge.phpdt.core.Flags;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IField;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IMember;
import net.sourceforge.phpdt.core.IMethod;
import net.sourceforge.phpdt.core.IPackageFragment;
import net.sourceforge.phpdt.core.IPackageFragmentRoot;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.Signature;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpeclipse.phpeditor.EditorUtility;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class JavaModelUtil {
    private static final String ARGUMENTS_DELIMITER = "#";
    private static final String EMPTY_ARGUMENT = "   ";

    public static boolean isReferenced(IPackageFragmentRoot root) {
        return false;
    }

    public static IType findTypeInCompilationUnit(ICompilationUnit cu, String typeQualifiedName) throws JavaModelException {
        IType[] types = cu.getAllTypes();
        int i = 0;
        while (i < types.length) {
            String currName = JavaModelUtil.getTypeQualifiedName(types[i]);
            if (typeQualifiedName.equals(currName)) {
                return types[i];
            }
            ++i;
        }
        return null;
    }

    public static IMember findMemberInCompilationUnit(ICompilationUnit cu, IMember member) throws JavaModelException {
        IJavaElement[] elements = cu.findElements(member);
        if (elements != null && elements.length > 0) {
            return (IMember)elements[0];
        }
        return null;
    }

    public static IJavaElement findInCompilationUnit(ICompilationUnit cu, IJavaElement element) throws JavaModelException {
        IJavaElement[] elements = cu.findElements(element);
        if (elements != null && elements.length > 0) {
            return elements[0];
        }
        return null;
    }

    public static String getTypeQualifiedName(IType type) {
        return type.getTypeQualifiedName('.');
    }

    private static void getTypeQualifiedName(IType type, StringBuffer buf) {
        IType outerType = type.getDeclaringType();
        if (outerType != null) {
            JavaModelUtil.getTypeQualifiedName(outerType, buf);
            buf.append('.');
        }
        buf.append(type.getElementName());
    }

    public static String getFullyQualifiedName(IType type) {
        return type.getFullyQualifiedName('.');
    }

    public static String getTypeContainerName(IType type) {
        IType outerType = type.getDeclaringType();
        if (outerType != null) {
            return outerType.getFullyQualifiedName('.');
        }
        return type.getPackageFragment().getElementName();
    }

    public static String concatenateName(String name1, String name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length() > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static String concatenateName(char[] name1, char[] name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static boolean isVisible(IMember member, IPackageFragment pack) throws JavaModelException {
        int otherflags = member.getFlags();
        if (Flags.isPublic(otherflags)) {
            return true;
        }
        if (Flags.isPrivate(otherflags)) {
            return false;
        }
        IPackageFragment otherpack = (IPackageFragment)JavaModelUtil.findParentOfKind(member, 4);
        return pack != null && pack.equals(otherpack);
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        return (IPackageFragmentRoot)element.getAncestor(3);
    }

    public static IJavaElement findParentOfKind(IJavaElement element, int kind) {
        if (element != null && element.getParent() != null) {
            return element.getParent().getAncestor(kind);
        }
        return null;
    }

    public static IMethod findMethod(String name, String[] paramTypes, boolean isConstructor, IType type) throws JavaModelException {
        return JavaModelUtil.findMethod(name, paramTypes, isConstructor, type.getMethods());
    }

    public static IMethod findMethod(String name, String[] paramTypes, boolean isConstructor, IMethod[] methods) throws JavaModelException {
        int i = methods.length - 1;
        while (i >= 0) {
            if (JavaModelUtil.isSameMethodSignature(name, paramTypes, isConstructor, methods[i])) {
                return methods[i];
            }
            --i;
        }
        return null;
    }

    public static boolean isSameMethodSignature(String name, String[] paramTypes, boolean isConstructor, IMethod curr) throws JavaModelException {
        String[] currParamTypes;
        if ((isConstructor || name.equals(curr.getElementName())) && isConstructor == curr.isConstructor() && paramTypes.length == (currParamTypes = curr.getParameterTypes()).length) {
            int i = 0;
            while (i < paramTypes.length) {
                String t2;
                String t1 = Signature.getSimpleName(Signature.toString(paramTypes[i]));
                if (!t1.equals(t2 = Signature.getSimpleName(Signature.toString(currParamTypes[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean hasMainMethod(IType type) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].isMainMethod()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isBoolean(IField field) throws JavaModelException {
        return field.getTypeSignature().equals("Z");
    }

    public static String getResolvedTypeName(String refTypeSig, IType declaringType) throws JavaModelException {
        int arrayCount = Signature.getArrayCount(refTypeSig);
        char type = refTypeSig.charAt(arrayCount);
        if (type == 'Q') {
            int semi = refTypeSig.indexOf(59, arrayCount + 1);
            if (semi == -1) {
                throw new IllegalArgumentException();
            }
            refTypeSig.substring(arrayCount + 1, semi);
            return null;
        }
        return Signature.toString(refTypeSig.substring(arrayCount));
    }

    public static boolean isEditable(ICompilationUnit cu) {
        IResource resource;
        if (cu.isWorkingCopy()) {
            cu = (ICompilationUnit)cu.getOriginalElement();
        }
        return (resource = cu.getResource()).exists() && !resource.getResourceAttributes().isReadOnly();
    }

    public static IMember toOriginal(IMember member) {
        if (member instanceof IMethod) {
            return JavaModelUtil.toOriginalMethod((IMethod)member);
        }
        ICompilationUnit cu = member.getCompilationUnit();
        if (cu != null && cu.isWorkingCopy()) {
            return (IMember)cu.getOriginal(member);
        }
        return member;
    }

    private static IMethod toOriginalMethod(IMethod method) {
        try {
            ICompilationUnit cu = method.getCompilationUnit();
            if (cu == null || !cu.isWorkingCopy()) {
                return method;
            }
            if (!method.getElementName().equals(method.getDeclaringType().getElementName())) {
                return (IMethod)cu.getOriginal(method);
            }
            IType originalType = (IType)JavaModelUtil.toOriginal(method.getDeclaringType());
            IMethod[] methods = originalType.findMethods(method);
            boolean isConstructor = method.isConstructor();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].isConstructor() == isConstructor) {
                    return methods[i];
                }
                ++i;
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static ICompilationUnit toOriginal(ICompilationUnit cu) {
        if (cu != null && cu.isWorkingCopy()) {
            return (ICompilationUnit)cu.getOriginal(cu);
        }
        return cu;
    }

    public static IMember toWorkingCopy(IMember member) {
        IJavaElement[] members;
        ICompilationUnit workingCopy;
        ICompilationUnit cu = member.getCompilationUnit();
        if (cu != null && !cu.isWorkingCopy() && (workingCopy = EditorUtility.getWorkingCopy(cu)) != null && (members = workingCopy.findElements(member)) != null && members.length > 0) {
            return (IMember)members[0];
        }
        return member;
    }

    public static ICompilationUnit toWorkingCopy(ICompilationUnit cu) {
        ICompilationUnit workingCopy;
        if (!cu.isWorkingCopy() && (workingCopy = EditorUtility.getWorkingCopy(cu)) != null) {
            return workingCopy;
        }
        return cu;
    }

    public static boolean filterNotPresentException(CoreException exception) {
        if (!(exception instanceof JavaModelException)) {
            return true;
        }
        JavaModelException je = (JavaModelException)exception;
        if (!je.isDoesNotExist()) {
            return true;
        }
        IJavaElement[] elements = je.getJavaModelStatus().getElements();
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            ICompilationUnit unit = (ICompilationUnit)element.getAncestor(5);
            if (unit == null) {
                return true;
            }
            if (!unit.isWorkingCopy()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isExcludedPath(IPath resourcePath, IPath[] exclusionPatterns) {
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            char[] pattern = exclusionPatterns[i].toString().toCharArray();
            if (CharOperation.pathMatch(pattern, path, true, '/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isExcluded(IPath resourcePath, char[][] exclusionPatterns) {
        if (exclusionPatterns == null) {
            return false;
        }
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            if (CharOperation.pathMatch(exclusionPatterns[i], path, true, '/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] getProblemArgumentsFromMarker(String argumentsString) {
        int numberOfArg;
        if (argumentsString == null) {
            return null;
        }
        int index = argumentsString.indexOf(58);
        if (index == -1) {
            return null;
        }
        int length = argumentsString.length();
        try {
            numberOfArg = Integer.parseInt(argumentsString.substring(0, index));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        argumentsString = argumentsString.substring(index + 1, length);
        String[] args = new String[length];
        int count = 0;
        StringTokenizer tokenizer = new StringTokenizer(argumentsString, ARGUMENTS_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String argument = tokenizer.nextToken();
            if (argument.equals(EMPTY_ARGUMENT)) {
                argument = "";
            }
            args[count++] = argument;
        }
        if (count != numberOfArg) {
            return null;
        }
        String[] stringArray = args;
        args = new String[count];
        System.arraycopy(stringArray, 0, args, 0, count);
        return args;
    }
}

