/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.actions;

import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.IPackageFragment;
import net.sourceforge.phpdt.core.IPackageFragmentRoot;
import net.sourceforge.phpdt.internal.corext.refactoring.util.ResourceUtil;
import net.sourceforge.phpdt.internal.ui.actions.ActionMessages;
import net.sourceforge.phpdt.internal.ui.actions.SelectionConverter;
import net.sourceforge.phpeclipse.phpeditor.PHPEditor;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ActionUtil {
    private ActionUtil() {
    }

    public static boolean mustDisableJavaModelAction(Shell shell, Object element) {
        if (!(element instanceof IPackageFragment) && !(element instanceof IPackageFragmentRoot)) {
            return false;
        }
        IResource resource = ResourceUtil.getResource(element);
        if (resource == null || !(resource instanceof IFolder) || !resource.isLinked()) {
            return false;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.getString("ActionUtil.not_possible"), (String)ActionMessages.getString("ActionUtil.no_linked"));
        return true;
    }

    public static boolean isProcessable(Shell shell, PHPEditor editor) {
        if (editor == null) {
            return true;
        }
        IJavaElement input = SelectionConverter.getInput(editor);
        if (input == null) {
            MessageDialog.openInformation((Shell)shell, (String)ActionMessages.getString("ActionUtil.notOnBuildPath.title"), (String)ActionMessages.getString("ActionUtil.notOnBuildPath.message"));
            return false;
        }
        return ActionUtil.isProcessable(shell, input);
    }

    public static boolean isProcessable(Shell shell, Object element) {
        if (!(element instanceof IJavaElement)) {
            return true;
        }
        if (ActionUtil.isOnBuildPath((IJavaElement)element)) {
            return true;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.getString("ActionUtil.notOnBuildPath.title"), (String)ActionMessages.getString("ActionUtil.notOnBuildPath.message"));
        return false;
    }

    public static boolean isOnBuildPath(IJavaElement element) {
        IProject resourceProject;
        block5: {
            if (element.getElementType() == 2) {
                return true;
            }
            IJavaProject project = element.getJavaProject();
            try {
                resourceProject = project.getProject();
                if (resourceProject != null) break block5;
                return false;
            }
            catch (CoreException coreException) {}
        }
        IProjectNature nature = resourceProject.getNature("net.sourceforge.phpeclipse.phpnature");
        if (nature != null) {
            return true;
        }
        return false;
    }
}

