/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.dnd;

import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public class JdtViewerDropAdapter
implements DropTargetListener {
    protected static final int LOCATION_BEFORE = 1;
    protected static final int LOCATION_AFTER = 2;
    protected static final int LOCATION_ON = 3;
    protected static final int LOCATION_NONE = 4;
    private static final int LOCATION_EPSILON = 5;
    public static final int INSERTION_FEEDBACK = 2;
    private StructuredViewer fViewer;
    private int fFeedback;
    private boolean fShowInsertionFeedback;
    private int fRequestedOperation;
    private int fLastOperation;
    protected int fLocation;
    protected Object fTarget;

    public JdtViewerDropAdapter(StructuredViewer viewer, int feedback) {
        this.fViewer = viewer;
        Assert.isNotNull((Object)this.fViewer);
        this.fFeedback = feedback;
        this.fLastOperation = -1;
    }

    public void showInsertionFeedback(boolean showInsertionFeedback) {
        this.fShowInsertionFeedback = showInsertionFeedback;
    }

    protected StructuredViewer getViewer() {
        return this.fViewer;
    }

    public void drop(DropTargetEvent event) {
        this.drop(this.fTarget, event);
    }

    public void drop(Object target, DropTargetEvent event) {
    }

    public void validateDrop(DropTargetEvent event) {
        this.validateDrop(this.fTarget, event, this.fRequestedOperation);
    }

    public void validateDrop(Object target, DropTargetEvent event, int operation) {
    }

    public void dragEnter(DropTargetEvent event) {
        this.dragOperationChanged(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.fTarget = null;
        this.fLocation = 4;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.fRequestedOperation = event.detail;
        this.fTarget = this.computeTarget(event);
        this.fLocation = this.computeLocation(event);
        this.validateDrop(event);
        this.fLastOperation = event.detail;
        this.computeFeedback(event);
    }

    public void dragOver(DropTargetEvent event) {
        Object oldTarget = this.fTarget;
        this.fTarget = this.computeTarget(event);
        int oldLocation = this.fLocation;
        this.fLocation = this.computeLocation(event);
        if (oldLocation != this.fLocation || oldTarget != this.fTarget || this.fLastOperation != event.detail) {
            this.validateDrop(event);
            this.fLastOperation = event.detail;
        } else {
            event.detail = this.fLastOperation;
        }
        this.computeFeedback(event);
    }

    public void dropAccept(DropTargetEvent event) {
        this.fTarget = this.computeTarget(event);
        this.validateDrop(event);
        this.fLastOperation = event.detail;
    }

    protected Object computeTarget(DropTargetEvent event) {
        return event.item == null ? null : event.item.getData();
    }

    protected final int computeLocation(DropTargetEvent event) {
        if (!(event.item instanceof Item)) {
            return 4;
        }
        Item item = (Item)event.item;
        Point coordinates = this.fViewer.getControl().toControl(new Point(event.x, event.y));
        Rectangle bounds = this.getBounds(item);
        if (bounds == null) {
            return 4;
        }
        if (coordinates.y - bounds.y < 5) {
            return 1;
        }
        if (bounds.y + bounds.height - coordinates.y < 5) {
            return 2;
        }
        return 3;
    }

    private Rectangle getBounds(Item item) {
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getBounds();
        }
        if (item instanceof TableItem) {
            return ((TableItem)item).getBounds(0);
        }
        return null;
    }

    protected void computeFeedback(DropTargetEvent event) {
        if (!this.fShowInsertionFeedback && this.fLocation != 4) {
            event.feedback = 1;
        } else if (this.fLocation == 1) {
            event.feedback = 2;
        } else if (this.fLocation == 2) {
            event.feedback = 4;
        }
        event.feedback |= this.fFeedback;
    }

    protected void clearDropOperation(DropTargetEvent event) {
        event.detail = 0;
    }

    protected int getRequestedOperation() {
        return this.fRequestedOperation;
    }
}

