/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.phpdoc;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.phpdt.internal.ui.text.AbstractJavaScanner;
import net.sourceforge.phpdt.ui.text.IColorManager;
import net.sourceforge.phpeclipse.phpeditor.util.PHPWhitespaceDetector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public final class PHPDocCodeScanner
extends AbstractJavaScanner {
    private static String[] fgKeywords = new String[]{"@author", "@deprecated", "@exception", "@link", "@param", "@return", "@see", "@since", "@throws", "@value", "@version", "@license", "@abstract", "@access", "@category", "@copyright", "@example", "@final", "@filesource", "@global", "@ignore", "@internal", "@link", "@method", "@name", "@package", "@param", "@property", "@static", "@staticvar", "@subpackage", "@todo", "@tutorial", "@uses", "@var", "@id", "inheritdoc", "@property-read", "@property-write", "@source"};
    private static String[] fgTokenProperties = new String[]{"_php_doc_keyword", "_php_doc_tag", "_php_doc_link", "_php_doc_default"};

    public PHPDocCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> list = new ArrayList<Object>();
        Token token = this.getToken("_php_doc_tag");
        list.add((Object)new TagRule((IToken)token));
        WordRule wordRule = new WordRule((IWordDetector)new HTMLCommentDetector(), (IToken)token);
        wordRule.addWord("<!--", (IToken)token);
        wordRule.addWord("--!>", (IToken)token);
        list.add(wordRule);
        token = this.getToken("_php_doc_link");
        list.add(new SingleLineRule("{@link", "}", (IToken)token));
        list.add(new WhitespaceRule((IWhitespaceDetector)new PHPWhitespaceDetector()));
        token = this.getToken("_php_doc_default");
        wordRule = new WordRule((IWordDetector)new JavaDocKeywordDetector(), (IToken)token);
        token = this.getToken("_php_doc_keyword");
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)token);
            ++i;
        }
        list.add(wordRule);
        this.setDefaultReturnToken((IToken)this.getToken("_php_doc_default"));
        return list;
    }

    static class HTMLCommentDetector
    implements IWordDetector {
        HTMLCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '<' || c == '-';
        }

        public boolean isWordPart(char c) {
            return c == '-' || c == '!' || c == '>';
        }
    }

    static class JavaDocKeywordDetector
    implements IWordDetector {
        JavaDocKeywordDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '@';
        }

        public boolean isWordPart(char c) {
            return Character.isLetter(c);
        }
    }

    class TagRule
    extends SingleLineRule {
        public TagRule(IToken token) {
            super("<", ">", token, '\u0000');
        }

        public TagRule(IToken token, char escapeCharacter) {
            super("<", ">", token, escapeCharacter);
        }

        private IToken checkForWhitespace(ICharacterScanner scanner) {
            try {
                char c = PHPDocCodeScanner.this.getDocument().getChar(PHPDocCodeScanner.this.getTokenOffset() + 1);
                if (!Character.isWhitespace(c)) {
                    return this.fToken;
                }
            }
            catch (BadLocationException badLocationException) {}
            return Token.UNDEFINED;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            IToken result = super.evaluate(scanner);
            if (result == this.fToken) {
                return this.checkForWhitespace(scanner);
            }
            return result;
        }
    }
}

