/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.template;

import net.sourceforge.phpdt.internal.ui.PHPUiImages;
import net.sourceforge.phpdt.internal.ui.text.link.LinkedPositionManager;
import net.sourceforge.phpdt.internal.ui.text.link.LinkedPositionUI;
import net.sourceforge.phpdt.internal.ui.text.template.AbstractProposal;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;

public class LocalVariableProposal
extends AbstractProposal {
    private final String fIdentifierName;
    private final IRegion fRegion;
    private final int fRelevance;

    public LocalVariableProposal(String identifierName, IRegion region, ITextViewer viewer) {
        this(identifierName, region, viewer, 99);
    }

    public LocalVariableProposal(String identifierName, IRegion region, ITextViewer viewer, int relevance) {
        super(viewer);
        this.fIdentifierName = identifierName;
        this.fRegion = region;
        this.fRelevance = relevance;
    }

    public void apply(IDocument document) {
        try {
            int start = this.fRegion.getOffset();
            int end = this.fRegion.getOffset() + this.fRegion.getLength();
            document.replace(start, end - start, this.fIdentifierName);
            LinkedPositionManager manager = new LinkedPositionManager(document);
            LinkedPositionUI editor = new LinkedPositionUI(this.fViewer, manager);
            editor.setFinalCaretOffset(this.fIdentifierName.length() + start);
            editor.enter();
            this.fSelectedRegion = editor.getSelectedRegion();
        }
        catch (BadLocationException e) {
            PHPeclipsePlugin.log(e);
            this.openErrorDialog(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalVariableProposal) {
            return this.fIdentifierName.equals(((LocalVariableProposal)obj).fIdentifierName);
        }
        return false;
    }

    public String getAdditionalProposalInfo() {
        StringBuffer hoverInfoBuffer = new StringBuffer();
        if (this.fRelevance > 95) {
            hoverInfoBuffer.append("function source variable -");
        } else {
            hoverInfoBuffer.append("editor source variable -");
        }
        hoverInfoBuffer.append(this.fIdentifierName);
        return hoverInfoBuffer.toString();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.fIdentifierName;
    }

    public Image getImage() {
        return PHPUiImages.get("net.sourceforge.phpdt.internal.ui.var_obj.gif");
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public int hashCode() {
        return this.fIdentifierName.hashCode();
    }
}

