/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.util;

import net.sourceforge.phpdt.internal.ui.util.PHPElementVisitor;
import net.sourceforge.phpdt.internal.ui.util.PHPProjectSelector;
import net.sourceforge.phpdt.internal.ui.util.ResourceSelector;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PHPFileSelector
extends ResourceSelector {
    protected PHPProjectSelector phpProjectSelector;
    static /* synthetic */ Class class$0;

    public PHPFileSelector(Composite parent, PHPProjectSelector aProjectSelector) {
        super(parent);
        Assert.isNotNull((Object)aProjectSelector);
        this.phpProjectSelector = aProjectSelector;
        this.browseDialogTitle = "File Selection";
    }

    protected Object[] getPHPFiles() {
        IProject phpProject = this.phpProjectSelector.getSelection();
        if (phpProject == null) {
            return new Object[0];
        }
        PHPElementVisitor visitor = new PHPElementVisitor();
        try {
            phpProject.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            PHPeclipsePlugin.log(e);
        }
        return visitor.getCollectedPHPFiles();
    }

    public IFile getSelection() {
        String fileName = this.getSelectionText();
        if (fileName != null && !fileName.equals("")) {
            Path filePath = new Path(fileName);
            IProject project = this.phpProjectSelector.getSelection();
            if (project != null && project.exists((IPath)filePath)) {
                return project.getFile((IPath)filePath);
            }
        }
        return null;
    }

    protected void handleBrowseSelected() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new FileLabelProvider());
        dialog.setTitle(this.browseDialogTitle);
        dialog.setMessage(this.browseDialogMessage);
        dialog.setElements(this.getPHPFiles());
        if (dialog.open() == 0) {
            this.textField.setText(((IResource)dialog.getFirstResult()).getProjectRelativePath().toString());
        }
    }

    protected String validateResourceSelection() {
        IFile selection = this.getSelection();
        return selection == null ? "" : selection.getProjectRelativePath().toString();
    }

    static class FileLabelProvider
    extends LabelProvider {
        FileLabelProvider() {
        }

        protected final IWorkbenchAdapter getAdapter(Object o) {
            if (!(o instanceof IAdaptable)) {
                return null;
            }
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz);
        }

        public String getText(Object element) {
            if (element instanceof IFile) {
                IWorkbenchAdapter adapter = this.getAdapter(element);
                if (adapter == null) {
                    return "";
                }
                String filename = adapter.getLabel(element);
                IPath path = ((IFile)element).getFullPath();
                String filePathname = path != null ? path.toString() : "";
                return String.valueOf(filename) + " (" + filePathname + ")";
            }
            return super.getText(element);
        }
    }
}

