/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.ui;

import net.sourceforge.phpdt.internal.ui.viewsupport.JavaElementImageProvider;
import net.sourceforge.phpdt.internal.ui.viewsupport.JavaElementLabels;
import net.sourceforge.phpdt.internal.ui.viewsupport.StorageLabelProvider;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class JavaElementLabelProvider
extends LabelProvider {
    public static final int SHOW_RETURN_TYPE = 1;
    public static final int SHOW_PARAMETERS = 2;
    public static final int SHOW_CONTAINER = 4;
    public static final int SHOW_CONTAINER_QUALIFICATION = 8;
    public static final int SHOW_OVERLAY_ICONS = 16;
    public static final int SHOW_TYPE = 32;
    public static final int SHOW_ROOT = 64;
    public static final int SHOW_POSTIFIX_QUALIFICATION = 128;
    public static final int SHOW_SMALL_ICONS = 256;
    public static final int SHOW_VARIABLE = 512;
    public static final int SHOW_QUALIFIED = 1024;
    public static final int SHOW_POST_QUALIFIED = 2048;
    public static final int SHOW_BASICS = 0;
    public static final int SHOW_DEFAULT = new Integer(18);
    private JavaElementImageProvider fImageLabelProvider = new JavaElementImageProvider();
    private StorageLabelProvider fStorageLabelProvider = new StorageLabelProvider();
    private int fFlags;
    private int fImageFlags;
    private int fTextFlags;

    public JavaElementLabelProvider() {
        this(SHOW_DEFAULT);
    }

    public JavaElementLabelProvider(int flags) {
        this.fFlags = flags;
        this.updateImageProviderFlags();
        this.updateTextProviderFlags();
    }

    private boolean getFlag(int flag) {
        return (this.fFlags & flag) != 0;
    }

    public void turnOn(int flags) {
        this.fFlags |= flags;
        this.updateImageProviderFlags();
        this.updateTextProviderFlags();
    }

    public void turnOff(int flags) {
        this.fFlags &= ~flags;
        this.updateImageProviderFlags();
        this.updateTextProviderFlags();
    }

    private void updateImageProviderFlags() {
        this.fImageFlags = 0;
        if (this.getFlag(16)) {
            this.fImageFlags |= 1;
        }
        if (this.getFlag(256)) {
            this.fImageFlags |= 2;
        }
    }

    private void updateTextProviderFlags() {
        this.fTextFlags = 0;
        if (this.getFlag(1)) {
            this.fTextFlags |= 8;
        }
        if (this.getFlag(2)) {
            this.fTextFlags |= 1;
        }
        if (this.getFlag(4)) {
            this.fTextFlags |= 0xA89040;
        }
        if (this.getFlag(128)) {
            this.fTextFlags |= 0x288000;
        } else if (this.getFlag(8)) {
            this.fTextFlags |= 0x142000;
        }
        if (this.getFlag(32)) {
            this.fTextFlags |= 0x200;
        }
        if (this.getFlag(64)) {
            this.fTextFlags |= 0x8000000;
        }
        if (this.getFlag(512)) {
            this.fTextFlags |= 0x1000000;
        }
        if (this.getFlag(1024)) {
            this.fTextFlags |= 0x1528A0;
        }
        if (this.getFlag(2048)) {
            this.fTextFlags |= 0x2A9140;
        }
    }

    public Image getImage(Object element) {
        Image result = this.fImageLabelProvider.getImageLabel(element, this.fImageFlags);
        if (result != null) {
            return result;
        }
        if (element instanceof IStorage) {
            return this.fStorageLabelProvider.getImage(element);
        }
        return result;
    }

    public String getText(Object element) {
        String text = JavaElementLabels.getTextLabel(element, this.fTextFlags);
        if (text.length() > 0) {
            return text;
        }
        if (element instanceof IStorage) {
            return this.fStorageLabelProvider.getText(element);
        }
        return text;
    }

    public void dispose() {
        this.fStorageLabelProvider.dispose();
        this.fImageLabelProvider.dispose();
    }
}

