/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.phpdt.internal.ui.actions.ActionMessages;
import net.sourceforge.phpdt.internal.ui.actions.AddTaskAction;
import net.sourceforge.phpeclipse.phpeditor.PHPEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IUpdate;

public class GenerateActionGroup
extends ActionGroup {
    public static final String MENU_ID = "net.sourceforge.pheclipse.ui.source.menu";
    private PHPEditor fEditor;
    private IWorkbenchSite fSite;
    private String fGroupName = "group.generate";
    private List fRegisteredSelectionListeners;
    private AddBookmarkAction fAddBookmark;
    private AddTaskAction fAddTaskAction;

    public GenerateActionGroup(PHPEditor editor, String groupName) {
        this.fSite = editor.getSite();
        this.fEditor = editor;
        this.fGroupName = groupName;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        provider.getSelection();
    }

    public GenerateActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public GenerateActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
    }

    private GenerateActionGroup(IWorkbenchSite site) {
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fAddBookmark = new AddBookmarkAction(site.getShell());
        this.fAddTaskAction = new AddTaskAction(site);
        this.fAddTaskAction.update(selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            this.fAddBookmark.selectionChanged(ss);
        } else {
            this.fAddBookmark.setEnabled(false);
        }
        this.registerSelectionListener(provider, (ISelectionChangedListener)this.fAddBookmark);
        this.registerSelectionListener(provider, this.fAddTaskAction);
    }

    private void registerSelectionListener(ISelectionProvider provider, ISelectionChangedListener listener) {
        if (this.fRegisteredSelectionListeners == null) {
            this.fRegisteredSelectionListeners = new ArrayList(12);
        }
        provider.addSelectionChangedListener(listener);
        this.fRegisteredSelectionListeners.add(listener);
    }

    public void editorStateChanged() {
        Assert.isTrue((boolean)this.isEditorOwner());
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        String shortCut = null;
        MenuManager subMenu = new MenuManager(String.valueOf(ActionMessages.getString("SourceMenu.label")) + (shortCut != null ? "\t" + shortCut : ""), MENU_ID);
        int added = 0;
        if (this.isEditorOwner()) {
            added = this.fillEditorSubMenu((IMenuManager)subMenu);
        }
        if (added > 0) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)subMenu);
        }
    }

    private int fillEditorSubMenu(IMenuManager source) {
        int added = 0;
        added += this.addEditorAction(source, "Comment");
        added += this.addEditorAction(source, "Uncomment");
        added += this.addEditorAction(source, "ToggleComment");
        added += this.addEditorAction(source, "AddBlockComment");
        added += this.addEditorAction(source, "RemoveBlockComment");
        added += this.addEditorAction(source, "Format");
        return added += this.addEditorAction(source, "Indent");
    }

    public void dispose() {
        if (this.fRegisteredSelectionListeners != null) {
            ISelectionProvider provider = this.fSite.getSelectionProvider();
            Iterator iter = this.fRegisteredSelectionListeners.iterator();
            while (iter.hasNext()) {
                ISelectionChangedListener listener = (ISelectionChangedListener)iter.next();
                provider.removeSelectionChangedListener(listener);
            }
        }
        this.fEditor = null;
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBar) {
        if (!this.isEditorOwner()) {
            actionBar.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.fAddBookmark);
            actionBar.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), (IAction)this.fAddTaskAction);
        }
    }

    private int appendToGroup(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.appendToGroup(this.fGroupName, action);
            return 1;
        }
        return 0;
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private int addEditorAction(IMenuManager menu, String actionID) {
        if (this.fEditor == null) {
            return 0;
        }
        IAction action = this.fEditor.getAction(actionID);
        if (action == null) {
            return 0;
        }
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if (action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private boolean isEditorOwner() {
        return this.fEditor != null;
    }
}

