/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpeditor;

import net.sourceforge.phpeclipse.phpeditor.IPainter;
import net.sourceforge.phpeclipse.phpeditor.IPositionManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;

public class LinePainter
implements IPainter,
LineBackgroundListener {
    private final ISourceViewer fViewer;
    private Color fHighlightColor;
    private IPositionManager fPositionManager;
    private Position fCurrentLine = new Position(0, 0);
    private Position fLastLine = new Position(0, 0);
    private int fLastLineNumber = -1;
    private boolean fIsActive;

    public LinePainter(ISourceViewer sourceViewer) {
        this.fViewer = sourceViewer;
    }

    public void setHighlightColor(Color highlightColor) {
        this.fHighlightColor = highlightColor;
    }

    public void lineGetBackground(LineBackgroundEvent event) {
        StyledText textWidget = this.fViewer.getTextWidget();
        if (textWidget != null) {
            int caret = textWidget.getCaretOffset();
            int length = event.lineText.length();
            event.lineBackground = event.lineOffset <= caret && caret <= event.lineOffset + length ? this.fHighlightColor : textWidget.getBackground();
        }
    }

    private boolean updateHighlightLine() {
        try {
            IDocument document = this.fViewer.getDocument();
            int offset = this.fViewer.getTextWidget().getCaretOffset() + this.fViewer.getVisibleRegion().getOffset();
            int lineNumber = document.getLineOfOffset(offset);
            if (lineNumber != this.fLastLineNumber) {
                this.fLastLine.offset = this.fCurrentLine.offset;
                this.fLastLine.length = this.fCurrentLine.length;
                this.fLastLine.isDeleted = this.fCurrentLine.isDeleted;
                this.fCurrentLine.isDeleted = false;
                this.fCurrentLine.offset = document.getLineOffset(lineNumber);
                this.fCurrentLine.length = lineNumber == document.getNumberOfLines() - 1 ? document.getLength() - this.fCurrentLine.offset : document.getLineOffset(lineNumber + 1) - this.fCurrentLine.offset;
                this.fLastLineNumber = lineNumber;
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private void drawHighlightLine(Position position, int visibleOffset) {
        StyledText textWidget = this.fViewer.getTextWidget();
        if (position.isDeleted()) {
            return;
        }
        int delta = position.offset - visibleOffset;
        if (delta >= 0 && delta <= this.fViewer.getVisibleRegion().getLength()) {
            Point upperLeft = textWidget.getLocationAtOffset(delta);
            int width = textWidget.getClientArea().width + textWidget.getHorizontalPixel();
            int height = textWidget.getLineHeight();
            textWidget.redraw(upperLeft.x, upperLeft.y, width, height, false);
        }
    }

    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            if (redraw) {
                this.drawHighlightLine(this.fCurrentLine, this.fViewer.getVisibleRegion().getOffset());
            }
            this.fViewer.getTextWidget().removeLineBackgroundListener((LineBackgroundListener)this);
            if (this.fPositionManager != null) {
                this.fPositionManager.removeManagedPosition(this.fCurrentLine);
            }
            this.fLastLineNumber = -1;
        }
    }

    public void dispose() {
    }

    public void paint(int reason) {
        Point selection = this.fViewer.getTextWidget().getSelectionRange();
        if (selection.y > 0) {
            this.deactivate(true);
            return;
        }
        if (!this.fIsActive) {
            this.fViewer.getTextWidget().addLineBackgroundListener((LineBackgroundListener)this);
            this.fPositionManager.addManagedPosition(this.fCurrentLine);
            this.fIsActive = true;
        }
        if (this.updateHighlightLine()) {
            int visibleRegionOffset = this.fViewer.getVisibleRegion().getOffset();
            this.drawHighlightLine(this.fLastLine, visibleRegionOffset);
            this.drawHighlightLine(this.fCurrentLine, visibleRegionOffset);
        }
    }

    public void setPositionManager(IPositionManager manager) {
        this.fPositionManager = manager;
    }
}

