/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.preferences;

import net.sourceforge.phpdt.internal.core.JavaProject;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.preferences.PHPPreferencesMessages;
import net.sourceforge.phpeclipse.preferences.PHPProjectLibraryPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class PHPProjectPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    protected PHPProjectLibraryPage projectsPage;
    protected JavaProject workingProject;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this.workingProject = this.getPHPProject();
        if (this.workingProject == null || !this.workingProject.getProject().isOpen()) {
            return this.createClosedProjectPageContents(parent);
        }
        return this.createProjectPageContents(parent);
    }

    protected JavaProject getPHPProject() {
        IAdaptable selectedElement = this.getElement();
        if (selectedElement == null) {
            return null;
        }
        if (selectedElement instanceof JavaProject) {
            return (JavaProject)selectedElement;
        }
        if (selectedElement instanceof IProject) {
            IProject simpleProject = (IProject)selectedElement;
            try {
                if (simpleProject.hasNature("net.sourceforge.phpeclipse.phpnature")) {
                    JavaProject phpProject = new JavaProject();
                    phpProject.setProject(simpleProject);
                    return phpProject;
                }
            }
            catch (CoreException e) {
                PHPeclipsePlugin.log(e);
            }
        }
        return null;
    }

    protected Control createClosedProjectPageContents(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PHPPreferencesMessages.getString("PHPProjectPropertyPage.phpProjectClosed"));
        return label;
    }

    protected Control createProjectPageContents(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayout((Layout)new GridLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.projectsPage = new PHPProjectLibraryPage(this.workingProject);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(PHPPreferencesMessages.getString("PHPProjectLibraryPage.tabName"));
        tabItem.setControl(this.projectsPage.getControl((Composite)tabFolder));
        return tabFolder;
    }

    public boolean performOk() {
        try {
            this.projectsPage.getWorkingProject().save();
        }
        catch (CoreException e) {
            PHPeclipsePlugin.log(e);
        }
        return super.performOk();
    }
}

