/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.wizards;

import net.sourceforge.phpeclipse.wizards.PHPWizardMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class HTMLFileWizardPage
extends WizardPage {
    private static final String INITIAL_FILENAME = "file.html";
    private Text containerText;
    private Text fileText;
    private ISelection selection;

    public HTMLFileWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(PHPWizardMessages.getString("WizardPage.html.title"));
        this.setDescription(PHPWizardMessages.getString("WizardPage.html.description"));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(PHPWizardMessages.getString("WizardPage.containerLabel"));
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HTMLFileWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(PHPWizardMessages.getString("WizardPage.browseButtonText"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HTMLFileWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(PHPWizardMessages.getString("WizardPage.fileLabel"));
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HTMLFileWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
                this.fileText.setFocus();
            }
        }
        this.fileText.setText(INITIAL_FILENAME);
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, PHPWizardMessages.getString("WizardPage.selectNewFileContainer"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            IContainer container = (IContainer)result[0];
            this.containerText.setText(container.getFullPath().toString());
        }
    }

    private void dialogChanged() {
        String container = this.getContainerName();
        String fileName = this.getFileName();
        if (container.length() == 0) {
            this.updateStatus(PHPWizardMessages.getString("WizardPage.containerMustBeSpecified"));
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("WizardPage.nameMustBeSpecified");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public boolean isPageComplete() {
        return !this.checkFolderForExistingFile() && super.isPageComplete();
    }

    protected boolean checkFolderForExistingFile() {
        IFile file;
        IContainer container = this.getFileContainer();
        if (container != null && (file = container.getFile((IPath)new Path(this.fileText.getText().trim()))) != null && file.exists()) {
            this.setErrorMessage(PHPWizardMessages.getString("WizardPage.fileAlreadyExists"));
            return true;
        }
        return false;
    }

    private IContainer getFileContainer() {
        Path containerPath;
        Object container;
        if (this.containerText.getText() != null && (container = (containerPath = new Path(this.containerText.getText().trim())).segmentCount() > 1 ? ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)containerPath) : ResourcesPlugin.getWorkspace().getRoot().getProject(this.containerText.getText().trim())) != null && container.exists()) {
            return container;
        }
        return null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            String fileName = this.fileText.getText().trim();
            if (this.getFileContainer() != null && fileName.equalsIgnoreCase(INITIAL_FILENAME)) {
                this.fileText.setFocus();
                this.fileText.setText(fileName);
                this.fileText.setSelection(0, fileName.length() - new Path(INITIAL_FILENAME).getFileExtension().length() - 1);
            }
        }
    }
}

