/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser;

import java.net.URL;
import net.sourceforge.phpeclipse.webbrowser.IWebBrowserEditorInput;
import net.sourceforge.phpeclipse.webbrowser.internal.ImageResource;
import net.sourceforge.phpeclipse.webbrowser.internal.Trace;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserPreference;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class WebBrowserEditorInput
implements IWebBrowserEditorInput,
IPersistableElement,
IElementFactory {
    public static final int SHOW_TOOLBAR = 2;
    public static final int SHOW_STATUSBAR = 4;
    public static final int FORCE_NEW_PAGE = 8;
    public static final int SAVE_URL = 32;
    public static final int TRANSIENT = 64;
    public static final int SHOW_ALL = 6;
    private static final String ELEMENT_FACTORY_ID = "net.sourceforge.phpeclipse.webbrowser.elementFactory";
    private static final String MEMENTO_URL = "url";
    private static final String MEMENTO_STYLE = "style";
    private static final String MEMENTO_ID = "id";
    private URL url;
    private int style;
    private String id = null;

    public WebBrowserEditorInput() {
        this(null);
    }

    public WebBrowserEditorInput(URL url) {
        this(url, 38);
    }

    public WebBrowserEditorInput(URL url, int style) {
        this.url = url;
        this.style = style;
    }

    public WebBrowserEditorInput(URL url, int style, String browserId) {
        this.url = url;
        this.style = style;
        this.id = browserId;
    }

    public WebBrowserEditorInput(URL url, boolean b) {
        this(url);
    }

    public boolean canReplaceInput(IWebBrowserEditorInput input) {
        Trace.trace(Trace.FINEST, "canReplaceInput " + this + " " + input);
        if ((this.style & 8) != 0) {
            return false;
        }
        if (input.isToolbarVisible() != this.isToolbarVisible()) {
            return false;
        }
        if (input.isStatusbarVisible() != this.isStatusbarVisible()) {
            return false;
        }
        if (this.id != null) {
            if (!(input instanceof WebBrowserEditorInput)) {
                return false;
            }
            String bid = ((WebBrowserEditorInput)input).getBrowserId();
            return this.id.equals(bid);
        }
        return false;
    }

    public IAdaptable createElement(IMemento memento) {
        URL url2 = null;
        try {
            url2 = new URL(WebBrowserPreference.getHomePageURL());
        }
        catch (Exception exception) {}
        int newStyle = 6;
        try {
            newStyle = memento.getInteger(MEMENTO_STYLE);
            if ((newStyle & 0x20) != 0) {
                this.url = new URL(memento.getString(MEMENTO_URL));
            }
        }
        catch (Exception exception) {}
        String id2 = null;
        try {
            id2 = memento.getString(MEMENTO_ID);
            if (id2 != null && id2.length() < 1) {
                id2 = null;
            }
        }
        catch (Exception exception) {}
        return new WebBrowserEditorInput(url2, newStyle, id2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WebBrowserEditorInput)) {
            return false;
        }
        WebBrowserEditorInput other = (WebBrowserEditorInput)obj;
        if (this.url != null && !this.url.equals(obj)) {
            return false;
        }
        return this.canReplaceInput(other);
    }

    public boolean exists() {
        return (this.style & 0x40) == 0;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getFactoryId() {
        return ELEMENT_FACTORY_ID;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageResource.getImageDescriptor("internalBrowser");
    }

    public String getName() {
        return WebBrowserUIPlugin.getResource("%viewWebBrowserTitle");
    }

    public IPersistableElement getPersistable() {
        if ((this.style & 0x40) != 0) {
            return null;
        }
        return this;
    }

    public String getToolTipText() {
        if (this.url != null) {
            return this.url.toExternalForm();
        }
        return WebBrowserUIPlugin.getResource("%viewWebBrowserTitle");
    }

    public URL getURL() {
        return this.url;
    }

    public String getBrowserId() {
        return this.id;
    }

    public boolean isStatusbarVisible() {
        return (this.style & 4) != 0;
    }

    public boolean isToolbarVisible() {
        return (this.style & 2) != 0;
    }

    public void saveState(IMemento memento) {
        if ((this.style & 0x20) != 0 && this.url != null) {
            memento.putString(MEMENTO_URL, this.url.toExternalForm());
        }
        memento.putInteger(MEMENTO_STYLE, this.style);
        if (this.id != null) {
            memento.putString(MEMENTO_ID, this.id);
        }
    }

    public String toString() {
        return "WebBrowserEditorInput[" + this.url + " " + this.style + " " + this.id + "]";
    }
}

