/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.phpeclipse.webbrowser.internal.Favorite;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUIPlugin;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;

public class WebBrowserPreference {
    protected static final String PREF_BROWSER_HISTORY = "webBrowserHistory";
    protected static final String PREF_INTERNAL_WEB_BROWSER_HISTORY = "internalWebBrowserHistory";
    protected static final String PREF_INTERNAL_WEB_BROWSER_FAVORITES = "internalWebBrowserFavorites";
    protected static final String PREF_INTERNAL_WEB_BROWSER_OLD_FAVORITES = "internalWebBrowserOldFavorites";
    protected static final String URL_PARAMETER = "%URL%";

    private WebBrowserPreference() {
    }

    public static String getHomePageURL() {
        try {
            URL url = WebBrowserUIPlugin.getInstance().getBundle().getEntry("home/home.html");
            url = Platform.resolve((URL)url);
            return url.toExternalForm();
        }
        catch (Exception exception) {
            return "http://www.eclipse.org";
        }
    }

    protected static IPreferenceStore getPreferenceStore() {
        return WebBrowserUIPlugin.getInstance().getPreferenceStore();
    }

    public static List getInternalWebBrowserHistory() {
        String temp = WebBrowserPreference.getPreferenceStore().getString(PREF_INTERNAL_WEB_BROWSER_HISTORY);
        StringTokenizer st = new StringTokenizer(temp, "|*|");
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            l.add(s);
        }
        return l;
    }

    public static List getInternalWebBrowserFavorites() {
        String temp = WebBrowserPreference.getPreferenceStore().getString(PREF_INTERNAL_WEB_BROWSER_FAVORITES);
        StringTokenizer st = new StringTokenizer(temp, "|*|");
        ArrayList<Favorite> l = new ArrayList<Favorite>();
        try {
            while (st.hasMoreTokens()) {
                l.add(new Favorite(st.nextToken(), st.nextToken()));
            }
        }
        catch (Exception exception) {}
        return l;
    }

    public static void initializeDefaultPreferences() {
        IPreferenceStore store = WebBrowserPreference.getPreferenceStore();
        String temp = store.getString(PREF_INTERNAL_WEB_BROWSER_OLD_FAVORITES);
        StringTokenizer st = new StringTokenizer(temp, "|*|");
        ArrayList<Favorite> def = new ArrayList<Favorite>();
        try {
            while (st.hasMoreTokens()) {
                def.add(new Favorite(st.nextToken(), st.nextToken()));
            }
        }
        catch (Exception exception) {}
        List list = WebBrowserPreference.getInternalWebBrowserFavorites();
        Iterator iterator = WebBrowserUtil.getUnlockedFavorites().iterator();
        while (iterator.hasNext()) {
            Favorite f = (Favorite)iterator.next();
            if (def.contains(f)) continue;
            list.add(f);
        }
        WebBrowserPreference.setInternalWebBrowserFavorites(list);
        StringBuffer sb = new StringBuffer();
        iterator = WebBrowserUtil.getUnlockedFavorites().iterator();
        while (iterator.hasNext()) {
            Favorite f = (Favorite)iterator.next();
            sb.append(f.getName());
            sb.append("|*|");
            sb.append(f.getURL());
            sb.append("|*|");
        }
        store.setValue(PREF_INTERNAL_WEB_BROWSER_OLD_FAVORITES, sb.toString());
        WebBrowserUIPlugin.getInstance().savePluginPreferences();
    }

    public static void setInternalWebBrowserHistory(List list) {
        StringBuffer sb = new StringBuffer();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                sb.append(s);
                sb.append("|*|");
            }
        }
        WebBrowserPreference.getPreferenceStore().setValue(PREF_INTERNAL_WEB_BROWSER_HISTORY, sb.toString());
        WebBrowserUIPlugin.getInstance().savePluginPreferences();
    }

    public static void setInternalWebBrowserFavorites(List list) {
        StringBuffer sb = new StringBuffer();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Favorite f = (Favorite)iterator.next();
                sb.append(f.getName());
                sb.append("|*|");
                sb.append(f.getURL());
                sb.append("|*|");
            }
        }
        WebBrowserPreference.getPreferenceStore().setValue(PREF_INTERNAL_WEB_BROWSER_FAVORITES, sb.toString());
        WebBrowserUIPlugin.getInstance().savePluginPreferences();
    }
}

