/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.internal.preferences;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.sourceforge.phpeclipse.ui.ColorEditor;
import net.sourceforge.phpeclipse.ui.preferences.OverlayPreferenceStore;
import net.sourceforge.phpeclipse.ui.preferences.PreferenceDescriptor;
import net.sourceforge.phpeclipse.xml.ui.XMLPlugin;
import net.sourceforge.phpeclipse.xml.ui.internal.text.XMLConfiguration;
import net.sourceforge.phpeclipse.xml.ui.text.XMLTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class XMLSyntaxPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public final PreferenceDescriptor[] fKeys = new PreferenceDescriptor[]{new PreferenceDescriptor(PreferenceDescriptor.BOOLEAN, "AbstractTextEditor.Color.Background.SystemDefault"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "AbstractTextEditor.Color.Background"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_text_foreground"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_text_style"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_tag_foreground"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_tag_style"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_attribute_foreground"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_attribute_style"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_string_foreground"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_string_style"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_entity_foreground"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_entity_style"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_cdata_foreground"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_cdata_style"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_processing_instruction_foreground"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_processing_instruction_style"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_comment_foreground"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_comment_style"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_declaration_foreground"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_declaration_style"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_smarty_foreground"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_smarty_style"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_conditional_foreground"), new PreferenceDescriptor(PreferenceDescriptor.STRING, "xml_conditional_style")};
    OverlayPreferenceStore overlay;
    final String[][] fSyntaxColorListModel = new String[][]{{XMLPlugin.getResourceString("XmlSyntaxPreferencePage.others"), "xml_text"}, {XMLPlugin.getResourceString("XmlSyntaxPreferencePage.Tag"), "xml_tag"}, {XMLPlugin.getResourceString("XmlSyntaxPreferencePage.AttName"), "xml_attribute"}, {XMLPlugin.getResourceString("XmlSyntaxPreferencePage.AttValue"), "xml_string"}, {XMLPlugin.getResourceString("XmlSyntaxPreferencePage.Entity"), "xml_entity"}, {XMLPlugin.getResourceString("XmlSyntaxPreferencePage.CDATA"), "xml_cdata"}, {XMLPlugin.getResourceString("XmlSyntaxPreferencePage.PI"), "xml_processing_instruction"}, {XMLPlugin.getResourceString("XmlSyntaxPreferencePage.Comment"), "xml_comment"}, {XMLPlugin.getResourceString("XmlSyntaxPreferencePage.Declaration"), "xml_declaration"}, {XMLPlugin.getResourceString("XmlSyntaxPreferencePage.Conditional"), "xml_smarty"}, {XMLPlugin.getResourceString("XmlSyntaxPreferencePage.SmartyTag"), "xml_conditional"}};
    private XMLTextTools xmlTextTools;
    private Color bgColor;
    Button bgDefault;
    Button bgCustom;
    ColorEditor bgColorEditor;
    List colors;
    ColorEditor fgColorEditor;
    Button fgBold;
    SourceViewer preview;
    static /* synthetic */ Class class$0;

    public XMLSyntaxPreferencePage() {
        this.setDescription(XMLPlugin.getResourceString("XmlSyntaxPreferencePage.description"));
        this.setPreferenceStore(XMLPlugin.getDefault().getPreferenceStore());
        this.overlay = new OverlayPreferenceStore(this.getPreferenceStore(), this.fKeys);
    }

    protected Control createContents(Composite parent) {
        this.overlay.load();
        this.overlay.start();
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Group backgroundComposite = new Group(colorComposite, 16);
        backgroundComposite.setLayout((Layout)new RowLayout());
        backgroundComposite.setText(XMLPlugin.getResourceString("XmlSyntaxPreferencePage.backgroundColor"));
        SelectionListener backgroundSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean custom = XMLSyntaxPreferencePage.this.bgCustom.getSelection();
                XMLSyntaxPreferencePage.this.bgColorEditor.getButton().setEnabled(custom);
                XMLSyntaxPreferencePage.this.overlay.setValue("AbstractTextEditor.Color.Background.SystemDefault", !custom);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.bgDefault = new Button((Composite)backgroundComposite, 16400);
        this.bgDefault.setText(XMLPlugin.getResourceString("XmlSyntaxPreferencePage.systemDefault"));
        this.bgDefault.addSelectionListener(backgroundSelectionListener);
        this.bgCustom = new Button((Composite)backgroundComposite, 16400);
        this.bgCustom.setText(XMLPlugin.getResourceString("XmlSyntaxPreferencePage.custom"));
        this.bgCustom.addSelectionListener(backgroundSelectionListener);
        this.bgColorEditor = new ColorEditor((Composite)backgroundComposite);
        Label label = new Label(colorComposite, 16384);
        label.setText(XMLPlugin.getResourceString("XmlSyntaxPreferencePage.foreground"));
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        editorComposite.setLayoutData((Object)gd);
        this.colors = new List(editorComposite, 2564);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.colors.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(stylesComposite, 16384);
        label.setText(XMLPlugin.getResourceString("XmlSyntaxPreferencePage.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fgColorEditor = new ColorEditor(stylesComposite);
        Button fgColorButton = this.fgColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        fgColorButton.setLayoutData((Object)gd);
        label = new Label(stylesComposite, 16384);
        label.setText(XMLPlugin.getResourceString("XmlSyntaxPreferencePage.bold"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fgBold = new Button(stylesComposite, 32);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        this.fgBold.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setText(XMLPlugin.getResourceString("XmlSyntaxPreferencePage.preview"));
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewer.setLayoutData((Object)gd);
        this.colors.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                XMLSyntaxPreferencePage.this.handleSyntaxColorListSelection();
            }
        });
        this.bgColorEditor.getButton().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferenceConverter.setValue((IPreferenceStore)XMLSyntaxPreferencePage.this.overlay, (String)"AbstractTextEditor.Color.Background", (RGB)XMLSyntaxPreferencePage.this.bgColorEditor.getColorValue());
            }
        });
        fgColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = XMLSyntaxPreferencePage.this.colors.getSelectionIndex();
                String key = XMLSyntaxPreferencePage.this.fSyntaxColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)XMLSyntaxPreferencePage.this.overlay, (String)(String.valueOf(key) + "_foreground"), (RGB)XMLSyntaxPreferencePage.this.fgColorEditor.getColorValue());
            }
        });
        this.fgBold.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = XMLSyntaxPreferencePage.this.colors.getSelectionIndex();
                String key = XMLSyntaxPreferencePage.this.fSyntaxColorListModel[i][1];
                String value = XMLSyntaxPreferencePage.this.fgBold.getSelection() ? "bold" : "normal";
                XMLSyntaxPreferencePage.this.overlay.setValue(String.valueOf(key) + "_style", value);
            }
        });
        this.initialize();
        return colorComposite;
    }

    private Control createPreviewer(Composite parent) {
        this.xmlTextTools = new XMLTextTools((IPreferenceStore)this.overlay);
        this.preview = new SourceViewer(parent, null, 2816);
        this.preview.configure((SourceViewerConfiguration)new XMLConfiguration(this.xmlTextTools));
        this.preview.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.preview.setEditable(false);
        this.initializeViewerColors((ISourceViewer)this.preview);
        String content = this.loadPreviewContentFromFile("preview.xml");
        Document document = new Document(content);
        IDocumentPartitioner partitioner = this.xmlTextTools.createXMLPartitioner();
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner(partitioner);
        this.preview.setDocument((IDocument)document);
        this.overlay.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String p = event.getProperty();
                if (p.equals("AbstractTextEditor.Color.Background") || p.equals("AbstractTextEditor.Color.Background.SystemDefault")) {
                    XMLSyntaxPreferencePage.this.initializeViewerColors((ISourceViewer)XMLSyntaxPreferencePage.this.preview);
                }
                XMLSyntaxPreferencePage.this.preview.invalidateTextPresentation();
            }
        });
        return this.preview.getControl();
    }

    void initializeViewerColors(ISourceViewer viewer) {
        if (this.overlay != null) {
            StyledText styledText = viewer.getTextWidget();
            Color color = null;
            if (!this.overlay.getBoolean("AbstractTextEditor.Color.Background.SystemDefault")) {
                color = this.createColor((IPreferenceStore)this.overlay, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            }
            styledText.setBackground(color);
            if (this.bgColor != null) {
                this.bgColor.dispose();
            }
            this.bgColor = color;
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    void handleSyntaxColorListSelection() {
        int i = this.colors.getSelectionIndex();
        String key = this.fSyntaxColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.overlay, (String)(String.valueOf(key) + "_foreground"));
        this.fgColorEditor.setColorValue(rgb);
        this.fgBold.setSelection(this.overlay.getString(String.valueOf(key) + "_style").indexOf("bold") >= 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadPreviewContentFromFile(String filename) {
        StringBuffer string = new StringBuffer(512);
        try {
            char[] buf = new char[512];
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("net.sourceforge.phpeclipse.xml.ui.internal.preferences.XMLSyntaxPreferencePage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(clazz.getResourceAsStream(filename)));
            try {
                int n;
                while ((n = reader.read(buf)) >= 0) {
                    string.append(buf, 0, n);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                reader.close();
                throw throwable;
            }
            {
                Object var6_8 = null;
                reader.close();
                return string.toString();
            }
        }
        catch (IOException iOException) {}
        return string.toString();
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        while (i < this.fSyntaxColorListModel.length) {
            this.colors.add(this.fSyntaxColorListModel[i][0]);
            ++i;
        }
        this.colors.getDisplay().asyncExec(new Runnable(){

            public void run() {
                XMLSyntaxPreferencePage.this.colors.select(0);
                XMLSyntaxPreferencePage.this.handleSyntaxColorListSelection();
            }
        });
    }

    private void initializeFields() {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.overlay, (String)"AbstractTextEditor.Color.Background");
        this.bgColorEditor.setColorValue(rgb);
        boolean def = this.overlay.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        this.bgDefault.setSelection(def);
        this.bgCustom.setSelection(!def);
        this.bgColorEditor.getButton().setEnabled(!def);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.overlay.loadDefaults();
        this.handleSyntaxColorListSelection();
        super.performDefaults();
        this.preview.invalidateTextPresentation();
    }

    public boolean performOk() {
        this.overlay.propagate();
        XMLPlugin.getDefault().savePluginPreferences();
        return true;
    }

    public void dispose() {
        if (this.xmlTextTools != null) {
            this.xmlTextTools.dispose();
            this.xmlTextTools = null;
        }
        if (this.overlay != null) {
            this.overlay.stop();
            this.overlay = null;
        }
        super.dispose();
    }
}

