/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.text;

import java.util.Map;
import net.sourceforge.phpeclipse.ui.text.AbstractTextTools;
import net.sourceforge.phpeclipse.xml.ui.internal.text.DeclScanner;
import net.sourceforge.phpeclipse.xml.ui.internal.text.PHPXMLPartitionScanner;
import net.sourceforge.phpeclipse.xml.ui.internal.text.SingleTokenScanner;
import net.sourceforge.phpeclipse.xml.ui.internal.text.TextScanner;
import net.sourceforge.phpeclipse.xml.ui.internal.text.XMLCDATAScanner;
import net.sourceforge.phpeclipse.xml.ui.internal.text.XMLPartitionScanner;
import net.sourceforge.phpeclipse.xml.ui.internal.text.XMLTagScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;

public class XMLTextTools
extends AbstractTextTools {
    public static final String[] TOKENS = new String[]{"xml_text", "xml_tag", "xml_attribute", "xml_string", "xml_entity", "xml_processing_instruction", "xml_cdata", "xml_comment", "xml_smarty", "xml_declaration"};
    public static final String[] TYPES = new String[]{"__xml_processing_instruction", "__xml_comment", "__xml_declaration", "__xml_tag", "__xml_attribute", "__xml_cdata", "__dtd_internal", "__dtd_internal_pi", "__dtd_internal_comment", "__dtd_internal_declaration"};
    private XMLPartitionScanner xmlPartitionScanner = new XMLPartitionScanner(false);
    private PHPXMLPartitionScanner phpXMLPartitionScanner = new PHPXMLPartitionScanner(false);
    private TextScanner xmlTextScanner;
    private TextScanner dtdTextScanner;
    private XMLTagScanner xmlTagScanner;
    private TextScanner xmlAttributeScanner;
    private XMLCDATAScanner xmlCDATAScanner;
    private SingleTokenScanner xmlPIScanner;
    private SingleTokenScanner xmlCommentScanner;
    private DeclScanner xmlDeclScanner;

    public XMLTextTools(IPreferenceStore store) {
        this(store, TOKENS);
    }

    public XMLTextTools(IPreferenceStore store, String[] strTokens) {
        super(store, strTokens);
        Map tokens = this.getTokens();
        this.xmlTextScanner = new TextScanner(tokens, '&', "xml_text");
        this.dtdTextScanner = new TextScanner(tokens, '%', "xml_text");
        this.xmlPIScanner = new SingleTokenScanner(tokens, "xml_processing_instruction");
        this.xmlCommentScanner = new SingleTokenScanner(tokens, "xml_comment");
        this.xmlDeclScanner = new DeclScanner(tokens);
        this.xmlTagScanner = new XMLTagScanner(tokens);
        this.xmlAttributeScanner = new TextScanner(tokens, '&', "xml_string");
        this.xmlCDATAScanner = new XMLCDATAScanner(tokens);
    }

    public IDocumentPartitioner createXMLPartitioner() {
        return new DefaultPartitioner((IPartitionTokenScanner)this.xmlPartitionScanner, TYPES);
    }

    public IDocumentPartitioner createPHPXMLPartitioner() {
        return new DefaultPartitioner((IPartitionTokenScanner)this.phpXMLPartitionScanner, TYPES);
    }

    public RuleBasedScanner getXMLTextScanner() {
        return this.xmlTextScanner;
    }

    public RuleBasedScanner getDTDTextScanner() {
        return this.dtdTextScanner;
    }

    public RuleBasedScanner getXMLTagScanner() {
        return this.xmlTagScanner;
    }

    public RuleBasedScanner getXMLAttributeScanner() {
        return this.xmlAttributeScanner;
    }

    public ITokenScanner getXMLCDATAScanner() {
        return this.xmlCDATAScanner;
    }

    public RuleBasedScanner getXMLPIScanner() {
        return this.xmlPIScanner;
    }

    public RuleBasedScanner getXMLCommentScanner() {
        return this.xmlCommentScanner;
    }

    public RuleBasedScanner getXMLDeclScanner() {
        return this.xmlDeclScanner;
    }
}

