/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.ArrayInitializer;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.TypeReference;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.ArrayBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class ArrayAllocationExpression
extends Expression {
    public TypeReference type;
    public Expression[] dimensions;
    public ArrayInitializer initializer;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        int i = 0;
        int max = this.dimensions.length;
        while (i < max) {
            Expression dim = this.dimensions[i];
            if (dim != null) {
                flowInfo = dim.analyseCode(currentScope, flowContext, flowInfo);
            }
            ++i;
        }
        if (this.initializer != null) {
            return this.initializer.analyseCode(currentScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append("new ");
        this.type.print(0, output);
        int i = 0;
        while (i < this.dimensions.length) {
            if (this.dimensions[i] == null) {
                output.append("[]");
            } else {
                output.append('[');
                this.dimensions[i].printExpression(0, output);
                output.append(']');
            }
            ++i;
        }
        if (this.initializer != null) {
            this.initializer.printExpression(0, output);
        }
        return output;
    }

    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding referenceType = this.type.resolveType(scope);
        this.constant = Constant.NotAConstant;
        if (referenceType == VoidBinding) {
            scope.problemReporter().cannotAllocateVoidArray(this);
            referenceType = null;
        }
        int explicitDimIndex = -1;
        int i = this.dimensions.length;
        while (--i >= 0) {
            if (this.dimensions[i] != null) {
                if (explicitDimIndex >= 0) continue;
                explicitDimIndex = i;
                continue;
            }
            if (explicitDimIndex <= 0) continue;
            scope.problemReporter().incorrectLocationForEmptyDimension(this, i);
        }
        if (this.initializer == null) {
            if (explicitDimIndex < 0) {
                scope.problemReporter().mustDefineDimensionsOrInitializer(this);
            }
        } else if (explicitDimIndex >= 0) {
            scope.problemReporter().cannotDefineDimensionsAndInitializer(this);
        }
        i = 0;
        while (i <= explicitDimIndex) {
            TypeBinding dimensionType;
            if (this.dimensions[i] != null && (dimensionType = this.dimensions[i].resolveTypeExpecting(scope, IntBinding)) != null) {
                this.dimensions[i].implicitWidening(IntBinding, dimensionType);
            }
            ++i;
        }
        if (referenceType != null) {
            if (this.dimensions.length > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            this.resolvedType = scope.createArray(referenceType, this.dimensions.length);
            if (this.initializer != null && this.initializer.resolveTypeExpecting(scope, this.resolvedType) != null) {
                this.initializer.binding = (ArrayBinding)this.resolvedType;
            }
        }
        return this.resolvedType;
    }

    public String toStringExpression() {
        String s = "new " + this.type.toString(0);
        int i = 0;
        while (i < this.dimensions.length) {
            s = this.dimensions[i] == null ? String.valueOf(s) + "[]" : String.valueOf(s) + "[" + this.dimensions[i].toStringExpression() + "]";
            ++i;
        }
        if (this.initializer != null) {
            s = String.valueOf(s) + this.initializer.toStringExpression();
        }
        return s;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int dimensionsLength = this.dimensions.length;
            this.type.traverse(visitor, scope);
            int i = 0;
            while (i < dimensionsLength) {
                if (this.dimensions[i] != null) {
                    this.dimensions[i].traverse(visitor, scope);
                }
                ++i;
            }
            if (this.initializer != null) {
                this.initializer.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }
}

