/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.lookup.ArrayBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.BaseTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class ArrayInitializer
extends Expression {
    public Expression[] expressions;
    public ArrayBinding binding;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.expressions != null) {
            int i = 0;
            int max = this.expressions.length;
            while (i < max) {
                flowInfo = this.expressions[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                ++i;
            }
        }
        return flowInfo;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('{');
        if (this.expressions != null) {
            int j = 20;
            int i = 0;
            while (i < this.expressions.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.expressions[i].printExpression(0, output);
                if (--j == 0) {
                    output.append('\n');
                    ArrayInitializer.printIndent(indent + 1, output);
                    j = 20;
                }
                ++i;
            }
        }
        return output.append('}');
    }

    public TypeBinding resolveTypeExpecting(BlockScope scope, TypeBinding expectedTb) {
        this.constant = NotAConstant;
        if (expectedTb.isArrayType()) {
            this.binding = (ArrayBinding)expectedTb;
            if (this.expressions == null) {
                return this.binding;
            }
            TypeBinding expectedElementsTb = this.binding.elementsType(scope);
            if (expectedElementsTb.isBaseType()) {
                int i = 0;
                int length = this.expressions.length;
                while (i < length) {
                    TypeBinding expressionTb;
                    Expression expression = this.expressions[i];
                    TypeBinding typeBinding = expressionTb = expression instanceof ArrayInitializer ? expression.resolveTypeExpecting(scope, expectedElementsTb) : expression.resolveType(scope);
                    if (expressionTb == null) {
                        return null;
                    }
                    if (expression.isConstantValueOfTypeAssignableToType(expressionTb, expectedElementsTb)) {
                        expression.implicitWidening(expectedElementsTb, expressionTb);
                    } else if (BaseTypeBinding.isWidening(expectedElementsTb.id, expressionTb.id)) {
                        expression.implicitWidening(expectedElementsTb, expressionTb);
                    } else {
                        scope.problemReporter().typeMismatchErrorActualTypeExpectedType(expression, expressionTb, expectedElementsTb);
                        return null;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                int length = this.expressions.length;
                while (i < length) {
                    if (this.expressions[i].resolveTypeExpecting(scope, expectedElementsTb) == null) {
                        return null;
                    }
                    ++i;
                }
            }
            return this.binding;
        }
        TypeBinding leafElementType = null;
        int dim = 1;
        if (this.expressions == null) {
            leafElementType = scope.getJavaLangObject();
        } else {
            Expression currentExpression = this.expressions[0];
            while (currentExpression != null && currentExpression instanceof ArrayInitializer) {
                ++dim;
                Expression[] subExprs = ((ArrayInitializer)currentExpression).expressions;
                if (subExprs == null) {
                    leafElementType = scope.getJavaLangObject();
                    currentExpression = null;
                    break;
                }
                currentExpression = ((ArrayInitializer)currentExpression).expressions[0];
            }
            if (currentExpression != null) {
                leafElementType = currentExpression.resolveType(scope);
            }
        }
        if (leafElementType != null) {
            ArrayBinding probableTb = scope.createArray(leafElementType, dim);
            scope.problemReporter().typeMismatchErrorActualTypeExpectedType(this, probableTb, expectedTb);
        }
        return null;
    }

    public String toStringExpression() {
        String s = "{";
        if (this.expressions != null) {
            int j = 20;
            int i = 0;
            while (i < this.expressions.length) {
                s = String.valueOf(s) + this.expressions[i].toStringExpression() + ",";
                if (--j == 0) {
                    s = String.valueOf(s) + "\n                ";
                    j = 20;
                }
                ++i;
            }
        }
        s = String.valueOf(s) + "}";
        return s;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.expressions != null) {
            int expressionsLength = this.expressions.length;
            int i = 0;
            while (i < expressionsLength) {
                this.expressions[i].traverse(visitor, scope);
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }
}

