/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Assignment;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Reference;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.ArrayBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class ArrayReference
extends Reference {
    public Expression receiver;
    public Expression position;

    public ArrayReference(Expression rec, Expression pos) {
        this.receiver = rec;
        this.position = pos;
        this.sourceStart = rec.sourceStart;
    }

    public FlowInfo analyseAssignment(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean compoundAssignment) {
        if (assignment.expression == null) {
            return this.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        }
        return assignment.expression.analyseCode(currentScope, flowContext, this.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits()).unconditionalInits();
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.position.analyseCode(currentScope, flowContext, this.receiver.analyseCode(currentScope, flowContext, flowInfo));
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        this.receiver.printExpression(0, output).append('[');
        return this.position.printExpression(0, output).append(']');
    }

    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding positionType;
        this.constant = Constant.NotAConstant;
        TypeBinding arrayType = this.receiver.resolveType(scope);
        if (arrayType != null) {
            if (arrayType.isArrayType()) {
                this.resolvedType = ((ArrayBinding)arrayType).elementsType(scope);
            } else {
                scope.problemReporter().referenceMustBeArrayTypeAt(arrayType, this);
            }
        }
        if ((positionType = this.position.resolveTypeExpecting(scope, IntBinding)) != null) {
            this.position.implicitWidening(IntBinding, positionType);
        }
        return this.resolvedType;
    }

    public String toStringExpression() {
        return String.valueOf(this.receiver.toStringExpression()) + "[" + this.position.toStringExpression() + "]";
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.receiver.traverse(visitor, scope);
            this.position.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

