/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class IfStatement
extends Statement {
    public Expression condition;
    public Statement thenStatement;
    public Statement elseStatement;
    public Expression[] elseifConditions;
    public Statement[] elseifStatements;
    public boolean checkUnreachable;
    boolean thenExit;
    int thenInitStateIndex = -1;
    int elseInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public IfStatement(Expression condition, Statement thenStatement, int s, int e) {
        this.condition = condition;
        this.thenStatement = thenStatement;
        this.sourceStart = s;
        this.sourceEnd = e;
        this.checkUnreachable = true;
    }

    public IfStatement(Expression condition, Statement thenStatement, Statement elseStatement, int s, int e) {
        this.condition = condition;
        this.thenStatement = thenStatement;
        this.elseStatement = elseStatement;
        this.sourceEnd = e;
        this.sourceStart = s;
        this.checkUnreachable = true;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        boolean elseExit;
        flowInfo = this.condition.analyseCode(currentScope, flowContext, flowInfo);
        Constant cst = this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst != NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != NotAConstant && !cst.booleanValue();
        FlowInfo thenFlowInfo = flowInfo.initsWhenTrue().copy();
        if (isConditionOptimizedFalse) {
            thenFlowInfo.setReachMode(1);
        }
        if (this.thenStatement != null) {
            this.thenInitStateIndex = currentScope.methodScope().recordInitializationStates(thenFlowInfo);
            if (!thenFlowInfo.complainIfUnreachable(this.thenStatement, currentScope, false)) {
                thenFlowInfo = this.thenStatement.analyseCode(currentScope, flowContext, thenFlowInfo);
            }
        }
        this.thenExit = !thenFlowInfo.isReachable();
        FlowInfo elseFlowInfo = flowInfo.initsWhenFalse().copy();
        if (isConditionOptimizedTrue) {
            elseFlowInfo.setReachMode(1);
        }
        if (this.elseStatement != null) {
            this.elseInitStateIndex = currentScope.methodScope().recordInitializationStates(elseFlowInfo);
            if (!elseFlowInfo.complainIfUnreachable(this.elseStatement, currentScope, false)) {
                elseFlowInfo = this.elseStatement.analyseCode(currentScope, flowContext, elseFlowInfo);
            }
        }
        boolean bl = elseExit = !elseFlowInfo.isReachable();
        FlowInfo mergedInfo = isConditionOptimizedTrue ? (!this.thenExit ? thenFlowInfo.addPotentialInitializationsFrom(elseFlowInfo) : elseFlowInfo.setReachMode(1)) : (isConditionOptimizedFalse ? (!elseExit ? elseFlowInfo.addPotentialInitializationsFrom(thenFlowInfo) : thenFlowInfo.setReachMode(1)) : thenFlowInfo.mergedWith(elseFlowInfo.unconditionalInits()));
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        IfStatement.printIndent(indent, output).append("if (");
        this.condition.printExpression(0, output).append(")\n");
        this.thenStatement.printStatement(indent + 2, output);
        if (this.elseStatement != null) {
            output.append('\n');
            IfStatement.printIndent(indent, output);
            output.append("else\n");
            this.elseStatement.printStatement(indent + 2, output);
        }
        return output;
    }

    public void resolve(BlockScope scope) {
        TypeBinding type = this.condition.resolveTypeExpecting(scope, BooleanBinding);
        this.condition.implicitWidening(type, type);
        if (this.thenStatement != null) {
            this.thenStatement.resolve(scope);
        }
        if (this.elseStatement != null) {
            this.elseStatement.resolve(scope);
        }
    }

    public String toString(int tab) {
        String s;
        String inFront = s = IfStatement.tabString(tab);
        s = String.valueOf(s) + "if (" + this.condition.toStringExpression() + ") \n";
        s = String.valueOf(s) + this.thenStatement.toString(tab + 2) + ";";
        if (this.elseStatement != null) {
            s = String.valueOf(s) + "\n" + inFront + "else\n" + this.elseStatement.toString(tab + 2) + ";";
        }
        return s;
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.condition.traverse(visitor, blockScope);
            if (this.thenStatement != null) {
                this.thenStatement.traverse(visitor, blockScope);
            }
            if (this.elseStatement != null) {
                this.elseStatement.traverse(visitor, blockScope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

