/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.ASTNode;
import net.sourceforge.phpdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.core.resources.IFile;

public class ImportReference
extends ASTNode {
    public char[][] tokens;
    public boolean onDemand = true;
    public final char[] includeSource;
    public int declarationEnd;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public boolean used;
    private IFile fFile;

    public ImportReference(char[][] sources, char[] sourceString, int start, int end, boolean d) {
        this.tokens = sources;
        this.includeSource = sourceString;
        this.onDemand = d;
        this.sourceEnd = end;
        this.sourceStart = start;
        this.fFile = null;
    }

    public char[][] getImportName() {
        return this.tokens;
    }

    public char[] getIncludeName() {
        return this.includeSource;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        return this.print(indent, output, true);
    }

    public StringBuffer print(int tab, StringBuffer output, boolean withOnDemand) {
        int i = 0;
        while (i < this.tokens.length) {
            if (i > 0) {
                output.append('.');
            }
            output.append(this.tokens[i]);
            ++i;
        }
        if (withOnDemand && this.onDemand) {
            output.append(".*");
        }
        return output;
    }

    public String toString(int tab) {
        return this.toString(tab, true);
    }

    public String toString(int tab, boolean withOnDemand) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.tokens.length) {
            buffer.append(this.tokens[i]);
            if (i < this.tokens.length - 1) {
                buffer.append(".");
            }
            ++i;
        }
        if (withOnDemand && this.onDemand) {
            buffer.append(".*");
        }
        buffer.append(" - ");
        buffer.append(this.includeSource);
        return buffer.toString();
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    public IFile getFile() {
        return this.fFile;
    }

    public void setFile(IFile filePath) {
        this.fFile = filePath;
    }
}

