/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.NumberLiteral;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.impl.DoubleConstant;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class IntLiteral
extends NumberLiteral {
    public int value;
    public static final IntLiteral One = new IntLiteral(new char[]{'1'}, 0, 0, 1);
    static final Constant FORMAT_ERROR = new DoubleConstant(Double.POSITIVE_INFINITY);

    public IntLiteral(char[] token, int s, int e) {
        super(token, s, e);
    }

    public IntLiteral(char[] token, int s, int e, int value) {
        this(token, s, e);
        this.value = value;
    }

    public IntLiteral(int intValue) {
        super(null, 0, 0);
        this.constant = Constant.fromValue(intValue);
        this.value = intValue;
    }

    public void computeConstant() {
        long MAX = Integer.MAX_VALUE;
        if (this == One) {
            this.constant = Constant.One;
            return;
        }
        int length = this.source.length;
        long computedValue = 0L;
        if (this.source[0] == '0') {
            int radix;
            int j;
            int shift;
            MAX = 0xFFFFFFFFL;
            if (length == 1) {
                this.constant = Constant.fromValue(0);
                return;
            }
            if (this.source[1] == 'x' | this.source[1] == 'X') {
                shift = 4;
                j = 2;
                radix = 16;
            } else {
                shift = 3;
                j = 1;
                radix = 8;
            }
            while (this.source[j] == '0') {
                if (++j != length) continue;
                this.value = (int)computedValue;
                this.constant = Constant.fromValue(this.value);
                return;
            }
            while (j < length) {
                int digitValue;
                if ((digitValue = Character.digit(this.source[j++], radix)) < 0) {
                    this.constant = FORMAT_ERROR;
                    return;
                }
                if ((computedValue = computedValue << shift | (long)digitValue) <= MAX) continue;
                return;
            }
        } else {
            int i = 0;
            while (i < length) {
                int digitValue = Character.digit(this.source[i], 10);
                if (digitValue < 0) {
                    this.constant = FORMAT_ERROR;
                    return;
                }
                if ((computedValue = 10L * computedValue + (long)digitValue) > MAX) {
                    return;
                }
                ++i;
            }
        }
        this.value = (int)computedValue;
        this.constant = Constant.fromValue(this.value);
    }

    public TypeBinding literalType(BlockScope scope) {
        return IntBinding;
    }

    public final boolean mayRepresentMIN_VALUE() {
        return this.source.length == 10 && this.source[0] == '2' && this.source[1] == '1' && this.source[2] == '4' && this.source[3] == '7' && this.source[4] == '4' && this.source[5] == '8' && this.source[6] == '3' && this.source[7] == '6' && this.source[8] == '4' && this.source[9] == '8';
    }

    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding tb = super.resolveType(scope);
        if (this.constant == FORMAT_ERROR) {
            this.constant = NotAConstant;
            scope.problemReporter().constantOutOfFormat(this);
            this.resolvedType = null;
            return null;
        }
        return tb;
    }

    public String toStringExpression() {
        if (this.source == null) {
            return String.valueOf(this.value);
        }
        return super.toStringExpression();
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

