/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Assignment;
import net.sourceforge.phpdt.internal.compiler.ast.FieldReference;
import net.sourceforge.phpdt.internal.compiler.ast.NameReference;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.FieldBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.InvocationSite;
import net.sourceforge.phpdt.internal.compiler.lookup.LocalVariableBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodScope;
import net.sourceforge.phpdt.internal.compiler.lookup.ProblemFieldBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.ProblemReferenceBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.SourceTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.SyntheticAccessMethodBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.VariableBinding;

public class QualifiedNameReference
extends NameReference {
    public char[][] tokens;
    public FieldBinding[] otherBindings;
    public FieldBinding[] otherCodegenBindings;
    int[] otherDepths;
    public int indexOfFirstFieldBinding;
    SyntheticAccessMethodBinding syntheticWriteAccessor;
    SyntheticAccessMethodBinding[] syntheticReadAccessors;
    protected FieldBinding lastFieldBinding;

    public QualifiedNameReference(char[][] sources, int sourceStart, int sourceEnd) {
        this.tokens = sources;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseAssignment(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean isCompound) {
        int otherBindingsCount = this.otherBindings == null ? 0 : this.otherBindings.length;
        boolean needValue = otherBindingsCount == 0 || !this.otherBindings[0].isStatic();
        switch (this.bits & 7) {
            case 1: {
                this.lastFieldBinding = (FieldBinding)this.binding;
                if (needValue) {
                    this.manageSyntheticReadAccessIfNecessary(currentScope, this.lastFieldBinding, this.actualReceiverType, 0);
                }
                if (!this.lastFieldBinding.isBlankFinal() || this.otherBindings == null || !currentScope.allowBlankFinalFieldAssignment(this.lastFieldBinding) || flowInfo.isDefinitelyAssigned(this.lastFieldBinding)) break;
                currentScope.problemReporter().uninitializedBlankFinalField(this.lastFieldBinding, this);
            }
        }
        if (needValue) {
            this.manageEnclosingInstanceAccessIfNecessary(currentScope);
        }
        if (this.otherBindings != null) {
            int i = 0;
            while (i < otherBindingsCount - 1) {
                this.lastFieldBinding = this.otherBindings[i];
                boolean bl = needValue = !this.otherBindings[i + 1].isStatic();
                if (needValue) {
                    this.manageSyntheticReadAccessIfNecessary(currentScope, this.lastFieldBinding, i == 0 ? ((VariableBinding)this.binding).type : this.otherBindings[i - 1].type, i + 1);
                }
                ++i;
            }
            this.lastFieldBinding = this.otherBindings[otherBindingsCount - 1];
        }
        if (isCompound) {
            if (this.binding == this.lastFieldBinding && this.lastFieldBinding.isBlankFinal() && currentScope.allowBlankFinalFieldAssignment(this.lastFieldBinding) && !flowInfo.isDefinitelyAssigned(this.lastFieldBinding)) {
                currentScope.problemReporter().uninitializedBlankFinalField(this.lastFieldBinding, this);
            }
            TypeBinding lastReceiverType = this.lastFieldBinding == this.binding ? this.actualReceiverType : (otherBindingsCount == 1 ? ((VariableBinding)this.binding).type : this.otherBindings[otherBindingsCount - 2].type);
            this.manageSyntheticReadAccessIfNecessary(currentScope, this.lastFieldBinding, lastReceiverType, this.lastFieldBinding == this.binding ? 0 : otherBindingsCount);
        }
        if (assignment.expression != null) {
            flowInfo = assignment.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        }
        if (this.lastFieldBinding.isFinal()) {
            if (this.lastFieldBinding.isBlankFinal() && !isCompound && currentScope.allowBlankFinalFieldAssignment(this.lastFieldBinding) && this.indexOfFirstFieldBinding == 1) {
                if (flowInfo.isPotentiallyAssigned(this.lastFieldBinding)) {
                    currentScope.problemReporter().duplicateInitializationOfBlankFinalField(this.lastFieldBinding, this);
                } else {
                    flowContext.recordSettingFinal(this.lastFieldBinding, this);
                }
                flowInfo.markAsDefinitelyAssigned(this.lastFieldBinding);
            } else {
                currentScope.problemReporter().cannotAssignToFinalField(this.lastFieldBinding, this);
                if (currentScope.allowBlankFinalFieldAssignment(this.lastFieldBinding)) {
                    flowInfo.markAsDefinitelyAssigned(this.lastFieldBinding);
                }
            }
        }
        TypeBinding lastReceiverType = this.lastFieldBinding == this.binding ? this.actualReceiverType : (otherBindingsCount == 1 ? ((VariableBinding)this.binding).type : this.otherBindings[otherBindingsCount - 2].type);
        this.manageSyntheticWriteAccessIfNecessary(currentScope, this.lastFieldBinding, lastReceiverType);
        return flowInfo;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.analyseCode(currentScope, flowContext, flowInfo, true);
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, boolean valueRequired) {
        int otherBindingsCount;
        int n = otherBindingsCount = this.otherBindings == null ? 0 : this.otherBindings.length;
        boolean needValue = otherBindingsCount == 0 ? valueRequired : !this.otherBindings[0].isStatic();
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding;
                if (needValue) {
                    this.manageSyntheticReadAccessIfNecessary(currentScope, (FieldBinding)this.binding, this.actualReceiverType, 0);
                }
                if (!(fieldBinding = (FieldBinding)this.binding).isBlankFinal() || this.indexOfFirstFieldBinding != 1 || !currentScope.allowBlankFinalFieldAssignment(fieldBinding) || flowInfo.isDefinitelyAssigned(fieldBinding)) break;
                currentScope.problemReporter().uninitializedBlankFinalField(fieldBinding, this);
            }
        }
        if (needValue) {
            this.manageEnclosingInstanceAccessIfNecessary(currentScope);
        }
        if (this.otherBindings != null) {
            int i = 0;
            while (i < otherBindingsCount) {
                boolean bl = i < otherBindingsCount - 1 ? !this.otherBindings[i + 1].isStatic() : (needValue = valueRequired);
                if (needValue) {
                    this.manageSyntheticReadAccessIfNecessary(currentScope, this.otherBindings[i], i == 0 ? ((VariableBinding)this.binding).type : this.otherBindings[i - 1].type, i + 1);
                }
                ++i;
            }
        }
        return flowInfo;
    }

    public TypeBinding checkFieldAccess(BlockScope scope) {
        FieldBinding fieldBinding = (FieldBinding)this.binding;
        MethodScope methodScope = scope.methodScope();
        if (methodScope.enclosingSourceType() == fieldBinding.declaringClass && methodScope.fieldDeclarationIndex != -1 && fieldBinding.id >= methodScope.fieldDeclarationIndex && (!fieldBinding.isStatic() || methodScope.isStatic) && this.indexOfFirstFieldBinding == 1) {
            scope.problemReporter().forwardReference(this, 0, scope.enclosingSourceType());
        }
        this.bits &= 0xFFFFFFF8;
        this.bits |= 1;
        return this.getOtherFieldBindings(scope);
    }

    public TypeBinding getOtherFieldBindings(BlockScope scope) {
        if ((this.bits & 1) != 0) {
            if (!((FieldBinding)this.binding).isStatic()) {
                if (this.indexOfFirstFieldBinding == 1) {
                    if (scope.methodScope().isStatic) {
                        scope.problemReporter().staticFieldAccessToNonStaticVariable(this, (FieldBinding)this.binding);
                        return null;
                    }
                } else {
                    scope.problemReporter().staticFieldAccessToNonStaticVariable(this, (FieldBinding)this.binding);
                    return null;
                }
            }
            if (this.isFieldUseDeprecated((FieldBinding)this.binding, scope)) {
                scope.problemReporter().deprecatedField((FieldBinding)this.binding, this);
            }
        }
        TypeBinding type = ((VariableBinding)this.binding).type;
        int index = this.indexOfFirstFieldBinding;
        int length = this.tokens.length;
        if (index == length) {
            this.constant = FieldReference.getConstantFor((FieldBinding)this.binding, this, false, scope);
            return type;
        }
        int otherBindingsLength = length - index;
        this.otherBindings = new FieldBinding[otherBindingsLength];
        this.otherCodegenBindings = this.otherBindings;
        this.otherDepths = new int[otherBindingsLength];
        this.constant = (this.bits & 1) != 0 ? FieldReference.getConstantFor((FieldBinding)this.binding, this, false, scope) : ((VariableBinding)this.binding).constant;
        int firstDepth = (this.bits & 0x1FE0) >> 5;
        while (index < length) {
            char[] token = this.tokens[index];
            if (type == null) {
                return null;
            }
            this.bits &= 0xFFFFE01F;
            FieldBinding field = scope.getField(type, token, this);
            int place = index - this.indexOfFirstFieldBinding;
            this.otherBindings[place] = field;
            this.otherDepths[place] = (this.bits & 0x1FE0) >> 5;
            if (field.isValidBinding()) {
                if (this.isFieldUseDeprecated(field, scope)) {
                    scope.problemReporter().deprecatedField(field, this);
                }
                Constant someConstant = FieldReference.getConstantFor(field, this, false, scope);
                if (this.constant != NotAConstant) {
                    this.constant = someConstant;
                }
                type = field.type;
                ++index;
                if (!field.isStatic()) continue;
                scope.problemReporter().unnecessaryReceiverForStaticField(this, field);
                continue;
            }
            this.constant = NotAConstant;
            scope.problemReporter().invalidField(this, field, index, type);
            this.setDepth(firstDepth);
            return null;
        }
        this.setDepth(firstDepth);
        return this.otherBindings[otherBindingsLength - 1].type;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope) {
        if ((this.bits & 0x1FE0) == 0 || this.constant != NotAConstant) {
            return;
        }
        if ((this.bits & 7) == 2) {
            currentScope.emulateOuterAccess((LocalVariableBinding)this.binding);
        }
    }

    public void manageSyntheticReadAccessIfNecessary(BlockScope currentScope, FieldBinding fieldBinding, TypeBinding lastReceiverType, int index) {
        if (fieldBinding.constant != NotAConstant) {
            return;
        }
        if (fieldBinding.isPrivate()) {
            if (fieldBinding.declaringClass != currentScope.enclosingSourceType()) {
                if (this.syntheticReadAccessors == null) {
                    this.syntheticReadAccessors = this.otherBindings == null ? new SyntheticAccessMethodBinding[1] : new SyntheticAccessMethodBinding[this.otherBindings.length + 1];
                }
                this.syntheticReadAccessors[index] = ((SourceTypeBinding)fieldBinding.declaringClass).addSyntheticMethod(fieldBinding, true);
                currentScope.problemReporter().needToEmulateFieldReadAccess(fieldBinding, this);
                return;
            }
        } else if (fieldBinding.isProtected()) {
            int depth;
            int n = depth = index == 0 ? (this.bits & 0x1FE0) >> 5 : this.otherDepths[index - 1];
            if (depth > 0 && fieldBinding.declaringClass.getPackage() != currentScope.enclosingSourceType().getPackage()) {
                if (this.syntheticReadAccessors == null) {
                    this.syntheticReadAccessors = this.otherBindings == null ? new SyntheticAccessMethodBinding[1] : new SyntheticAccessMethodBinding[this.otherBindings.length + 1];
                }
                this.syntheticReadAccessors[index] = ((SourceTypeBinding)currentScope.enclosingSourceType().enclosingTypeAt(depth)).addSyntheticMethod(fieldBinding, true);
                currentScope.problemReporter().needToEmulateFieldReadAccess(fieldBinding, this);
                return;
            }
        }
    }

    public void manageSyntheticWriteAccessIfNecessary(BlockScope currentScope, FieldBinding fieldBinding, TypeBinding lastReceiverType) {
        if (fieldBinding.isPrivate()) {
            if (fieldBinding.declaringClass != currentScope.enclosingSourceType()) {
                this.syntheticWriteAccessor = ((SourceTypeBinding)fieldBinding.declaringClass).addSyntheticMethod(fieldBinding, false);
                currentScope.problemReporter().needToEmulateFieldWriteAccess(fieldBinding, this);
                return;
            }
        } else if (fieldBinding.isProtected()) {
            int depth;
            int n = depth = fieldBinding == this.binding ? (this.bits & 0x1FE0) >> 5 : this.otherDepths[this.otherDepths.length - 1];
            if (depth > 0 && fieldBinding.declaringClass.getPackage() != currentScope.enclosingSourceType().getPackage()) {
                this.syntheticWriteAccessor = ((SourceTypeBinding)currentScope.enclosingSourceType().enclosingTypeAt(depth)).addSyntheticMethod(fieldBinding, false);
                currentScope.problemReporter().needToEmulateFieldWriteAccess(fieldBinding, this);
                return;
            }
        }
    }

    public TypeBinding reportError(BlockScope scope) {
        if (this.binding instanceof ProblemFieldBinding) {
            scope.problemReporter().invalidField(this, (FieldBinding)this.binding);
        } else if (this.binding instanceof ProblemReferenceBinding) {
            scope.problemReporter().invalidType(this, (TypeBinding)this.binding);
        } else {
            scope.problemReporter().unresolvableReference(this, this.binding);
        }
        return null;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        int i = 0;
        while (i < this.tokens.length) {
            if (i > 0) {
                output.append('.');
            }
            output.append(this.tokens[i]);
            ++i;
        }
        return output;
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.actualReceiverType = this.receiverType = scope.enclosingSourceType();
        this.constant = Constant.NotAConstant;
        this.codegenBinding = this.binding = scope.getBinding(this.tokens, this.bits & 7, (InvocationSite)this);
        if (this.binding.isValidBinding()) {
            switch (this.bits & 7) {
                case 3: 
                case 7: {
                    if (this.binding instanceof LocalVariableBinding) {
                        if (!((LocalVariableBinding)this.binding).isFinal() && (this.bits & 0x1FE0) != 0) {
                            scope.problemReporter().cannotReferToNonFinalOuterLocal((LocalVariableBinding)this.binding, this);
                        }
                        this.bits &= 0xFFFFFFF8;
                        this.bits |= 2;
                        this.resolvedType = this.getOtherFieldBindings(scope);
                        return this.resolvedType;
                    }
                    if (this.binding instanceof FieldBinding) {
                        FieldBinding fieldBinding = (FieldBinding)this.binding;
                        MethodScope methodScope = scope.methodScope();
                        if (methodScope.enclosingSourceType() == fieldBinding.declaringClass && methodScope.fieldDeclarationIndex != -1 && fieldBinding.id >= methodScope.fieldDeclarationIndex && (!fieldBinding.isStatic() || methodScope.isStatic) && this.indexOfFirstFieldBinding == 1) {
                            scope.problemReporter().forwardReference(this, 0, scope.enclosingSourceType());
                        }
                        this.bits &= 0xFFFFFFF8;
                        this.bits |= 1;
                        if (this.indexOfFirstFieldBinding > 1 && this.isTypeUseDeprecated(this.actualReceiverType, scope)) {
                            scope.problemReporter().deprecatedType(this.actualReceiverType, this);
                        }
                        this.resolvedType = this.getOtherFieldBindings(scope);
                        return this.resolvedType;
                    }
                    this.bits &= 0xFFFFFFF8;
                    this.bits |= 4;
                }
                case 4: {
                    if (this.isTypeUseDeprecated((TypeBinding)this.binding, scope)) {
                        scope.problemReporter().deprecatedType((TypeBinding)this.binding, this);
                    }
                    this.resolvedType = (TypeBinding)this.binding;
                    return this.resolvedType;
                }
            }
        }
        this.resolvedType = this.reportError(scope);
        return this.resolvedType;
    }

    public void setFieldIndex(int index) {
        this.indexOfFirstFieldBinding = index;
    }

    public String toStringExpression() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.tokens.length) {
            buffer.append(this.tokens[i]);
            if (i < this.tokens.length - 1) {
                buffer.append(".");
            }
            ++i;
        }
        return buffer.toString();
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    public String unboundReferenceErrorName() {
        return new String(this.tokens[0]);
    }
}

