/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.internal.compiler.env.ICompilationUnit;
import net.sourceforge.phpdt.internal.compiler.util.Util;
import org.eclipse.core.resources.IResource;

public class CompilationUnit
implements ICompilationUnit {
    public char[] contents;
    public char[] fileName;
    public char[] mainTypeName;
    String encoding;

    public CompilationUnit(char[] contents, String fileName, String encoding) {
        int end;
        this.contents = contents;
        if (File.separator.equals("/")) {
            if (fileName.indexOf("\\") != -1) {
                fileName = fileName.replace('\\', File.separatorChar);
            }
        } else if (fileName.indexOf(47) != -1) {
            fileName = fileName.replace('/', File.separatorChar);
        }
        this.fileName = fileName.toCharArray();
        int start = fileName.lastIndexOf("/") + 1;
        if (start == 0 || start < fileName.lastIndexOf("\\")) {
            start = fileName.lastIndexOf("\\") + 1;
        }
        if ((end = fileName.lastIndexOf(".")) == -1) {
            end = fileName.length();
        }
        this.mainTypeName = fileName.substring(start, end).toCharArray();
        this.encoding = encoding;
    }

    public char[] getContents() {
        if (this.contents != null) {
            return this.contents;
        }
        try {
            return Util.getFileCharContent(new File(new String(this.fileName)), this.encoding);
        }
        catch (IOException iOException) {
            return CharOperation.NO_CHAR;
        }
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public char[] getMainTypeName() {
        return this.mainTypeName;
    }

    public char[][] getPackageName() {
        return null;
    }

    public String toString() {
        return "CompilationUnit[" + new String(this.fileName) + "]";
    }

    public IResource getResource() {
        return null;
    }
}

