/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.batch;

import java.io.File;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.internal.compiler.batch.ClasspathDirectory;
import net.sourceforge.phpdt.internal.compiler.env.INameEnvironment;
import net.sourceforge.phpdt.internal.compiler.env.NameEnvironmentAnswer;
import net.sourceforge.phpdt.internal.compiler.util.SuffixConstants;

public class FileSystem
implements INameEnvironment,
SuffixConstants {
    Classpath[] classpaths;
    String[] knownFileNames;

    public FileSystem(String[] classpathNames, String[] initialFileNames, String encoding) {
        this(classpathNames, initialFileNames, encoding, null);
    }

    public FileSystem(String[] classpathNames, String[] initialFileNames, String encoding, int[] classpathDirectoryModes) {
        int classpathSize = classpathNames.length;
        this.classpaths = new Classpath[classpathSize];
        String[] pathNames = new String[classpathSize];
        int problemsOccured = 0;
        int i = 0;
        while (i < classpathSize) {
            File file = new File(this.convertPathSeparators(classpathNames[i]));
            if (file.isDirectory()) {
                if (file.exists()) {
                    this.classpaths[i] = classpathDirectoryModes == null ? new ClasspathDirectory(file, encoding) : new ClasspathDirectory(file, encoding, classpathDirectoryModes[i]);
                    pathNames[i] = ((ClasspathDirectory)this.classpaths[i]).path;
                }
            } else {
                classpathNames[i].toLowerCase();
            }
            if (this.classpaths[i] == null) {
                ++problemsOccured;
            }
            ++i;
        }
        if (problemsOccured > 0) {
            Classpath[] newPaths = new Classpath[classpathSize - problemsOccured];
            String[] newNames = new String[classpathSize - problemsOccured];
            int i2 = 0;
            int current = 0;
            while (i2 < classpathSize) {
                if (this.classpaths[i2] != null) {
                    newPaths[current] = this.classpaths[i2];
                    newNames[current++] = pathNames[i2];
                }
                ++i2;
            }
            classpathSize = newPaths.length;
            this.classpaths = newPaths;
            pathNames = newNames;
        }
        this.knownFileNames = new String[initialFileNames.length];
        i = initialFileNames.length;
        while (--i >= 0) {
            String fileName = initialFileNames[i];
            String matchingPathName = null;
            if (fileName.lastIndexOf(".") != -1) {
                fileName = fileName.substring(0, fileName.lastIndexOf(46));
            }
            fileName = this.convertPathSeparators(fileName);
            int j = 0;
            while (j < classpathSize) {
                if (fileName.startsWith(pathNames[j])) {
                    matchingPathName = pathNames[j];
                }
                ++j;
            }
            this.knownFileNames[i] = matchingPathName == null ? fileName : fileName.substring(matchingPathName.length());
        }
    }

    public void cleanup() {
        int i = 0;
        int max = this.classpaths.length;
        while (i < max) {
            this.classpaths[i].reset();
            ++i;
        }
    }

    private String convertPathSeparators(String path) {
        return File.separatorChar == '/' ? path.replace('\\', '/') : path.replace('/', '\\');
    }

    public NameEnvironmentAnswer findType(char[][] compoundName) {
        return null;
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        return null;
    }

    public boolean isPackage(char[][] compoundName, char[] packageName) {
        String qp2;
        String qualifiedPackageName = new String(CharOperation.concatWith(compoundName, packageName, '/'));
        String string = qp2 = File.separatorChar == '/' ? qualifiedPackageName : qualifiedPackageName.replace('/', File.separatorChar);
        if (qualifiedPackageName == qp2) {
            int i = 0;
            int length = this.classpaths.length;
            while (i < length) {
                if (this.classpaths[i].isPackage(qualifiedPackageName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    static interface Classpath {
        public NameEnvironmentAnswer findClass(char[] var1, String var2, String var3);

        public boolean isPackage(String var1);

        public void reset();
    }
}

