/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.flow;

import net.sourceforge.phpdt.internal.compiler.ast.ASTNode;
import net.sourceforge.phpdt.internal.compiler.ast.Reference;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.FieldBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.LocalVariableBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.VariableBinding;

public class FinallyFlowContext
extends FlowContext {
    Reference[] finalAssignments;
    VariableBinding[] finalVariables;
    int assignCount;

    public FinallyFlowContext(FlowContext parent, ASTNode associatedNode) {
        super(parent, associatedNode);
    }

    public void complainOnRedundantFinalAssignments(FlowInfo flowInfo, BlockScope scope) {
        int i = 0;
        while (i < this.assignCount) {
            VariableBinding variable = this.finalVariables[i];
            if (variable != null) {
                boolean complained = false;
                if (variable instanceof FieldBinding) {
                    if (flowInfo.isPotentiallyAssigned((FieldBinding)variable)) {
                        complained = true;
                        scope.problemReporter().duplicateInitializationOfBlankFinalField((FieldBinding)variable, this.finalAssignments[i]);
                    }
                } else if (flowInfo.isPotentiallyAssigned((LocalVariableBinding)variable)) {
                    complained = true;
                    scope.problemReporter().duplicateInitializationOfFinalLocal((LocalVariableBinding)variable, this.finalAssignments[i]);
                }
                if (complained) {
                    FlowContext currentContext = this.parent;
                    while (currentContext != null) {
                        currentContext.removeFinalAssignmentIfAny(this.finalAssignments[i]);
                        currentContext = currentContext.parent;
                    }
                }
            }
            ++i;
        }
    }

    public String individualToString() {
        StringBuffer buffer = new StringBuffer("Finally flow context");
        buffer.append("[finalAssignments count -").append(this.assignCount).append(']');
        return buffer.toString();
    }

    public boolean isSubRoutine() {
        return true;
    }

    boolean recordFinalAssignment(VariableBinding binding, Reference finalAssignment) {
        if (this.assignCount == 0) {
            this.finalAssignments = new Reference[5];
            this.finalVariables = new VariableBinding[5];
        } else {
            if (this.assignCount == this.finalAssignments.length) {
                this.finalAssignments = new Reference[this.assignCount * 2];
                System.arraycopy(this.finalAssignments, 0, this.finalAssignments, 0, this.assignCount);
            }
            this.finalVariables = new VariableBinding[this.assignCount * 2];
            System.arraycopy(this.finalVariables, 0, this.finalVariables, 0, this.assignCount);
        }
        this.finalAssignments[this.assignCount] = finalAssignment;
        this.finalVariables[this.assignCount++] = binding;
        return true;
    }

    void removeFinalAssignmentIfAny(Reference reference) {
        int i = 0;
        while (i < this.assignCount) {
            if (this.finalAssignments[i] == reference) {
                this.finalAssignments[i] = null;
                this.finalVariables[i] = null;
                return;
            }
            ++i;
        }
    }
}

