/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaModelStatus;
import net.sourceforge.phpdt.core.IJavaModelStatusConstants;
import net.sourceforge.phpdt.internal.core.util.Util;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class JavaModelStatus
extends Status
implements IJavaModelStatus,
IJavaModelStatusConstants,
IResourceStatus {
    protected IJavaElement[] fElements = new IJavaElement[0];
    protected IPath fPath;
    protected String fString;
    protected static final IStatus[] fgEmptyChildren = new IStatus[0];
    protected IStatus[] fChildren = fgEmptyChildren;
    protected static IJavaElement[] fgObjectEmptyChildren = new IJavaElement[0];
    public static final IJavaModelStatus VERIFIED_OK = new JavaModelStatus(0, 0, Util.bind("status.OK"));

    public JavaModelStatus() {
        super(4, "net.sourceforge.phpeclipse", 0, "JavaModelStatus", null);
    }

    public JavaModelStatus(int code) {
        super(4, "net.sourceforge.phpeclipse", code, "JavaModelStatus", null);
        this.fElements = fgObjectEmptyChildren;
    }

    public JavaModelStatus(int code, IJavaElement[] elements) {
        super(4, "net.sourceforge.phpeclipse", code, "JavaModelStatus", null);
        this.fElements = elements;
        this.fPath = null;
    }

    public JavaModelStatus(int code, String string) {
        this(4, code, string);
    }

    public JavaModelStatus(int severity, int code, String string) {
        super(severity, "net.sourceforge.phpeclipse", code, "JavaModelStatus", null);
        this.fElements = fgObjectEmptyChildren;
        this.fPath = null;
        this.fString = string;
    }

    public JavaModelStatus(int code, Throwable throwable) {
        super(4, "net.sourceforge.phpeclipse", code, "JavaModelStatus", throwable);
        this.fElements = fgObjectEmptyChildren;
    }

    public JavaModelStatus(int code, IPath path) {
        super(4, "net.sourceforge.phpeclipse", code, "JavaModelStatus", null);
        this.fElements = fgObjectEmptyChildren;
        this.fPath = path;
    }

    public JavaModelStatus(int code, IJavaElement element) {
        this(code, new IJavaElement[]{element});
    }

    public JavaModelStatus(int code, IJavaElement element, String string) {
        this(code, new IJavaElement[]{element});
        this.fString = string;
    }

    public JavaModelStatus(int code, IJavaElement element, IPath path) {
        this(code, new IJavaElement[]{element});
        this.fPath = path;
    }

    public JavaModelStatus(CoreException coreException) {
        super(4, "net.sourceforge.phpeclipse", 966, "JavaModelStatus", (Throwable)coreException);
        this.fElements = fgObjectEmptyChildren;
    }

    protected int getBits() {
        int severity = 1 << this.getCode() % 100 / 33;
        int category = 1 << this.getCode() / 100 + 3;
        return severity | category;
    }

    public IStatus[] getChildren() {
        return this.fChildren;
    }

    public IJavaElement[] getElements() {
        return this.fElements;
    }

    public String getMessage() {
        Throwable exception = this.getException();
        if (exception == null) {
            switch (this.getCode()) {
                case 966: {
                    return Util.bind("status.coreException");
                }
                case 990: {
                    return Util.bind("build.initializationError");
                }
                case 991: {
                    return Util.bind("build.serializationError");
                }
                case 973: {
                    return Util.bind("status.cannotUseDeviceOnPath", this.getPath().toString());
                }
                case 986: {
                    return Util.bind("status.JDOMError");
                }
                case 992: {
                    return Util.bind("status.evaluationError", this.fString);
                }
                case 980: {
                    return Util.bind("status.indexOutOfBounds");
                }
                case 984: {
                    return Util.bind("status.invalidContents");
                }
                case 983: {
                    return Util.bind("status.invalidName", this.fString);
                }
                case 998: {
                    return Util.bind("status.invalidPackage", this.fString);
                }
                case 979: {
                    if (this.fString != null) {
                        return this.fString;
                    }
                    return Util.bind("status.invalidPath", this.getPath() == null ? "null" : this.getPath().toString());
                }
                case 997: {
                    return Util.bind("status.invalidProject", this.fString);
                }
                case 995: {
                    return Util.bind("status.invalidResource", this.fString);
                }
                case 996: {
                    return Util.bind("status.invalidResourceType", this.fString);
                }
                case 985: {
                    return Util.bind("status.IOException");
                }
                case 968: {
                    return Util.bind("operation.needElements");
                }
                case 982: {
                    return Util.bind("operation.needName");
                }
                case 970: {
                    return Util.bind("operation.needPath");
                }
                case 974: {
                    return Util.bind("operation.needString");
                }
                case 972: {
                    return Util.bind("operation.needAbsolutePath", this.getPath().toString());
                }
                case 987: {
                    return Util.bind("status.targetException");
                }
                case 981: {
                    return Util.bind("status.updateConflict");
                }
                case 999: {
                    return Util.bind("status.noLocalContents", this.getPath().toString());
                }
            }
            if (this.fString != null) {
                return this.fString;
            }
            return "";
        }
        String message = exception.getMessage();
        if (message != null) {
            return message;
        }
        return exception.toString();
    }

    public IPath getPath() {
        return this.fPath;
    }

    public int getSeverity() {
        if (this.fChildren == fgEmptyChildren) {
            return super.getSeverity();
        }
        int severity = -1;
        int i = 0;
        int max = this.fChildren.length;
        while (i < max) {
            int childrenSeverity = this.fChildren[i].getSeverity();
            if (childrenSeverity > severity) {
                severity = childrenSeverity;
            }
            ++i;
        }
        return severity;
    }

    public String getString() {
        return this.fString;
    }

    public boolean isDoesNotExist() {
        return this.getCode() == 969;
    }

    public boolean isMultiStatus() {
        return this.fChildren != fgEmptyChildren;
    }

    public boolean isOK() {
        return this.getCode() == 0;
    }

    public boolean matches(int mask) {
        if (!this.isMultiStatus()) {
            return this.matches(this, mask);
        }
        int i = 0;
        int max = this.fChildren.length;
        while (i < max) {
            if (this.matches((JavaModelStatus)this.fChildren[i], mask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean matches(JavaModelStatus status, int mask) {
        int severityMask = mask & 7;
        int categoryMask = mask & 0xFFFFFFF8;
        int bits = status.getBits();
        return !(severityMask != 0 && (bits & severityMask) == 0 || categoryMask != 0 && (bits & categoryMask) == 0);
    }

    public static IJavaModelStatus newMultiStatus(IJavaModelStatus[] children) {
        JavaModelStatus jms = new JavaModelStatus();
        jms.fChildren = children;
        return jms;
    }

    public String toString() {
        if (this == VERIFIED_OK) {
            return "JavaModelStatus[OK]";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Java Model Status [");
        buffer.append(this.getMessage());
        buffer.append("]");
        return buffer.toString();
    }
}

