/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.util.ArrayList;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IField;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IMember;
import net.sourceforge.phpdt.core.IMethod;
import net.sourceforge.phpdt.core.IPackageFragment;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.core.ITypeHierarchy;
import net.sourceforge.phpdt.core.IWorkingCopy;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.jdom.IDOMNode;
import net.sourceforge.phpdt.internal.core.JavaElement;
import net.sourceforge.phpdt.internal.core.Member;
import net.sourceforge.phpdt.internal.core.SourceField;
import net.sourceforge.phpdt.internal.core.SourceMethod;
import net.sourceforge.phpdt.internal.core.SourceTypeElementInfo;
import net.sourceforge.phpdt.internal.core.util.Util;
import net.sourceforge.phpdt.internal.corext.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class SourceType
extends Member
implements IType {
    protected static final String[] fgEmptyList = new String[0];

    protected SourceType(JavaElement parent, String name) {
        super(parent, name);
        Assert.isTrue(name.indexOf(46) == -1, Util.bind("sourcetype.invalidName", name));
    }

    protected boolean equalsDOMNode(IDOMNode node) throws JavaModelException {
        return node.getNodeType() == 4 && super.equalsDOMNode(node);
    }

    public IMethod[] findMethods(IMethod method) {
        try {
            return this.findMethods(method, this.getMethods());
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IType getDeclaringType() {
        for (IJavaElement parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getElementType() == 7) {
                return (IType)parent;
            }
            if (parent instanceof IMember) {
                continue;
            }
            return null;
        }
        return null;
    }

    public int getElementType() {
        return 7;
    }

    public IField getField(String name) {
        return new SourceField(this, name);
    }

    public IField[] getFields() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(8);
        IField[] array = new IField[list.size()];
        list.toArray(array);
        return array;
    }

    public String getFullyQualifiedName() {
        return this.getFullyQualifiedName('$');
    }

    public String getFullyQualifiedName(char enclosingTypeSeparator) {
        String packageName = this.getPackageFragment().getElementName();
        if (packageName.equals("")) {
            return this.getTypeQualifiedName(enclosingTypeSeparator);
        }
        return String.valueOf(packageName) + '.' + this.getTypeQualifiedName(enclosingTypeSeparator);
    }

    public IMethod getMethod(String name, String[] parameterTypeSignatures) {
        return new SourceMethod(this, name, parameterTypeSignatures);
    }

    public IMethod[] getMethods() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(9);
        IMethod[] array = new IMethod[list.size()];
        list.toArray(array);
        return array;
    }

    public IPackageFragment getPackageFragment() {
        IJavaElement parentElement = this.parent;
        while (parentElement != null) {
            if (parentElement.getElementType() == 4) {
                return (IPackageFragment)parentElement;
            }
            parentElement = parentElement.getParent();
        }
        Assert.isTrue(false);
        return null;
    }

    public String getSuperclassName() throws JavaModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        char[] superclassName = info.getSuperclassName();
        if (superclassName == null) {
            return null;
        }
        return new String(superclassName);
    }

    public String[] getSuperInterfaceNames() throws JavaModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        char[][] names = info.getInterfaceNames();
        if (names == null) {
            return fgEmptyList;
        }
        String[] strings = new String[names.length];
        int i = 0;
        while (i < names.length) {
            strings[i] = new String(names[i]);
            ++i;
        }
        return strings;
    }

    public IType getType(String name) {
        return new SourceType(this, name);
    }

    public String getTypeQualifiedName() {
        return this.getTypeQualifiedName('$');
    }

    public String getTypeQualifiedName(char enclosingTypeSeparator) {
        if (this.parent.getElementType() == 5) {
            return this.name;
        }
        return String.valueOf(((IType)((Object)this.parent)).getTypeQualifiedName(enclosingTypeSeparator)) + enclosingTypeSeparator + this.name;
    }

    public IType[] getTypes() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(7);
        IType[] array = new IType[list.size()];
        list.toArray(array);
        return array;
    }

    public boolean hasChildren() throws JavaModelException {
        return this.getChildren().length > 0;
    }

    public boolean isAnonymous() throws JavaModelException {
        return false;
    }

    public boolean isClass() throws JavaModelException {
        return !this.isInterface();
    }

    public boolean isInterface() throws JavaModelException {
        Object obj = this.getElementInfo();
        if (obj instanceof SourceTypeElementInfo) {
            SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
            return info.isInterface();
        }
        return false;
    }

    public boolean isLocal() throws JavaModelException {
        return false;
    }

    public boolean isMember() throws JavaModelException {
        return this.getDeclaringType() != null;
    }

    public ITypeHierarchy newSupertypeHierarchy(IWorkingCopy[] workingCopies, IProgressMonitor monitor) throws JavaModelException {
        IWorkingCopy[] copies;
        if (workingCopies == null) {
            copies = null;
        } else {
            int length = workingCopies.length;
            copies = new ICompilationUnit[length];
            System.arraycopy(workingCopies, 0, copies, 0, length);
        }
        return this.newSupertypeHierarchy(copies, monitor);
    }

    public ITypeHierarchy newTypeHierarchy(IWorkingCopy[] workingCopies, IProgressMonitor monitor) throws JavaModelException {
        IWorkingCopy[] copies;
        if (workingCopies == null) {
            copies = null;
        } else {
            int length = workingCopies.length;
            copies = new ICompilationUnit[length];
            System.arraycopy(workingCopies, 0, copies, 0, length);
        }
        return this.newTypeHierarchy(copies, monitor);
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            buffer.append(this.getElementName());
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            buffer.append(this.getElementName());
        } else {
            try {
                if (this.isInterface()) {
                    buffer.append("interface ");
                } else {
                    buffer.append("class ");
                }
                buffer.append(this.getElementName());
            }
            catch (JavaModelException javaModelException) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }
}

