/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core.builder;

import java.util.ArrayList;
import net.sourceforge.phpdt.internal.compiler.util.Util;
import net.sourceforge.phpdt.internal.core.builder.AbstractImageBuilder;
import net.sourceforge.phpdt.internal.core.builder.ClasspathMultiDirectory;
import net.sourceforge.phpdt.internal.core.builder.PHPBuilder;
import net.sourceforge.phpdt.internal.core.builder.SourceFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class BatchImageBuilder
extends AbstractImageBuilder {
    protected BatchImageBuilder(PHPBuilder javaBuilder) {
        super(javaBuilder);
        this.nameEnvironment.isIncrementalBuild = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build() {
        if (PHPBuilder.DEBUG) {
            System.out.println("FULL build");
        }
        try {
            try {
                this.notifier.subTask(net.sourceforge.phpdt.internal.core.util.Util.bind("build.cleaningOutput"));
                PHPBuilder.removeProblemsAndTasksFor((IResource)this.javaBuilder.currentProject);
                this.notifier.updateProgressDelta(0.1f);
                this.notifier.subTask(net.sourceforge.phpdt.internal.core.util.Util.bind("build.analyzingSources"));
                ArrayList sourceFiles = new ArrayList(33);
                this.addAllSourceFiles(sourceFiles);
                this.notifier.updateProgressDelta(0.15f);
                if (sourceFiles.size() > 0) {
                    SourceFile[] allSourceFiles = new SourceFile[sourceFiles.size()];
                    sourceFiles.toArray(allSourceFiles);
                    this.notifier.setProgressPerCompilationUnit(0.75f / (float)allSourceFiles.length);
                    this.workQueue.addAll(allSourceFiles);
                    this.compile(allSourceFiles);
                }
                if (this.javaBuilder.javaProject.hasCycleMarker()) {
                    this.javaBuilder.mustPropagateStructuralChanges();
                }
            }
            catch (CoreException e) {
                throw this.internalException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.cleanUp();
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        this.cleanUp();
    }

    protected void addAllSourceFiles(final ArrayList sourceFiles) throws CoreException {
        int i = 0;
        int l = this.sourceLocations.length;
        while (i < l) {
            final ClasspathMultiDirectory sourceLocation = this.sourceLocations[i];
            final char[][] exclusionPatterns = sourceLocation.exclusionPatterns;
            final boolean isAlsoProject = sourceLocation.sourceFolder.equals((Object)this.javaBuilder.currentProject);
            sourceLocation.sourceFolder.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    IResource resource = null;
                    if (exclusionPatterns != null && net.sourceforge.phpdt.internal.core.util.Util.isExcluded(resource = proxy.requestResource(), exclusionPatterns)) {
                        return false;
                    }
                    switch (proxy.getType()) {
                        case 1: {
                            if (Util.isJavaFileName(proxy.getName())) {
                                if (resource == null) {
                                    resource = proxy.requestResource();
                                }
                                sourceFiles.add(new SourceFile((IFile)resource, sourceLocation, ((IFile)resource).getCharset()));
                            }
                            return false;
                        }
                        case 2: {
                            if (!isAlsoProject || !BatchImageBuilder.this.isExcludedFromProject(proxy.requestFullPath())) break;
                            return false;
                        }
                    }
                    return true;
                }
            }, 0);
            this.notifier.checkCancel();
            ++i;
        }
    }

    protected void cleanOutputFolders() throws CoreException {
        boolean deleteAll = "clean".equals(this.javaBuilder.javaProject.getOption("net.sourceforge.phpeclipse.builder.cleanOutputFolder", true));
        if (deleteAll) {
            ArrayList<IContainer> visited = new ArrayList<IContainer>(this.sourceLocations.length);
            int i = 0;
            int l = this.sourceLocations.length;
            while (i < l) {
                this.notifier.subTask(net.sourceforge.phpdt.internal.core.util.Util.bind("build.cleaningOutput"));
                ClasspathMultiDirectory sourceLocation = this.sourceLocations[i];
                if (sourceLocation.hasIndependentOutputFolder) {
                    IContainer outputFolder = sourceLocation.binaryFolder;
                    if (!visited.contains(outputFolder)) {
                        visited.add(outputFolder);
                        IResource[] members = outputFolder.members();
                        int j = 0;
                        int m = members.length;
                        while (j < m) {
                            members[j].delete(1, null);
                            ++j;
                        }
                    }
                    this.notifier.checkCancel();
                    this.copyExtraResourcesBack(sourceLocation, deleteAll);
                } else {
                    boolean isOutputFolder = sourceLocation.sourceFolder.equals((Object)sourceLocation.binaryFolder);
                    final char[][] exclusionPatterns = isOutputFolder ? sourceLocation.exclusionPatterns : null;
                    sourceLocation.binaryFolder.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) throws CoreException {
                            IResource resource = null;
                            if (exclusionPatterns != null && net.sourceforge.phpdt.internal.core.util.Util.isExcluded(resource = proxy.requestResource(), exclusionPatterns)) {
                                return false;
                            }
                            if (proxy.getType() == 1) {
                                return false;
                            }
                            BatchImageBuilder.this.notifier.checkCancel();
                            return true;
                        }
                    }, 0);
                    if (!isOutputFolder) {
                        this.notifier.checkCancel();
                        this.copyPackages(sourceLocation);
                    }
                }
                this.notifier.checkCancel();
                ++i;
            }
        } else {
            int i = 0;
            int l = this.sourceLocations.length;
            while (i < l) {
                ClasspathMultiDirectory sourceLocation = this.sourceLocations[i];
                if (sourceLocation.hasIndependentOutputFolder) {
                    this.copyExtraResourcesBack(sourceLocation, deleteAll);
                } else if (!sourceLocation.sourceFolder.equals((Object)sourceLocation.binaryFolder)) {
                    this.copyPackages(sourceLocation);
                }
                this.notifier.checkCancel();
                ++i;
            }
        }
    }

    protected void copyExtraResourcesBack(ClasspathMultiDirectory sourceLocation, final boolean deletedAll) throws CoreException {
        this.notifier.subTask(net.sourceforge.phpdt.internal.core.util.Util.bind("build.copyingResources"));
        final int segmentCount = sourceLocation.sourceFolder.getFullPath().segmentCount();
        final char[][] exclusionPatterns = sourceLocation.exclusionPatterns;
        final IContainer outputFolder = sourceLocation.binaryFolder;
        final boolean isAlsoProject = sourceLocation.sourceFolder.equals((Object)this.javaBuilder.currentProject);
        sourceLocation.sourceFolder.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                IResource resource = null;
                switch (proxy.getType()) {
                    case 1: {
                        if (Util.isJavaFileName(proxy.getName())) {
                            return false;
                        }
                        resource = proxy.requestResource();
                        if (BatchImageBuilder.this.javaBuilder.filterExtraResource(resource)) {
                            return false;
                        }
                        if (exclusionPatterns != null && net.sourceforge.phpdt.internal.core.util.Util.isExcluded(resource, exclusionPatterns)) {
                            return false;
                        }
                        IPath partialPath = resource.getFullPath().removeFirstSegments(segmentCount);
                        IFile copiedResource = outputFolder.getFile(partialPath);
                        if (copiedResource.exists()) {
                            if (deletedAll) {
                                BatchImageBuilder.this.createErrorFor(resource, net.sourceforge.phpdt.internal.core.util.Util.bind("build.duplicateResource"));
                                return false;
                            }
                            copiedResource.delete(1, null);
                        }
                        resource.copy(copiedResource.getFullPath(), 1, null);
                        copiedResource.setDerived(true);
                        return false;
                    }
                    case 2: {
                        resource = proxy.requestResource();
                        if (BatchImageBuilder.this.javaBuilder.filterExtraResource(resource)) {
                            return false;
                        }
                        if (exclusionPatterns != null && net.sourceforge.phpdt.internal.core.util.Util.isExcluded(resource, exclusionPatterns)) {
                            return false;
                        }
                        IPath folderPath = resource.getFullPath();
                        if (!isAlsoProject || !BatchImageBuilder.this.isExcludedFromProject(folderPath)) break;
                        return false;
                    }
                }
                return true;
            }
        }, 0);
    }

    protected void copyPackages(ClasspathMultiDirectory sourceLocation) throws CoreException {
        sourceLocation.sourceFolder.getFullPath().segmentCount();
        final char[][] exclusionPatterns = sourceLocation.exclusionPatterns;
        IContainer cfr_ignored_0 = sourceLocation.binaryFolder;
        final boolean isAlsoProject = sourceLocation.sourceFolder.equals((Object)this.javaBuilder.currentProject);
        sourceLocation.sourceFolder.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                switch (proxy.getType()) {
                    case 1: {
                        return false;
                    }
                    case 2: {
                        IResource resource = proxy.requestResource();
                        if (BatchImageBuilder.this.javaBuilder.filterExtraResource(resource)) {
                            return false;
                        }
                        if (exclusionPatterns != null && net.sourceforge.phpdt.internal.core.util.Util.isExcluded(resource, exclusionPatterns)) {
                            return false;
                        }
                        IPath folderPath = resource.getFullPath();
                        if (!isAlsoProject || !BatchImageBuilder.this.isExcludedFromProject(folderPath)) break;
                        return false;
                    }
                }
                return true;
            }
        }, 0);
    }

    public String toString() {
        return "batch image builder for:\n\tnew state: " + this.newState;
    }
}

