/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core.jdom;

import java.util.Map;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.core.jdom.IDOMCompilationUnit;
import net.sourceforge.phpdt.internal.compiler.ISourceElementRequestor;
import net.sourceforge.phpdt.internal.compiler.SourceElementParser;
import net.sourceforge.phpdt.internal.compiler.env.ICompilationUnit;
import net.sourceforge.phpdt.internal.compiler.impl.CompilerOptions;
import net.sourceforge.phpdt.internal.compiler.problem.DefaultProblemFactory;
import net.sourceforge.phpdt.internal.core.jdom.AbstractDOMBuilder;
import net.sourceforge.phpdt.internal.core.jdom.DOMField;
import net.sourceforge.phpdt.internal.core.jdom.DOMImport;
import net.sourceforge.phpdt.internal.core.jdom.DOMInitializer;
import net.sourceforge.phpdt.internal.core.jdom.DOMMember;
import net.sourceforge.phpdt.internal.core.jdom.DOMMethod;
import net.sourceforge.phpdt.internal.core.jdom.DOMPackage;
import net.sourceforge.phpdt.internal.core.jdom.DOMType;
import net.sourceforge.phpdt.internal.core.util.CharArrayOps;

public class SimpleDOMBuilder
extends AbstractDOMBuilder
implements ISourceElementRequestor {
    public void acceptImport(int declarationStart, int declarationEnd, char[] name, boolean onDemand) {
        int[] sourceRange = new int[]{declarationStart, declarationEnd};
        String importName = new String(name);
        if (onDemand) {
            importName = String.valueOf(importName) + ".*";
        }
        this.fNode = new DOMImport(this.fDocument, sourceRange, importName, onDemand);
        this.addChild(this.fNode);
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        int[] sourceRange = new int[]{declarationStart, declarationEnd};
        this.fNode = new DOMPackage(this.fDocument, sourceRange, CharArrayOps.charToString(name));
        this.addChild(this.fNode);
    }

    public IDOMCompilationUnit createCompilationUnit(String sourceCode, String name) {
        return this.createCompilationUnit(sourceCode.toCharArray(), name.toCharArray());
    }

    public IDOMCompilationUnit createCompilationUnit(ICompilationUnit compilationUnit) {
        this.initializeBuild(compilationUnit.getContents(), true, true);
        this.getParser(JavaCore.getOptions()).parseCompilationUnit(compilationUnit, false);
        return super.createCompilationUnit(compilationUnit);
    }

    protected void enterAbstractMethod(int declarationStart, int modifiers, char[] returnType, char[] name, int nameStart, int nameEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes, boolean isConstructor) {
        int[] sourceRange = new int[]{declarationStart, -1};
        int[] nameRange = new int[]{nameStart, nameEnd};
        this.fNode = new DOMMethod(this.fDocument, sourceRange, CharArrayOps.charToString(name), nameRange, modifiers, isConstructor, CharArrayOps.charToString(returnType), CharArrayOps.charcharToString(parameterTypes), CharArrayOps.charcharToString(parameterNames), CharArrayOps.charcharToString(exceptionTypes));
        this.addChild(this.fNode);
        this.fStack.push(this.fNode);
    }

    public void enterClass(int declarationStart, int modifiers, char[] name, int nameStart, int nameEnd, char[] superclass, char[][] superinterfaces) {
        this.enterType(declarationStart, modifiers, name, nameStart, nameEnd, superclass, superinterfaces, true);
    }

    public void enterConstructor(int declarationStart, int modifiers, char[] name, int nameStart, int nameEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        String nameString = new String(this.fDocument, nameStart, nameEnd - nameStart);
        int openParenPosition = nameString.indexOf(40);
        if (openParenPosition > -1) {
            nameEnd = nameStart + openParenPosition - 1;
        }
        this.enterAbstractMethod(declarationStart, modifiers, null, name, nameStart, nameEnd, parameterTypes, parameterNames, exceptionTypes, true);
    }

    public void enterField(int declarationStart, int modifiers, char[] type, char[] name, int nameStart, int nameEnd) {
        int[] sourceRange = new int[]{declarationStart, -1};
        int[] nameRange = new int[]{nameStart, nameEnd};
        boolean isSecondary = false;
        if (this.fNode instanceof DOMField) {
            isSecondary = declarationStart == this.fNode.fSourceRange[0];
        }
        this.fNode = new DOMField(this.fDocument, sourceRange, CharArrayOps.charToString(name), nameRange, modifiers, CharArrayOps.charToString(type), isSecondary);
        this.addChild(this.fNode);
        this.fStack.push(this.fNode);
    }

    public void enterInitializer(int declarationSourceStart, int modifiers) {
        int[] sourceRange = new int[]{declarationSourceStart, -1};
        this.fNode = new DOMInitializer(this.fDocument, sourceRange, modifiers);
        this.addChild(this.fNode);
        this.fStack.push(this.fNode);
    }

    public void enterInterface(int declarationStart, int modifiers, char[] name, int nameStart, int nameEnd, char[][] superinterfaces) {
        this.enterType(declarationStart, modifiers, name, nameStart, nameEnd, null, superinterfaces, false);
    }

    public void enterMethod(int declarationStart, int modifiers, char[] returnType, char[] name, int nameStart, int nameEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        this.enterAbstractMethod(declarationStart, modifiers, returnType, name, nameStart, nameEnd, parameterTypes, parameterNames, exceptionTypes, false);
    }

    protected void enterType(int declarationStart, int modifiers, char[] name, int nameStart, int nameEnd, char[] superclass, char[][] superinterfaces, boolean isClass) {
        if (this.fBuildingType) {
            int[] sourceRange = new int[]{declarationStart, -1};
            int[] nameRange = new int[]{nameStart, nameEnd};
            this.fNode = new DOMType(this.fDocument, sourceRange, new String(name), nameRange, modifiers, CharArrayOps.charcharToString(superinterfaces), isClass);
            this.addChild(this.fNode);
            this.fStack.push(this.fNode);
        }
    }

    public void exitClass(int declarationEnd) {
        this.exitType(declarationEnd);
    }

    public void exitConstructor(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitInitializer(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitInterface(int declarationEnd) {
        this.exitType(declarationEnd);
    }

    protected void exitMember(int declarationEnd) {
        DOMMember m = (DOMMember)this.fStack.pop();
        m.setSourceRangeEnd(declarationEnd);
        this.fNode = m;
    }

    public void exitMethod(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void exitType(int declarationEnd) {
        this.exitType(declarationEnd, declarationEnd);
    }

    protected SourceElementParser getParser(Map settings) {
        return new SourceElementParser(this, new DefaultProblemFactory(), new CompilerOptions(settings));
    }
}

