/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IMember;
import net.sourceforge.phpdt.core.IOpenable;
import net.sourceforge.phpdt.internal.corext.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static IFile[] getFiles(ICompilationUnit[] cus) {
        ArrayList<IResource> files = new ArrayList<IResource>(cus.length);
        int i = 0;
        while (i < cus.length) {
            IResource resource = ResourceUtil.getResource(cus[i]);
            if (resource != null && resource.getType() == 1) {
                files.add(resource);
            }
            ++i;
        }
        return files.toArray(new IFile[files.size()]);
    }

    public static IFile getFile(ICompilationUnit cu) {
        IResource resource = ResourceUtil.getResource(cu);
        if (resource != null && resource.getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }

    public static IResource getResource(ICompilationUnit cu) {
        return cu.getResource();
    }

    public static IResource getResource(IMember member) {
        Assert.isTrue(!member.isBinary());
        return ResourceUtil.getResource(member.getCompilationUnit());
    }

    public static IResource getResource(Object o) {
        if (o instanceof IResource) {
            return (IResource)o;
        }
        if (o instanceof IJavaElement) {
            return ResourceUtil.getResource((IJavaElement)o);
        }
        return null;
    }

    private static IResource getResource(IJavaElement element) {
        if (element.getElementType() == 5) {
            return ResourceUtil.getResource((ICompilationUnit)element);
        }
        if (element instanceof IOpenable) {
            return element.getResource();
        }
        return null;
    }
}

