/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.template.php;

import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IMethod;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.Signature;
import net.sourceforge.phpdt.internal.corext.template.php.CompilationUnitContext;
import net.sourceforge.phpdt.internal.corext.template.php.JavaTemplateMessages;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public abstract class CompilationUnitContextType
extends TemplateContextType {
    public CompilationUnitContextType(String name) {
        super(name);
    }

    public abstract CompilationUnitContext createContext(IDocument var1, int var2, int var3, ICompilationUnit var4);

    protected void validateVariables(TemplateVariable[] variables) throws TemplateException {
        int i = 0;
        while (i < variables.length) {
            TemplateVariable var = variables[i];
            if (var.getType().equals("cursor") && var.getOffsets().length > 1) {
                throw new TemplateException(JavaTemplateMessages.getString("ContextType.error.multiple.cursor.variables"));
            }
            ++i;
        }
    }

    protected static class Arguments
    extends TemplateVariableResolver {
        public Arguments() {
            super("enclosing_method_arguments", JavaTemplateMessages.getString("CompilationUnitContextType.variable.description.enclosing.method.arguments"));
        }

        protected String resolve(TemplateContext context) {
            IJavaElement element = ((CompilationUnitContext)context).findEnclosingElement(9);
            if (element == null) {
                return null;
            }
            IMethod method = (IMethod)element;
            try {
                String[] arguments = method.getParameterNames();
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < arguments.length) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(arguments[i]);
                    ++i;
                }
                return buffer.toString();
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
    }

    protected static class EnclosingJavaElement
    extends TemplateVariableResolver {
        protected final int fElementType;

        public EnclosingJavaElement(String name, String description, int elementType) {
            super(name, description);
            this.fElementType = elementType;
        }

        protected String resolve(TemplateContext context) {
            IJavaElement element = ((CompilationUnitContext)context).findEnclosingElement(this.fElementType);
            return element == null ? null : element.getElementName();
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    protected static class File
    extends TemplateVariableResolver {
        public File() {
            super("file", JavaTemplateMessages.getString("CompilationUnitContextType.variable.description.file"));
        }

        protected String resolve(TemplateContext context) {
            ICompilationUnit unit = ((CompilationUnitContext)context).getCompilationUnit();
            return unit == null ? null : unit.getElementName();
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    protected static class Method
    extends EnclosingJavaElement {
        public Method() {
            super("enclosing_method", JavaTemplateMessages.getString("CompilationUnitContextType.variable.description.enclosing.method"), 9);
        }
    }

    protected static class Package
    extends EnclosingJavaElement {
        public Package() {
            super("enclosing_package", JavaTemplateMessages.getString("CompilationUnitContextType.variable.description.enclosing.package"), 4);
        }
    }

    protected static class PrimaryTypeName
    extends TemplateVariableResolver {
        public PrimaryTypeName() {
            super("primary_type_name", JavaTemplateMessages.getString("CompilationUnitContextType.variable.description.primary.type.name"));
        }

        protected String resolve(TemplateContext context) {
            ICompilationUnit unit = ((CompilationUnitContext)context).getCompilationUnit();
            if (unit == null) {
                return null;
            }
            String elementName = unit.getElementName();
            return elementName.substring(0, elementName.lastIndexOf(46));
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    protected static class Project
    extends EnclosingJavaElement {
        public Project() {
            super("enclosing_project", JavaTemplateMessages.getString("CompilationUnitContextType.variable.description.enclosing.project"), 2);
        }
    }

    protected static class ReturnType
    extends TemplateVariableResolver {
        public ReturnType() {
            super("return_type", JavaTemplateMessages.getString("CompilationUnitContextType.variable.description.return.type"));
        }

        protected String resolve(TemplateContext context) {
            IJavaElement element = ((CompilationUnitContext)context).findEnclosingElement(9);
            if (element == null) {
                return null;
            }
            try {
                return Signature.toString(((IMethod)element).getReturnType());
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
    }

    protected static class Type
    extends EnclosingJavaElement {
        public Type() {
            super("enclosing_type", JavaTemplateMessages.getString("CompilationUnitContextType.variable.description.enclosing.type"), 7);
        }
    }
}

