/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.template.php;

import java.lang.reflect.InvocationTargetException;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.internal.corext.Assert;
import net.sourceforge.phpdt.internal.corext.template.php.CompilationUnitCompletion;
import net.sourceforge.phpdt.internal.corext.template.php.CompilationUnitContext;
import net.sourceforge.phpdt.internal.corext.template.php.JavaFormatter;
import net.sourceforge.phpdt.internal.corext.template.php.JavaTemplateMessages;
import net.sourceforge.phpdt.internal.corext.util.Strings;
import net.sourceforge.phpdt.internal.ui.preferences.CodeFormatterPreferencePage;
import net.sourceforge.phpdt.internal.ui.text.template.contentassist.MultiVariable;
import net.sourceforge.phpdt.internal.ui.util.ExceptionHandler;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.widgets.Shell;

public class JavaContext
extends CompilationUnitContext {
    private static final String PLATFORM_LINE_DELIMITER = System.getProperty("line.separator");
    private CompilationUnitCompletion fCompletion;

    public JavaContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ICompilationUnit compilationUnit) {
        super(type, document, completionOffset, completionLength, compilationUnit);
    }

    private int getIndentation() {
        int start = this.getStart();
        IDocument document = this.getDocument();
        try {
            IRegion region = document.getLineInformationOfOffset(start);
            String lineContent = document.get(region.getOffset(), region.getLength());
            return Strings.computeIndent(lineContent, CodeFormatterPreferencePage.getTabSize());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            throw new TemplateException(JavaTemplateMessages.getString("Context.error.cannot.evaluate"));
        }
        TemplateTranslator translator = new TemplateTranslator(){

            protected TemplateVariable createVariable(String type, String name, int[] offsets) {
                return new MultiVariable(type, name, offsets);
            }
        };
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        String lineDelimiter = null;
        try {
            lineDelimiter = this.getDocument().getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {}
        if (lineDelimiter == null) {
            lineDelimiter = PLATFORM_LINE_DELIMITER;
        }
        PHPeclipsePlugin.getDefault().getPreferenceStore();
        boolean useCodeFormatter = false;
        JavaFormatter formatter = new JavaFormatter(lineDelimiter, this.getIndentation(), useCodeFormatter);
        formatter.format(buffer, (TemplateContext)this);
        return buffer;
    }

    public boolean canEvaluate(Template template) {
        String key = this.getKey();
        if (this.fForceEvaluation) {
            return true;
        }
        return template.matches(key, this.getContextType().getId()) && key.length() != 0 && template.getName().toLowerCase().startsWith(key.toLowerCase());
    }

    public boolean canEvaluate(String identifier) {
        String prefix = this.getKey();
        return identifier.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public int getStart() {
        try {
            IDocument document = this.getDocument();
            if (this.getCompletionLength() == 0) {
                int start = this.getCompletionOffset();
                while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                    --start;
                }
                if (start != 0 && (Character.isUnicodeIdentifierStart(document.getChar(start - 1)) || document.getChar(start - 1) == '$')) {
                    --start;
                }
                return start;
            }
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                --start;
            }
            if (start != 0 && (Character.isUnicodeIdentifierStart(document.getChar(start - 1)) || document.getChar(start - 1) == '$')) {
                --start;
            }
            while (start != end && Character.isWhitespace(document.getChar(start))) {
                ++start;
            }
            if (start == end) {
                start = this.getCompletionOffset();
            }
            return start;
        }
        catch (BadLocationException badLocationException) {
            return super.getStart();
        }
    }

    public int getEnd() {
        if (this.getCompletionLength() == 0) {
            return super.getEnd();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != end && Character.isWhitespace(document.getChar(end - 1))) {
                --end;
            }
            return end;
        }
        catch (BadLocationException badLocationException) {
            return super.getEnd();
        }
    }

    public String getKey() {
        try {
            IDocument document = this.getDocument();
            int start = this.getStart();
            int end = this.getCompletionOffset();
            return start <= end ? document.get(start, end - start) : "";
        }
        catch (BadLocationException badLocationException) {
            return super.getKey();
        }
    }

    public char getCharacterBeforeStart() {
        int start = this.getStart();
        try {
            return start == 0 ? (char)' ' : this.getDocument().getChar(start - 1);
        }
        catch (BadLocationException badLocationException) {
            return ' ';
        }
    }

    private static void handleException(Shell shell, Exception e) {
        String title = JavaTemplateMessages.getString("JavaContext.error.title");
        if (e instanceof CoreException) {
            ExceptionHandler.handle((CoreException)((Object)e), shell, title, null);
        } else if (e instanceof InvocationTargetException) {
            ExceptionHandler.handle((InvocationTargetException)e, shell, title, null);
        } else {
            PHPeclipsePlugin.log(e);
            MessageDialog.openError((Shell)shell, (String)title, (String)e.getMessage());
        }
    }

    private String firstOrNull(String[] strings) {
        if (strings.length > 0) {
            return strings[0];
        }
        return null;
    }

    private String getArrayTypeFromLocalArray(CompilationUnitCompletion completion, CompilationUnitCompletion.LocalVariable array) {
        String arrayTypeName = array.typeName;
        String typeName = JavaContext.getScalarType(arrayTypeName);
        int dimension = JavaContext.getArrayDimension(arrayTypeName) - 1;
        Assert.isTrue(dimension >= 0);
        String qualifiedName = JavaContext.createQualifiedTypeName(array.typePackageName, typeName);
        String innerTypeName = completion.simplifyTypeName(qualifiedName);
        return innerTypeName == null ? JavaContext.createArray(typeName, dimension) : JavaContext.createArray(innerTypeName, dimension);
    }

    private static String createArray(String type, int dimension) {
        StringBuffer buffer = new StringBuffer(type);
        int i = 0;
        while (i < dimension) {
            buffer.append("[]");
            ++i;
        }
        return buffer.toString();
    }

    private static String getScalarType(String type) {
        return type.substring(0, type.indexOf(91));
    }

    private static int getArrayDimension(String type) {
        int dimension = 0;
        int index = type.indexOf(91);
        while (index != -1) {
            ++dimension;
            index = type.indexOf(91, index + 1);
        }
        return dimension;
    }

    private static String createQualifiedTypeName(String packageName, String className) {
        StringBuffer buffer = new StringBuffer();
        if (packageName.length() != 0) {
            buffer.append(packageName);
            buffer.append('.');
        }
        buffer.append(className);
        return buffer.toString();
    }

    public static String evaluateTemplate(Template template, ICompilationUnit compilationUnit, int position) throws CoreException, BadLocationException, TemplateException {
        TemplateContextType contextType = PHPeclipsePlugin.getDefault().getTemplateContextRegistry().getContextType("java");
        if (contextType == null) {
            throw new CoreException((IStatus)new Status(4, "net.sourceforge.phpeclipse", 4, JavaTemplateMessages.getString("JavaContext.error.message"), null));
        }
        Document document = new Document();
        if (compilationUnit != null && compilationUnit.exists()) {
            document.set(compilationUnit.getSource());
        }
        JavaContext context = new JavaContext(contextType, (IDocument)document, position, 0, compilationUnit);
        context.setForceEvaluation(true);
        TemplateBuffer buffer = context.evaluate(template);
        if (buffer == null) {
            return null;
        }
        return buffer.getString();
    }
}

